/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.api.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingValue;

public abstract class AbstractScesimData {
    protected final List<FactMappingValue> factMappingValues = new ArrayList<FactMappingValue>();

    public List<FactMappingValue> getUnmodifiableFactMappingValues() {
        return Collections.unmodifiableList(this.factMappingValues);
    }

    public void removeFactMappingValueByIdentifiers(FactIdentifier factIdentifier, ExpressionIdentifier expressionIdentifier) {
        this.getFactMappingValue(factIdentifier, expressionIdentifier).ifPresent(this.factMappingValues::remove);
    }

    public void removeFactMappingValue(FactMappingValue toRemove) {
        this.factMappingValues.remove(toRemove);
    }

    public FactMappingValue addMappingValue(FactIdentifier factIdentifier, ExpressionIdentifier expressionIdentifier, Object value) {
        String factName = factIdentifier.getName();
        if (this.getFactMappingValue(factIdentifier, expressionIdentifier).isPresent()) {
            throw new IllegalArgumentException("A fact value for expression '" + expressionIdentifier.getName() + "' and fact '" + factName + "' already exist");
        }
        FactMappingValue factMappingValue = new FactMappingValue(factIdentifier, expressionIdentifier, value);
        this.factMappingValues.add(factMappingValue);
        return factMappingValue;
    }

    public FactMappingValue addOrUpdateMappingValue(FactIdentifier factIdentifier, ExpressionIdentifier expressionIdentifier, Object value) {
        return this.getFactMappingValue(factIdentifier, expressionIdentifier).map(e -> {
            e.setRawValue(value);
            return e;
        }).orElseGet(() -> this.addMappingValue(factIdentifier, expressionIdentifier, value));
    }

    public Optional<FactMappingValue> getFactMappingValue(FactIdentifier factIdentifier, ExpressionIdentifier expressionIdentifier) {
        return this.factMappingValues.stream().filter(e -> e.getFactIdentifier().equals(factIdentifier) && e.getExpressionIdentifier().equals(expressionIdentifier)).findFirst();
    }

    public Optional<FactMappingValue> getFactMappingValue(FactMapping factMapping) {
        return this.getFactMappingValue(factMapping.getFactIdentifier(), factMapping.getExpressionIdentifier());
    }

    public List<FactMappingValue> getFactMappingValuesByFactIdentifier(FactIdentifier factIdentifier) {
        return this.factMappingValues.stream().filter(e -> e.getFactIdentifier().equals(factIdentifier)).collect(Collectors.toList());
    }

    public String getDescription() {
        return this.factMappingValues.stream().filter(e -> e.getExpressionIdentifier().equals(ExpressionIdentifier.DESCRIPTION) && e.getFactIdentifier().equals(FactIdentifier.DESCRIPTION) && e.getRawValue() != null).map(e -> (String)e.getRawValue()).findFirst().orElse("");
    }

    public void setDescription(String name) {
        this.addOrUpdateMappingValue(FactIdentifier.DESCRIPTION, ExpressionIdentifier.DESCRIPTION, name);
    }

    public Collection<String> getFactNames() {
        return this.factMappingValues.stream().map(e -> e.getFactIdentifier().getName()).collect(Collectors.toSet());
    }

    public void resetErrors() {
        this.factMappingValues.forEach(FactMappingValue::resetStatus);
    }

    abstract AbstractScesimData cloneInstance();
}

