/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.functions.temporal;

import java.util.concurrent.TimeUnit;
import org.drools.model.functions.temporal.AbstractTemporalPredicate;
import org.drools.model.functions.temporal.Interval;
import org.drools.model.functions.temporal.TimeUtil;

public class DuringPredicate
extends AbstractTemporalPredicate<DuringPredicate> {
    private final long startMinDev;
    private final long startMaxDev;
    private final long endMinDev;
    private final long endMaxDev;

    public DuringPredicate() {
        this(1L, Long.MAX_VALUE);
    }

    public DuringPredicate(long max, TimeUnit maxUnit) {
        this(1L, TimeUtil.unitToLong(max, maxUnit));
    }

    public DuringPredicate(long min, TimeUnit minUnit, long max, TimeUnit maxUnit) {
        this(TimeUtil.unitToLong(min, minUnit), TimeUtil.unitToLong(max, maxUnit));
    }

    private DuringPredicate(long min, long max) {
        this.startMinDev = min;
        this.startMaxDev = max;
        this.endMinDev = min;
        this.endMaxDev = max;
    }

    @Override
    public Interval getInterval() {
        return this.negated ? new Interval(Long.MIN_VALUE, Long.MAX_VALUE) : new Interval(1L, Long.MAX_VALUE);
    }

    public String toString() {
        return (this.negated ? "not " : "") + "during[" + this.startMinDev + ", " + this.startMaxDev + "]";
    }

    @Override
    public boolean evaluate(long start1, long duration1, long end1, long start2, long duration2, long end2) {
        long distStart = start1 - start2;
        long distEnd = end2 - end1;
        return this.negated ^ (distStart >= this.startMinDev && distStart <= this.startMaxDev && distEnd >= this.endMinDev && distEnd <= this.endMaxDev);
    }

    @Override
    protected boolean isTemporalPredicateEqualTo(DuringPredicate other) {
        return this.startMinDev == other.startMinDev && this.startMaxDev == other.startMaxDev && this.endMinDev == other.endMinDev && this.endMaxDev == other.endMaxDev;
    }
}

