/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.drools.core.marshalling.impl.ClassObjectMarshallingStrategyAcceptor;
import org.drools.core.marshalling.impl.SerializablePlaceholderResolverStrategy;
import org.drools.core.util.StringUtils;
import org.jbpm.process.core.timer.GlobalSchedulerService;
import org.jbpm.process.instance.event.DefaultSignalManagerFactory;
import org.jbpm.process.instance.impl.DefaultProcessInstanceManagerFactory;
import org.jbpm.runtime.manager.impl.DefaultRuntimeEnvironment;
import org.jbpm.runtime.manager.impl.KModuleRegisterableItemsFactory;
import org.jbpm.runtime.manager.impl.SimpleRuntimeEnvironment;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorManagerUtil;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorMerger;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyAcceptor;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilderFactory;
import org.kie.api.task.UserGroupCallback;
import org.kie.api.task.UserInfo;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.conf.MergeMode;
import org.kie.internal.runtime.conf.NamedObjectModel;
import org.kie.internal.runtime.conf.ObjectModel;
import org.kie.internal.runtime.conf.ObjectModelResolver;
import org.kie.internal.runtime.conf.ObjectModelResolverProvider;
import org.kie.internal.runtime.conf.PersistenceMode;
import org.kie.internal.runtime.manager.Mapper;
import org.kie.internal.runtime.manager.RuntimeEnvironment;
import org.kie.internal.runtime.manager.deploy.DeploymentDescriptorManager;
import org.kie.scanner.KieMavenRepository;

public class RuntimeEnvironmentBuilder
implements RuntimeEnvironmentBuilderFactory,
org.kie.api.runtime.manager.RuntimeEnvironmentBuilder {
    private static final String DEFAULT_KBASE_NAME = "defaultKieBase";
    private SimpleRuntimeEnvironment runtimeEnvironment;

    public RuntimeEnvironmentBuilder() {
        this.runtimeEnvironment = new SimpleRuntimeEnvironment();
    }

    private RuntimeEnvironmentBuilder(SimpleRuntimeEnvironment runtimeEnvironment) {
        this.runtimeEnvironment = runtimeEnvironment;
    }

    public static RuntimeEnvironmentBuilder getEmpty() {
        return new RuntimeEnvironmentBuilder();
    }

    public static RuntimeEnvironmentBuilder getDefault() {
        return new RuntimeEnvironmentBuilder(new DefaultRuntimeEnvironment());
    }

    public static RuntimeEnvironmentBuilder getDefaultInMemory() {
        RuntimeEnvironmentBuilder builder = new RuntimeEnvironmentBuilder(new DefaultRuntimeEnvironment(null, false));
        builder.addConfiguration("drools.processSignalManagerFactory", DefaultSignalManagerFactory.class.getName()).addConfiguration("drools.processInstanceManagerFactory", DefaultProcessInstanceManagerFactory.class.getName());
        return builder;
    }

    public static RuntimeEnvironmentBuilder getDefault(String groupId, String artifactId, String version) {
        return RuntimeEnvironmentBuilder.getDefault(groupId, artifactId, version, null, null);
    }

    public static RuntimeEnvironmentBuilder getDefault(String groupId, String artifactId, String version, String kbaseName, String ksessionName) {
        KieServices ks = KieServices.Factory.get();
        return RuntimeEnvironmentBuilder.getDefault(ks.newReleaseId(groupId, artifactId, version), kbaseName, ksessionName);
    }

    public static RuntimeEnvironmentBuilder getDefault(ReleaseId releaseId) {
        return RuntimeEnvironmentBuilder.getDefault(releaseId, null, null);
    }

    public static RuntimeEnvironmentBuilder getDefault(ReleaseId releaseId, String kbaseName, String ksessionName) {
        Object entry;
        InternalKieModule module;
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.resolveArtifact(releaseId.toExternalForm());
        KieServices ks = KieServices.Factory.get();
        KieContainer kieContainer = ks.newKieContainer(releaseId);
        DeploymentDescriptorManager descriptorManager = new DeploymentDescriptorManager();
        List<DeploymentDescriptor> descriptorHierarchy = DeploymentDescriptorManagerUtil.getDeploymentDescriptorHierarchy(descriptorManager, kieContainer);
        DeploymentDescriptorMerger merger = new DeploymentDescriptorMerger();
        DeploymentDescriptor descriptor = merger.merge(descriptorHierarchy, MergeMode.MERGE_COLLECTIONS);
        if (StringUtils.isEmpty((CharSequence)kbaseName)) {
            KieBaseModel defaultKBaseModel = ((KieContainerImpl)kieContainer).getKieProject().getDefaultKieBaseModel();
            kbaseName = defaultKBaseModel != null ? defaultKBaseModel.getName() : DEFAULT_KBASE_NAME;
        }
        if ((module = (InternalKieModule)((KieContainerImpl)kieContainer).getKieModuleForKBase(kbaseName)) == null) {
            throw new IllegalStateException("Cannot find kbase, either it does not exist or there are multiple default kbases in kmodule.xml");
        }
        KieBase kbase = kieContainer.getKieBase(kbaseName);
        RuntimeEnvironmentBuilder builder = null;
        builder = descriptor.getPersistenceMode() == PersistenceMode.NONE ? RuntimeEnvironmentBuilder.getDefaultInMemory() : RuntimeEnvironmentBuilder.getDefault();
        HashMap<String, Object> contaxtParams = new HashMap<String, Object>();
        contaxtParams.put("classLoader", kieContainer.getClassLoader());
        if (descriptor.getPersistenceUnit() != null) {
            EntityManagerFactory emf = EntityManagerFactoryManager.get().getOrCreate(descriptor.getPersistenceUnit());
            builder.entityManagerFactory(emf);
            contaxtParams.put("entityManagerFactory", emf);
        }
        for (NamedObjectModel model : descriptor.getEnvironmentEntries()) {
            entry = RuntimeEnvironmentBuilder.getInstanceFromModel((ObjectModel)model, kieContainer, contaxtParams);
            builder.addEnvironmentEntry(model.getName(), entry);
        }
        for (NamedObjectModel model : descriptor.getConfiguration()) {
            entry = RuntimeEnvironmentBuilder.getInstanceFromModel((ObjectModel)model, kieContainer, contaxtParams);
            builder.addConfiguration(model.getName(), (String)entry);
        }
        ObjectMarshallingStrategy[] mStrategies = new ObjectMarshallingStrategy[descriptor.getMarshallingStrategies().size() + 1];
        int index = 0;
        for (ObjectModel model : descriptor.getMarshallingStrategies()) {
            Object strategy = RuntimeEnvironmentBuilder.getInstanceFromModel(model, kieContainer, contaxtParams);
            mStrategies[index] = (ObjectMarshallingStrategy)strategy;
            ++index;
        }
        mStrategies[index] = new SerializablePlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT);
        builder.addEnvironmentEntry("org.kie.api.marshalling.ObjectMarshallingStrategies", mStrategies);
        builder.addEnvironmentEntry("KieDeploymentDescriptor", descriptor).knowledgeBase(kbase).classLoader(kieContainer.getClassLoader()).registerableItemsFactory((RegisterableItemsFactory)new KModuleRegisterableItemsFactory(kieContainer, ksessionName));
        return builder;
    }

    public static RuntimeEnvironmentBuilder getClasspathKmoduleDefault() {
        return RuntimeEnvironmentBuilder.getClasspathKmoduleDefault(null, null);
    }

    public static RuntimeEnvironmentBuilder getClasspathKmoduleDefault(String kbaseName, String ksessionName) {
        return RuntimeEnvironmentBuilder.setupClasspathKmoduleBuilder(KieServices.Factory.get().getKieClasspathContainer(), kbaseName, ksessionName);
    }

    private static RuntimeEnvironmentBuilder setupClasspathKmoduleBuilder(KieContainer kieContainer, String kbaseName, String ksessionName) {
        InternalKieModule module;
        if (StringUtils.isEmpty((CharSequence)kbaseName)) {
            KieBaseModel defaultKBaseModel = ((KieContainerImpl)kieContainer).getKieProject().getDefaultKieBaseModel();
            kbaseName = defaultKBaseModel != null ? defaultKBaseModel.getName() : DEFAULT_KBASE_NAME;
        }
        if ((module = (InternalKieModule)((KieContainerImpl)kieContainer).getKieModuleForKBase(kbaseName)) == null) {
            throw new IllegalStateException("Cannot find kbase with name " + kbaseName);
        }
        KieBase kbase = kieContainer.getKieBase(kbaseName);
        return RuntimeEnvironmentBuilder.getDefault().knowledgeBase(kbase).classLoader(kieContainer.getClassLoader()).registerableItemsFactory((RegisterableItemsFactory)new KModuleRegisterableItemsFactory(kieContainer, ksessionName));
    }

    public RuntimeEnvironmentBuilder persistence(boolean persistenceEnabled) {
        this.runtimeEnvironment.setUsePersistence(persistenceEnabled);
        return this;
    }

    public RuntimeEnvironmentBuilder entityManagerFactory(Object emf) {
        if (emf == null) {
            return this;
        }
        if (!(emf instanceof EntityManagerFactory)) {
            throw new IllegalArgumentException("Argument is not of type EntityManagerFactory");
        }
        this.runtimeEnvironment.setEmf((EntityManagerFactory)emf);
        return this;
    }

    public RuntimeEnvironmentBuilder addAsset(Resource asset, ResourceType type) {
        if (asset == null || type == null) {
            return this;
        }
        this.runtimeEnvironment.addAsset(asset, type);
        return this;
    }

    public RuntimeEnvironmentBuilder addEnvironmentEntry(String name, Object value) {
        if (name == null || value == null) {
            return this;
        }
        this.runtimeEnvironment.addToEnvironment(name, value);
        return this;
    }

    public RuntimeEnvironmentBuilder addConfiguration(String name, String value) {
        if (name == null || value == null) {
            return this;
        }
        this.runtimeEnvironment.addToConfiguration(name, value);
        return this;
    }

    public RuntimeEnvironmentBuilder knowledgeBase(KieBase kbase) {
        if (kbase == null) {
            return this;
        }
        this.runtimeEnvironment.setKieBase(kbase);
        return this;
    }

    public RuntimeEnvironmentBuilder userGroupCallback(UserGroupCallback callback) {
        if (callback == null) {
            return this;
        }
        this.runtimeEnvironment.setUserGroupCallback(callback);
        return this;
    }

    public RuntimeEnvironmentBuilder userInfo(UserInfo userInfo) {
        if (userInfo == null) {
            return this;
        }
        this.runtimeEnvironment.setUserInfo(userInfo);
        return this;
    }

    public RuntimeEnvironmentBuilder mapper(Mapper mapper) {
        if (mapper == null) {
            return this;
        }
        this.runtimeEnvironment.setMapper(mapper);
        return this;
    }

    public RuntimeEnvironmentBuilder registerableItemsFactory(RegisterableItemsFactory factory) {
        if (factory == null) {
            return this;
        }
        this.runtimeEnvironment.setRegisterableItemsFactory(factory);
        return this;
    }

    public RuntimeEnvironment get() {
        this.runtimeEnvironment.init();
        return this.runtimeEnvironment;
    }

    public RuntimeEnvironmentBuilder schedulerService(Object globalScheduler) {
        if (globalScheduler == null) {
            return this;
        }
        if (!(globalScheduler instanceof GlobalSchedulerService)) {
            throw new IllegalArgumentException("Argument is not of type GlobalSchedulerService");
        }
        this.runtimeEnvironment.setSchedulerService((GlobalSchedulerService)globalScheduler);
        return this;
    }

    public RuntimeEnvironmentBuilder classLoader(ClassLoader cl) {
        if (cl == null) {
            return this;
        }
        this.runtimeEnvironment.setClassLoader(cl);
        return this;
    }

    public org.kie.api.runtime.manager.RuntimeEnvironmentBuilder newEmptyBuilder() {
        return RuntimeEnvironmentBuilder.getEmpty();
    }

    public org.kie.api.runtime.manager.RuntimeEnvironmentBuilder newDefaultBuilder() {
        return RuntimeEnvironmentBuilder.getDefault();
    }

    public org.kie.api.runtime.manager.RuntimeEnvironmentBuilder newDefaultInMemoryBuilder() {
        return RuntimeEnvironmentBuilder.getDefaultInMemory();
    }

    public org.kie.api.runtime.manager.RuntimeEnvironmentBuilder newDefaultBuilder(String groupId, String artifactId, String version) {
        return RuntimeEnvironmentBuilder.getDefault(groupId, artifactId, version);
    }

    public org.kie.api.runtime.manager.RuntimeEnvironmentBuilder newDefaultBuilder(String groupId, String artifactId, String version, String kbaseName, String ksessionName) {
        return RuntimeEnvironmentBuilder.getDefault(groupId, artifactId, version, kbaseName, ksessionName);
    }

    public org.kie.api.runtime.manager.RuntimeEnvironmentBuilder newDefaultBuilder(ReleaseId releaseId) {
        return RuntimeEnvironmentBuilder.getDefault(releaseId);
    }

    public org.kie.api.runtime.manager.RuntimeEnvironmentBuilder newDefaultBuilder(ReleaseId releaseId, String kbaseName, String ksessionName) {
        return RuntimeEnvironmentBuilder.getDefault(releaseId, kbaseName, ksessionName);
    }

    public org.kie.api.runtime.manager.RuntimeEnvironmentBuilder newClasspathKmoduleDefaultBuilder() {
        return this.newClasspathKmoduleDefaultBuilder(null, null);
    }

    public org.kie.api.runtime.manager.RuntimeEnvironmentBuilder newClasspathKmoduleDefaultBuilder(String kbaseName, String ksessionName) {
        return RuntimeEnvironmentBuilder.setupClasspathKmoduleBuilder(KieServices.Factory.get().newKieClasspathContainer(), kbaseName, ksessionName);
    }

    protected static Object getInstanceFromModel(ObjectModel model, KieContainer kieContainer, Map<String, Object> contaxtParams) {
        ObjectModelResolver resolver = ObjectModelResolverProvider.get((String)model.getResolver());
        return resolver.getInstance(model, kieContainer.getClassLoader(), contaxtParams);
    }
}

