/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.identity;

import org.jbpm.services.task.identity.DBUserGroupCallbackImpl;
import org.jbpm.services.task.identity.DBUserInfoImpl;
import org.jbpm.services.task.identity.DefaultUserInfo;
import org.jbpm.services.task.identity.JAASUserGroupCallbackImpl;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.services.task.identity.LDAPUserGroupCallbackImpl;
import org.jbpm.services.task.identity.LDAPUserInfoImpl;
import org.jbpm.services.task.identity.MvelUserGroupCallbackImpl;
import org.jbpm.services.task.identity.PropertyUserInfoImpl;
import org.kie.api.task.UserGroupCallback;
import org.kie.internal.task.api.UserInfo;

public class UserDataServiceProvider {
    private static final String USER_CALLBACK_IMPL = System.getProperty("org.jbpm.ht.callback");
    private static final String USER_INFO_IMPL = System.getProperty("org.jbpm.ht.userinfo");
    private static final String CUSTOM_USER_CALLBACK_IMPL = System.getProperty("org.jbpm.ht.custom.callback");
    private static final String CUSTOM_USER_INFO_IMPL = System.getProperty("org.jbpm.ht.custom.userinfo");

    public static UserGroupCallback getUserGroupCallback() {
        MvelUserGroupCallbackImpl callback = new MvelUserGroupCallbackImpl(true);
        if ("ldap".equalsIgnoreCase(USER_CALLBACK_IMPL)) {
            callback = new LDAPUserGroupCallbackImpl(true);
        } else if ("db".equalsIgnoreCase(USER_CALLBACK_IMPL)) {
            callback = new DBUserGroupCallbackImpl(true);
        } else if ("mvel".equalsIgnoreCase(USER_CALLBACK_IMPL)) {
            callback = new MvelUserGroupCallbackImpl(true);
        } else if ("props".equalsIgnoreCase(USER_CALLBACK_IMPL)) {
            callback = new JBossUserGroupCallbackImpl(true);
        } else if ("jaas".equalsIgnoreCase(USER_CALLBACK_IMPL)) {
            callback = new JAASUserGroupCallbackImpl(true);
        } else if ("custom".equalsIgnoreCase(USER_CALLBACK_IMPL)) {
            try {
                callback = (UserGroupCallback)Class.forName(CUSTOM_USER_CALLBACK_IMPL).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create instance of custom user group callback impl", e);
            }
        }
        return callback;
    }

    public static UserInfo getUserInfo() {
        DefaultUserInfo userInfo = new DefaultUserInfo(true);
        if ("ldap".equalsIgnoreCase(USER_INFO_IMPL)) {
            userInfo = new LDAPUserInfoImpl(true);
        } else if ("db".equalsIgnoreCase(USER_INFO_IMPL)) {
            userInfo = new DBUserInfoImpl(true);
        } else if ("props".equalsIgnoreCase(USER_INFO_IMPL)) {
            userInfo = new PropertyUserInfoImpl(true);
        } else if ("custom".equalsIgnoreCase(USER_INFO_IMPL)) {
            try {
                userInfo = (UserInfo)Class.forName(CUSTOM_USER_INFO_IMPL).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create instance of custom user info impl", e);
            }
        }
        return userInfo;
    }
}

