/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverJob;
import org.optaplanner.core.api.solver.SolverStatus;
import org.optaplanner.core.impl.solver.DefaultSolverManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultSolverJob<Solution_, ProblemId_>
implements SolverJob<Solution_, ProblemId_>,
Callable<Solution_> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DefaultSolverManager<Solution_, ProblemId_> solverManager;
    private final Solver<Solution_> solver;
    private final ProblemId_ problemId;
    private final Function<? super ProblemId_, ? extends Solution_> problemFinder;
    private final Consumer<? super Solution_> finalBestSolutionConsumer;
    private final BiConsumer<? super ProblemId_, ? super Throwable> exceptionHandler;
    private volatile SolverStatus solverStatus;
    private CountDownLatch terminatedLatch;
    private Future<Solution_> future;

    public DefaultSolverJob(DefaultSolverManager<Solution_, ProblemId_> solverManager, Solver<Solution_> solver, ProblemId_ problemId, Function<? super ProblemId_, ? extends Solution_> problemFinder, Consumer<? super Solution_> finalBestSolutionConsumer, BiConsumer<? super ProblemId_, ? super Throwable> exceptionHandler) {
        this.solverManager = solverManager;
        this.problemId = problemId;
        this.solver = solver;
        this.problemFinder = problemFinder;
        this.finalBestSolutionConsumer = finalBestSolutionConsumer;
        this.exceptionHandler = exceptionHandler;
        this.solverStatus = SolverStatus.SOLVING_SCHEDULED;
        this.terminatedLatch = new CountDownLatch(1);
    }

    public void setFuture(Future<Solution_> future) {
        this.future = future;
    }

    @Override
    public ProblemId_ getProblemId() {
        return this.problemId;
    }

    @Override
    public SolverStatus getSolverStatus() {
        return this.solverStatus;
    }

    @Override
    public Solution_ call() {
        this.solverStatus = SolverStatus.SOLVING_ACTIVE;
        try {
            Solution_ problem = this.problemFinder.apply(this.problemId);
            Solution_ finalBestSolution = this.solver.solve(problem);
            if (this.finalBestSolutionConsumer != null) {
                this.finalBestSolutionConsumer.accept(finalBestSolution);
            }
            Solution_ Solution_ = finalBestSolution;
            return Solution_;
        }
        catch (Exception e) {
            this.exceptionHandler.accept(this.problemId, e);
            throw new IllegalStateException("Solving failed for problemId (" + this.problemId + ").", e);
        }
        finally {
            this.solverManager.getProblemIdToSolverJobMap().remove(this.problemId);
            this.solverStatus = SolverStatus.NOT_SOLVING;
            this.terminatedLatch.countDown();
        }
    }

    @Override
    public void terminateEarly() {
        boolean cancelled = this.future.cancel(false);
        if (cancelled) {
            this.solverStatus = SolverStatus.NOT_SOLVING;
        } else {
            this.solver.terminateEarly();
            try {
                this.terminatedLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.logger.warn("The terminateEarly() call is interrupted.", (Throwable)e);
            }
        }
    }

    @Override
    public Solution_ getFinalBestSolution() throws InterruptedException, ExecutionException {
        return this.future.get();
    }
}

