/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.assignment;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.kie.internal.task.api.assignment.AssignmentStrategy;

public class AssignmentServiceRegistry {
    private static final ServiceLoader<AssignmentStrategy> foundStrategies = ServiceLoader.load(AssignmentStrategy.class, AssignmentServiceRegistry.class.getClassLoader());
    private Map<String, AssignmentStrategy> assignmentStrategies = new HashMap<String, AssignmentStrategy>();

    private AssignmentServiceRegistry() {
        foundStrategies.forEach(strategy -> this.assignmentStrategies.put(strategy.getIdentifier(), (AssignmentStrategy)strategy));
    }

    public static AssignmentServiceRegistry get() {
        return Holder.INSTANCE;
    }

    public AssignmentStrategy getStrategy(String id) {
        AssignmentStrategy strategy = this.assignmentStrategies.get(id);
        if (strategy == null) {
            throw new IllegalArgumentException("No assignment strategy was found with id " + id);
        }
        return strategy;
    }

    public synchronized void addStrategy(AssignmentStrategy assignmentStrategy) {
        this.assignmentStrategies.put(assignmentStrategy.getIdentifier(), assignmentStrategy);
    }

    private static class Holder {
        static final AssignmentServiceRegistry INSTANCE = new AssignmentServiceRegistry();

        private Holder() {
        }
    }
}

