/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import org.jbpm.services.task.commands.TaskCommand;
import org.jbpm.services.task.commands.TaskContext;
import org.jbpm.services.task.deadlines.notifications.impl.NotificationListenerManager;
import org.jbpm.services.task.events.TaskEventSupport;
import org.jbpm.services.task.utils.ClassUtil;
import org.jbpm.services.task.utils.ContentMarshallerHelper;
import org.kie.api.runtime.Context;
import org.kie.api.task.model.Content;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskData;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.ContentMarshallerContext;
import org.kie.internal.task.api.TaskDeadlinesService;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.TaskPersistenceContext;
import org.kie.internal.task.api.UserInfo;
import org.kie.internal.task.api.model.Deadline;
import org.kie.internal.task.api.model.DeadlineSummary;
import org.kie.internal.task.api.model.EmailNotification;
import org.kie.internal.task.api.model.EmailNotificationHeader;
import org.kie.internal.task.api.model.Escalation;
import org.kie.internal.task.api.model.Language;
import org.kie.internal.task.api.model.Notification;
import org.kie.internal.task.api.model.NotificationEvent;
import org.kie.internal.task.api.model.NotificationType;
import org.mvel2.templates.TemplateRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="execute-reminder-command")
@XmlAccessorType(value=XmlAccessType.NONE)
public class ExecuteReminderCommand
extends TaskCommand<Void> {
    private static final long serialVersionUID = -1167914440425583650L;
    private static final Logger logger = LoggerFactory.getLogger(ExecuteReminderCommand.class);
    private static final String defaultEmailBody = "<html> <body><b> You have been assigned to a task ( task_name = ${taskName}, task_id = ${taskId} )</b></br><b>Process instance information:</b></hr><ul><li> DeploymentId : ${deploymentId} </li><li> ProcessId : ${processId} </li><li> ProcessInstanceId : ${processInstanceId} </li>\t</ul></b></body></html>";
    private static final String defaultEmailSubject = "You have a task ( ${taskName} ) of process ( ${processId} )";
    @XmlElement
    @XmlSchemaType(name="String")
    private String fromUser;

    public ExecuteReminderCommand() {
    }

    public ExecuteReminderCommand(long taskId, String fromUser) {
        this.taskId = taskId;
        this.fromUser = fromUser;
    }

    public Void execute(Context context) {
        TaskContext ctx = (TaskContext)context;
        UserInfo userInfo = (UserInfo)context.get("org.kie.api.task.UserInfo");
        TaskPersistenceContext persistenceContext = ctx.getPersistenceContext();
        try {
            Task task = persistenceContext.findTask(this.taskId);
            TaskData taskData = task.getTaskData();
            List<DeadlineSummary> resultList = null;
            resultList = this.getAlldeadlines(persistenceContext, taskData);
            TaskEventSupport taskEventSupport = ctx.getTaskEventSupport();
            if (resultList == null || resultList.size() == 0) {
                if (taskData.getActualOwner() == null) {
                    return null;
                }
                if (taskData != null && (TaskDeadlinesService.DeadlineType.START.isValidStatus(taskData.getStatus()) || TaskDeadlinesService.DeadlineType.END.isValidStatus(taskData.getStatus()))) {
                    taskEventSupport.fireBeforeTaskNotified(task, ctx);
                    logger.debug("Sending an Email");
                    Map<String, Object> variables = this.getVariables(ctx, persistenceContext, task, taskData);
                    Notification notification = this.buildDefaultNotification(taskData, task);
                    NotificationListenerManager.get().broadcast(new NotificationEvent(notification, task, variables), userInfo);
                    taskEventSupport.fireAfterTaskNotified(task, ctx);
                }
            } else {
                for (DeadlineSummary deadlineSummary : resultList) {
                    this.executedeadLine(ctx, persistenceContext, task, deadlineSummary, taskData);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error when executing deadlines", (Throwable)e);
        }
        return null;
    }

    private List<DeadlineSummary> getAlldeadlines(TaskPersistenceContext persistenceContext, TaskData taskData) {
        List resultList = Status.InProgress == taskData.getStatus() || Status.Suspended == taskData.getStatus() ? (List)persistenceContext.queryWithParametersInTransaction("UnescalatedEndDeadlinesByTaskIdForReminder", (Map)persistenceContext.addParametersToMap(new Object[]{"taskId", this.taskId}), ClassUtil.castClass(List.class)) : (List)persistenceContext.queryWithParametersInTransaction("UnescalatedStartDeadlinesByTaskIdForReminder", (Map)persistenceContext.addParametersToMap(new Object[]{"taskId", this.taskId}), ClassUtil.castClass(List.class));
        return resultList;
    }

    private Void executedeadLine(TaskContext ctx, TaskPersistenceContext persistenceContext, Task task, DeadlineSummary deadlineSummary, TaskData taskData) {
        Deadline deadline = persistenceContext.findDeadline(Long.valueOf(deadlineSummary.getDeadlineId()));
        if (task == null || deadline == null) {
            return null;
        }
        if (taskData != null) {
            UserInfo userInfo = (UserInfo)ctx.get("org.kie.api.task.UserInfo");
            if (TaskDeadlinesService.DeadlineType.START.isValidStatus(taskData.getStatus()) || TaskDeadlinesService.DeadlineType.END.isValidStatus(taskData.getStatus())) {
                Map<String, Object> variables = this.getVariables(ctx, persistenceContext, task, taskData);
                if (deadline == null || deadline.getEscalations() == null) {
                    return null;
                }
                TaskEventSupport taskEventSupport = ctx.getTaskEventSupport();
                taskEventSupport.fireBeforeTaskNotified(task, ctx);
                for (Escalation escalation : deadline.getEscalations()) {
                    for (Notification notification : escalation.getNotifications()) {
                        if (notification.getNotificationType() != NotificationType.Email) continue;
                        logger.debug("Sending an Email");
                        NotificationListenerManager.get().broadcast(new NotificationEvent(notification, task, variables), userInfo);
                    }
                }
                taskEventSupport.fireAfterTaskNotified(task, ctx);
            }
        }
        return null;
    }

    private Map<String, Object> getVariables(TaskContext ctx, TaskPersistenceContext persistenceContext, Task task, TaskData taskData) {
        HashMap<String, Object> variables;
        Content content = persistenceContext.findContent(Long.valueOf(taskData.getDocumentContentId()));
        if (content != null) {
            ContentMarshallerContext mContext = ctx.getTaskContentService().getMarshallerContext(task);
            Object objectFromBytes = ContentMarshallerHelper.unmarshall(content.getContent(), mContext.getEnvironment(), mContext.getClassloader());
            if (objectFromBytes instanceof Map) {
                variables = (HashMap<String, Object>)objectFromBytes;
            } else {
                variables = new HashMap<String, Object>();
                variables.put("content", objectFromBytes);
            }
        } else {
            variables = Collections.emptyMap();
        }
        return variables;
    }

    private Notification buildDefaultNotification(TaskData taskData, Task task) {
        EmailNotification emailNotificationImpl = TaskModelProvider.getFactory().newEmialNotification();
        HashMap<Language, EmailNotificationHeader> map = new HashMap<Language, EmailNotificationHeader>();
        EmailNotificationHeader emailNotificationHeaderImpl = TaskModelProvider.getFactory().newEmailNotificationHeader();
        emailNotificationHeaderImpl.setBody(this.buildDefafultEmailBody(taskData, task));
        emailNotificationHeaderImpl.setFrom(this.fromUser);
        emailNotificationHeaderImpl.setReplyTo(this.fromUser);
        emailNotificationHeaderImpl.setLanguage("en-UK");
        emailNotificationHeaderImpl.setSubject(this.buildDefafultEmailSubject(taskData, task));
        Language language = TaskModelProvider.getFactory().newLanguage();
        language.setMapkey("en-UK");
        map.put(language, emailNotificationHeaderImpl);
        emailNotificationImpl.setEmailHeaders(map);
        ArrayList<User> recipients = new ArrayList<User>();
        recipients.add(taskData.getActualOwner());
        emailNotificationImpl.setRecipients(recipients);
        return emailNotificationImpl;
    }

    private String buildDefafultEmailBody(TaskData taskData, Task task) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("taskName", task.getName());
        vars.put("taskId", task.getId());
        vars.put("deploymentId", taskData.getDeploymentId());
        vars.put("processId", taskData.getProcessId());
        vars.put("processInstanceId", taskData.getProcessInstanceId());
        String body = (String)TemplateRuntime.eval((String)defaultEmailBody, vars);
        return body;
    }

    private String buildDefafultEmailSubject(TaskData taskData, Task task) {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("taskName", task.getName());
        vars.put("processId", taskData.getProcessId());
        String body = (String)TemplateRuntime.eval((String)defaultEmailSubject, vars);
        return body;
    }
}

