/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.impl;

import javax.xml.stream.Location;
import org.kie.api.builder.Message;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.model.api.DMNElement;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.internal.builder.InternalMessage;

public class DMNMessageImpl
implements DMNMessage {
    private DMNMessage.Severity severity;
    private String message;
    private DMNMessageType messageType;
    private DMNModelInstrumentedBase source;
    private Throwable exception;
    private FEELEvent feelEvent;
    private long id = 0L;
    private String path;
    private String kieBaseName;

    public DMNMessageImpl() {
    }

    public DMNMessageImpl(DMNMessage.Severity severity, String message, DMNMessageType messageType, DMNModelInstrumentedBase source) {
        this(severity, message, messageType, source, (Throwable)null);
    }

    public DMNMessageImpl(DMNMessage.Severity severity, String message, DMNMessageType messageType, DMNModelInstrumentedBase source, Throwable exception) {
        this.severity = severity;
        this.message = message;
        this.messageType = messageType;
        this.source = source;
        this.exception = exception;
    }

    public DMNMessageImpl(DMNMessage.Severity severity, String message, DMNMessageType messageType, DMNModelInstrumentedBase source, FEELEvent feelEvent) {
        this.severity = severity;
        this.message = message;
        this.messageType = messageType;
        this.source = source;
        this.feelEvent = feelEvent;
    }

    public DMNMessage.Severity getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        return this.message;
    }

    public DMNMessageType getMessageType() {
        return this.messageType;
    }

    public String getSourceId() {
        return this.source != null && this.source instanceof DMNElement ? ((DMNElement)this.source).getId() : null;
    }

    public Object getSourceReference() {
        return this.source;
    }

    public Throwable getException() {
        return this.exception;
    }

    public FEELEvent getFeelEvent() {
        return this.feelEvent;
    }

    public String toString() {
        return "Message [id=" + this.id + (this.kieBaseName != null ? ", kieBase=" + this.kieBaseName : "") + ", level=" + this.getLevel() + ", path=" + this.path + ", line=" + this.getLine() + ", column=" + this.getColumn() + "\n   text=" + this.getText() + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DMNMessageImpl)) {
            return false;
        }
        DMNMessageImpl that = (DMNMessageImpl)o;
        if (this.severity != that.severity) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (this.messageType != null ? !this.messageType.equals((Object)that.messageType) : that.messageType != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(that.source) : that.source != null) {
            return false;
        }
        if (this.exception != null ? !this.exception.equals(that.exception) : that.exception != null) {
            return false;
        }
        return this.feelEvent != null ? this.feelEvent.equals(that.feelEvent) : that.feelEvent == null;
    }

    public int hashCode() {
        int result = this.severity != null ? this.severity.hashCode() : 0;
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.messageType != null ? this.messageType.hashCode() : 0);
        result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
        result = 31 * result + (this.exception != null ? this.exception.hashCode() : 0);
        result = 31 * result + (this.feelEvent != null ? this.feelEvent.hashCode() : 0);
        return result;
    }

    public long getId() {
        return this.id;
    }

    public Message.Level getLevel() {
        switch (this.severity) {
            case ERROR: {
                return Message.Level.ERROR;
            }
            case INFO: {
                return Message.Level.INFO;
            }
            case TRACE: {
                return Message.Level.INFO;
            }
            case WARN: {
                return Message.Level.WARNING;
            }
        }
        return Message.Level.ERROR;
    }

    public String getPath() {
        return this.path;
    }

    public int getLine() {
        Location l;
        if (this.source != null && (l = this.source.getLocation()) != null) {
            return l.getLineNumber();
        }
        return 0;
    }

    public int getColumn() {
        Location l;
        if (this.source != null && (l = this.source.getLocation()) != null) {
            return l.getColumnNumber();
        }
        return 0;
    }

    public String getText() {
        StringBuilder sb = new StringBuilder();
        sb.append("DMN: ");
        sb.append(this.message);
        sb.append(" (");
        if (this.getPath() != null) {
            sb.append("resource: ");
            sb.append(this.getPath());
            sb.append(", ");
        }
        if (this.getSourceId() != null) {
            sb.append("DMN id: ");
            sb.append(this.getSourceId());
            sb.append(", ");
        }
        sb.append(this.getMessageType().getDescription());
        sb.append(") ");
        return sb.toString();
    }

    public String getKieBaseName() {
        return this.kieBaseName;
    }

    public InternalMessage setKieBaseName(String kieBaseName) {
        this.kieBaseName = kieBaseName;
        return this;
    }

    public InternalMessage cloneWith(long id, String path) {
        DMNMessageImpl r = new DMNMessageImpl();
        r.id = id;
        r.path = path;
        r.severity = this.severity;
        r.message = this.message;
        r.messageType = this.messageType;
        r.source = this.source;
        r.exception = this.exception;
        r.feelEvent = this.feelEvent;
        r.kieBaseName = this.kieBaseName;
        return r;
    }
}

