/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.prometheus;

import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Summary;
import java.util.Date;
import org.jbpm.casemgmt.api.event.CaseCancelEvent;
import org.jbpm.casemgmt.api.event.CaseCloseEvent;
import org.jbpm.casemgmt.api.event.CaseDestroyEvent;
import org.jbpm.casemgmt.api.event.CaseEvent;
import org.jbpm.casemgmt.api.event.CaseEventListener;
import org.jbpm.casemgmt.api.event.CaseStartEvent;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.kie.server.services.prometheus.PrometheusMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusCaseEventListener
implements CaseEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrometheusCaseEventListener.class);
    protected static final Counter numberOfCasesStarted = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("kie_server_case_started_total")).help("Kie Server Started Cases")).labelNames(new String[]{"case_definition_id"})).register();
    protected static final Gauge runningCases = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("kie_server_case_running_total")).help("Kie Server Running Cases")).labelNames(new String[]{"case_definition_id"})).register();
    protected static final Summary caseDuration = (Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().name("kie_server_case_duration_seconds")).help("Kie Server Case Duration")).labelNames(new String[]{"case_definition_id"})).register();

    protected static void recordRunningCaseInstance(String caseDefinitionId) {
        ((Gauge.Child)runningCases.labels(new String[]{caseDefinitionId})).inc();
    }

    public void afterCaseStarted(CaseStartEvent event) {
        LOGGER.debug("After case started: {}", (Object)event);
        ((Counter.Child)numberOfCasesStarted.labels(new String[]{event.getCaseDefinitionId()})).inc();
        PrometheusCaseEventListener.recordRunningCaseInstance(event.getCaseDefinitionId());
    }

    public void afterCaseClosed(CaseCloseEvent event) {
        this.endCase((CaseEvent)event);
    }

    public void afterCaseDestroyed(CaseDestroyEvent event) {
        this.endCase((CaseEvent)event);
    }

    public void afterCaseCancelled(CaseCancelEvent event) {
        this.endCase((CaseEvent)event);
    }

    protected void endCase(CaseEvent event) {
        LOGGER.debug("Close Case with Id: {}", (Object)event.getCaseId());
        CaseFileInstance caseFile = event.getCaseFile();
        if (caseFile != null) {
            ((Gauge.Child)runningCases.labels(new String[]{caseFile.getDefinitionId()})).dec();
            Date caseReopenDate = caseFile.getCaseReopenDate();
            Date start = caseReopenDate == null ? caseFile.getCaseStartDate() : caseReopenDate;
            double duration = PrometheusMetrics.millisToSeconds(System.currentTimeMillis() - start.getTime());
            ((Summary.Child)caseDuration.labels(new String[]{caseFile.getDefinitionId()})).observe(duration);
            LOGGER.debug("Case duration: {}s", (Object)duration);
        }
    }
}

