/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.prometheus;

import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieServer;
import org.kie.server.services.api.KieServerEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusKieServerEventListener
implements KieServerEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrometheusKieServerEventListener.class);
    protected static final Counter numberOfContainersStarted = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("kie_server_container_started_total")).help("Kie Server Started Containers")).labelNames(new String[]{"container_id"})).register();
    protected static final Gauge runningContainers = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("kie_server_container_running_total")).help("Kie Server Running Containers")).labelNames(new String[]{"container_id"})).register();
    protected static final Gauge kieServerStartTime = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("kie_server_start_time")).help("Kie Server Start Time")).labelNames(new String[]{"name", "server_id", "location", "version"})).register();

    public void beforeServerStarted(KieServer kieServer) {
    }

    public void afterServerStarted(KieServer kieServer) {
        LOGGER.debug("After Kie Server started: {}", (Object)kieServer);
        KieServerInfo info = (KieServerInfo)kieServer.getInfo().getResult();
        ((Gauge.Child)kieServerStartTime.labels(new String[]{info.getName(), info.getServerId(), info.getLocation(), info.getVersion()})).set((double)System.currentTimeMillis());
    }

    public void beforeServerStopped(KieServer kieServer) {
    }

    public void afterServerStopped(KieServer kieServer) {
    }

    public void beforeContainerStarted(KieServer kieServer, KieContainerInstance containerInstance) {
    }

    public void afterContainerStarted(KieServer kieServer, KieContainerInstance containerInstance) {
        LOGGER.debug("After container started: {}", (Object)containerInstance);
        ((Counter.Child)numberOfContainersStarted.labels(new String[]{containerInstance.getContainerId()})).inc();
        ((Gauge.Child)runningContainers.labels(new String[]{containerInstance.getContainerId()})).inc();
    }

    public void beforeContainerStopped(KieServer kieServer, KieContainerInstance containerInstance) {
    }

    public void afterContainerStopped(KieServer kieServer, KieContainerInstance containerInstance) {
        LOGGER.debug("After container stopped: {}", (Object)containerInstance);
        ((Gauge.Child)runningContainers.labels(new String[]{containerInstance.getContainerId()})).dec();
    }

    public void beforeContainerActivated(KieServer kieServer, KieContainerInstance containerInstance) {
    }

    public void afterContainerActivated(KieServer kieServer, KieContainerInstance containerInstance) {
    }

    public void beforeContainerDeactivated(KieServer kieServer, KieContainerInstance containerInstance) {
    }

    public void afterContainerDeactivated(KieServer kieServer, KieContainerInstance containerInstance) {
    }
}

