/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.prometheus;

import io.prometheus.client.Counter;
import io.prometheus.client.Summary;
import java.util.Date;
import org.jbpm.services.task.events.DefaultTaskEventListener;
import org.kie.api.task.TaskEvent;
import org.kie.api.task.model.Task;
import org.kie.server.services.prometheus.PrometheusMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusTaskEventListener
extends DefaultTaskEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrometheusTaskEventListener.class);
    private static final String[] TASK_LABELS = new String[]{"deployment_id", "process_id", "task_name"};
    private static final Counter numberOfTasksAdded = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("kie_server_task_added_total")).help("Kie Server Added Tasks")).labelNames(TASK_LABELS)).register();
    private static final Counter numberOfTasksSkipped = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("kie_server_task_skipped_total")).help("Kie Server Skipped Tasks")).labelNames(TASK_LABELS)).register();
    private static final Counter numberOfTasksCompleted = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("kie_server_task_completed_total")).help("Kie Server Completed Tasks")).labelNames(TASK_LABELS)).register();
    private static final Counter numberOfTasksFailed = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("kie_server_task_failed_total")).help("Kie Server Failed Tasks")).labelNames(TASK_LABELS)).register();
    private static final Counter numberOfTasksExited = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("kie_server_task_exited_total")).help("Kie Server Exited Tasks")).labelNames(TASK_LABELS)).register();
    private static final Summary taskDuration = (Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().name("kie_server_task_duration_seconds")).help("Kie Server Task Duration")).labelNames(TASK_LABELS)).register();

    private void registerCounterEvent(Counter counter, TaskEvent event) {
        Task task = event.getTask();
        ((Counter.Child)counter.labels(new String[]{task.getTaskData().getDeploymentId(), task.getTaskData().getProcessId(), task.getName()})).inc();
    }

    private void registerDuration(TaskEvent event) {
        Task task = event.getTask();
        Date createdOn = task.getTaskData().getCreatedOn();
        if (createdOn != null) {
            double duration = PrometheusMetrics.millisToSeconds(System.currentTimeMillis() - createdOn.getTime());
            ((Summary.Child)taskDuration.labels(new String[]{task.getTaskData().getDeploymentId(), task.getTaskData().getProcessId(), task.getName()})).observe(duration);
        }
    }

    public void afterTaskAddedEvent(TaskEvent event) {
        LOGGER.debug("After Task Added event: {}", (Object)event);
        this.registerCounterEvent(numberOfTasksAdded, event);
    }

    public void afterTaskSkippedEvent(TaskEvent event) {
        LOGGER.debug("After Task Skipped event: {}", (Object)event);
        this.registerCounterEvent(numberOfTasksSkipped, event);
    }

    public void afterTaskCompletedEvent(TaskEvent event) {
        LOGGER.debug("After Task Completed event: {}", (Object)event);
        this.registerCounterEvent(numberOfTasksCompleted, event);
        this.registerDuration(event);
    }

    public void afterTaskFailedEvent(TaskEvent event) {
        LOGGER.debug("After Task Failed event: {}", (Object)event);
        this.registerCounterEvent(numberOfTasksFailed, event);
        this.registerDuration(event);
    }

    public void afterTaskExitedEvent(TaskEvent event) {
        LOGGER.debug("After Task Exited event: {}", (Object)event);
        this.registerCounterEvent(numberOfTasksExited, event);
        this.registerDuration(event);
    }
}

