/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import org.drools.core.WorkingMemory;
import org.drools.core.base.accumulators.MVELAccumulatorFunctionExecutor;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.rule.Accumulate;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.GroupElement;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.spi.Accumulator;
import org.drools.core.spi.Tuple;
import org.drools.core.spi.Wireable;
import org.kie.internal.security.KiePolicyHelper;

public class SingleAccumulate
extends Accumulate {
    private Accumulator accumulator;

    public SingleAccumulate() {
    }

    public SingleAccumulate(RuleConditionElement source, Declaration[] requiredDeclarations) {
        super(source, requiredDeclarations);
    }

    public SingleAccumulate(RuleConditionElement source, Declaration[] requiredDeclarations, Accumulator accumulator) {
        super(source, requiredDeclarations);
        this.accumulator = accumulator;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.accumulator = (Accumulator)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (Accumulator.isCompiledInvoker(this.accumulator)) {
            out.writeObject(null);
        } else {
            out.writeObject(this.accumulator);
        }
    }

    @Override
    public boolean isMultiFunction() {
        return false;
    }

    @Override
    public Accumulator[] getAccumulators() {
        return new Accumulator[]{this.accumulator};
    }

    @Override
    public Serializable createContext() {
        return this.accumulator.createContext();
    }

    @Override
    public void init(Object workingMemoryContext, Object context, Tuple leftTuple, WorkingMemory workingMemory) {
        try {
            this.accumulator.init(workingMemoryContext, context, leftTuple, this.requiredDeclarations, workingMemory);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void accumulate(Object workingMemoryContext, Object context, Tuple leftTuple, InternalFactHandle handle, WorkingMemory workingMemory) {
        try {
            this.accumulator.accumulate(workingMemoryContext, context, leftTuple, handle, this.requiredDeclarations, this.getInnerDeclarationCache(), workingMemory);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void reverse(Object workingMemoryContext, Object context, Tuple leftTuple, InternalFactHandle handle, WorkingMemory workingMemory) {
        try {
            this.accumulator.reverse(workingMemoryContext, context, leftTuple, handle, this.requiredDeclarations, this.getInnerDeclarationCache(), workingMemory);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean supportsReverse() {
        return this.accumulator.supportsReverse();
    }

    @Override
    public Object getResult(Object workingMemoryContext, Object context, Tuple leftTuple, WorkingMemory workingMemory) {
        try {
            return this.accumulator.getResult(workingMemoryContext, context, leftTuple, this.requiredDeclarations, workingMemory);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public SingleAccumulate clone() {
        RuleConditionElement clonedSource = this.source instanceof GroupElement ? ((GroupElement)this.source).cloneOnlyGroup() : this.source.clone();
        SingleAccumulate clone = new SingleAccumulate(clonedSource, this.requiredDeclarations, this.accumulator);
        this.registerClone(clone);
        return clone;
    }

    @Override
    protected void replaceAccumulatorDeclaration(Declaration declaration, Declaration resolved) {
        if (this.accumulator instanceof MVELAccumulatorFunctionExecutor) {
            ((MVELAccumulatorFunctionExecutor)this.accumulator).replaceDeclaration(declaration, resolved);
        }
    }

    @Override
    public Object createWorkingMemoryContext() {
        return this.accumulator.createWorkingMemoryContext();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.accumulator.hashCode();
        result = 31 * result + Arrays.hashCode(this.requiredDeclarations);
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SingleAccumulate other = (SingleAccumulate)obj;
        if (!this.accumulator.equals(other.accumulator)) {
            return false;
        }
        if (!Arrays.equals(this.requiredDeclarations, other.requiredDeclarations)) {
            return false;
        }
        return !(this.source == null ? other.source != null : !this.source.equals(other.source));
    }

    public final class Wirer
    implements Wireable.Immutable,
    Serializable {
        private static final long serialVersionUID = -9072646735174734614L;
        private transient boolean initialized;

        @Override
        public void wire(Object object) {
            Accumulator acc = KiePolicyHelper.isPolicyEnabled() ? new Accumulator.SafeAccumulator((Accumulator)object) : (Accumulator)object;
            SingleAccumulate.this.accumulator = acc;
            for (Accumulate clone : SingleAccumulate.this.cloned) {
                ((SingleAccumulate)clone).accumulator = acc;
            }
            this.initialized = true;
        }

        @Override
        public boolean isInitialized() {
            return this.initialized;
        }
    }
}

