/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.backend.marshalling.v1x;

import com.thoughtworks.xstream.io.xml.QNameMap;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import java.io.BufferedReader;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamReader;
import org.kie.dmn.api.marshalling.DMNExtensionRegister;
import org.kie.dmn.api.marshalling.DMNMarshaller;
import org.kie.dmn.backend.marshalling.CustomStaxReader;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.model.v1_1.KieDMNModelInstrumentedBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XStreamMarshaller
implements DMNMarshaller {
    private static Logger logger = LoggerFactory.getLogger(XStreamMarshaller.class);
    private List<DMNExtensionRegister> extensionRegisters = new ArrayList<DMNExtensionRegister>();
    private final org.kie.dmn.backend.marshalling.v1_1.xstream.XStreamMarshaller xstream11;
    private final org.kie.dmn.backend.marshalling.v1_2.xstream.XStreamMarshaller xstream12;
    private final org.kie.dmn.backend.marshalling.v1_3.xstream.XStreamMarshaller xstream13;
    private static final StaxDriver staxDriver = new StaxDriver();

    public XStreamMarshaller() {
        this.xstream11 = new org.kie.dmn.backend.marshalling.v1_1.xstream.XStreamMarshaller();
        this.xstream12 = new org.kie.dmn.backend.marshalling.v1_2.xstream.XStreamMarshaller();
        this.xstream13 = new org.kie.dmn.backend.marshalling.v1_3.xstream.XStreamMarshaller();
    }

    public XStreamMarshaller(List<DMNExtensionRegister> extensionRegisters) {
        this.extensionRegisters.addAll(extensionRegisters);
        this.xstream11 = new org.kie.dmn.backend.marshalling.v1_1.xstream.XStreamMarshaller(extensionRegisters);
        this.xstream12 = new org.kie.dmn.backend.marshalling.v1_2.xstream.XStreamMarshaller(extensionRegisters);
        this.xstream13 = new org.kie.dmn.backend.marshalling.v1_3.xstream.XStreamMarshaller(extensionRegisters);
    }

    /*
     * Exception decompiling
     */
    public Definitions unmarshal(String xml) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static DMN_VERSION inferDMNVersion(Reader from) {
        try {
            XMLStreamReader xmlReader = staxDriver.getInputFactory().createXMLStreamReader(from);
            CustomStaxReader customStaxReader = new CustomStaxReader(new QNameMap(), xmlReader);
            DMN_VERSION result = DMN_VERSION.UNKNOWN;
            if (customStaxReader.getNsContext().values().stream().anyMatch(s -> "https://www.omg.org/spec/DMN/20191111/MODEL/".equals(s))) {
                result = DMN_VERSION.DMN_v1_3;
            } else if (customStaxReader.getNsContext().values().stream().anyMatch(s -> "http://www.omg.org/spec/DMN/20180521/MODEL/".equals(s))) {
                result = DMN_VERSION.DMN_v1_2;
            } else if (customStaxReader.getNsContext().values().stream().anyMatch(s -> "http://www.omg.org/spec/DMN/20151101/dmn.xsd".equals(s))) {
                result = DMN_VERSION.DMN_v1_1;
            }
            xmlReader.close();
            customStaxReader.close();
            return result;
        }
        catch (Exception e) {
            logger.error("Error unmarshalling DMN model from reader.", (Throwable)e);
            return DMN_VERSION.UNKNOWN;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Definitions unmarshal(Reader isr) {
        try (BufferedReader buffer = new BufferedReader(isr);){
            String xml = buffer.lines().collect(Collectors.joining("\n"));
            Definitions definitions = this.unmarshal(xml);
            return definitions;
        }
        catch (Exception e) {
            logger.error("Error unmarshalling DMN model from reader.", (Throwable)e);
            return null;
        }
    }

    public String marshal(Object o) {
        if (o instanceof org.kie.dmn.model.v1_3.KieDMNModelInstrumentedBase) {
            return this.xstream13.marshal(o);
        }
        if (o instanceof org.kie.dmn.model.v1_2.KieDMNModelInstrumentedBase) {
            return this.xstream12.marshal(o);
        }
        if (o instanceof KieDMNModelInstrumentedBase) {
            return this.xstream11.marshal(o);
        }
        return this.xstream13.marshal(o);
    }

    public void marshal(Object o, Writer out) {
        if (o instanceof org.kie.dmn.model.v1_3.KieDMNModelInstrumentedBase) {
            this.xstream13.marshal(o, out);
        } else if (o instanceof org.kie.dmn.model.v1_2.KieDMNModelInstrumentedBase) {
            this.xstream12.marshal(o, out);
        } else if (o instanceof KieDMNModelInstrumentedBase) {
            this.xstream11.marshal(o, out);
        } else {
            this.xstream13.marshal(o, out);
        }
    }

    public static enum DMN_VERSION {
        UNKNOWN,
        DMN_v1_1,
        DMN_v1_2,
        DMN_v1_3;

    }
}

