/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.instance.ContextInstance;
import org.jbpm.process.instance.ContextInstanceContainer;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.context.exception.ExceptionScopeInstance;
import org.jbpm.process.instance.context.exclusive.ExclusiveGroupInstance;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.process.instance.impl.Action;
import org.jbpm.process.instance.impl.ConstraintEvaluator;
import org.jbpm.process.instance.impl.NoOpExecutionErrorHandler;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.WorkflowRuntimeException;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.CompositeNodeInstance;
import org.kie.api.definition.process.Connection;
import org.kie.api.definition.process.Node;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.process.ProcessContext;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.runtime.error.ExecutionErrorHandler;
import org.kie.internal.runtime.error.ExecutionErrorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NodeInstanceImpl
implements NodeInstance,
Serializable {
    public static final String UNIQUE_ID = "UniqueId";
    private static final long serialVersionUID = 510L;
    protected static final Logger logger = LoggerFactory.getLogger(NodeInstanceImpl.class);
    private long id = -1L;
    private long nodeId;
    private WorkflowProcessInstance processInstance;
    private NodeInstanceContainer nodeInstanceContainer;
    private Map<String, Object> metaData = new HashMap<String, Object>();
    private int level;
    protected Date triggerTime;
    protected int slaCompliance = 0;
    protected Date slaDueDate;
    protected long slaTimerId = -1L;
    protected boolean aborted = false;
    protected transient Map<String, Object> dynamicParameters;

    public boolean isAborted() {
        return this.aborted;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public void setNodeId(long nodeId) {
        this.nodeId = nodeId;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public String getNodeName() {
        Node node = this.getNode();
        return node == null ? "" : node.getName();
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setProcessInstance(WorkflowProcessInstance processInstance) {
        this.processInstance = processInstance;
    }

    public WorkflowProcessInstance getProcessInstance() {
        return this.processInstance;
    }

    public org.kie.api.runtime.process.NodeInstanceContainer getNodeInstanceContainer() {
        return this.nodeInstanceContainer;
    }

    public void setNodeInstanceContainer(org.kie.api.runtime.process.NodeInstanceContainer nodeInstanceContainer) {
        this.nodeInstanceContainer = (NodeInstanceContainer)nodeInstanceContainer;
        if (nodeInstanceContainer != null) {
            this.nodeInstanceContainer.addNodeInstance(this);
        }
    }

    @Override
    public Node getNode() {
        try {
            return ((NodeContainer)this.nodeInstanceContainer.getNodeContainer()).internalGetNode(this.nodeId);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unknown node id: " + this.nodeId + " for node instance " + this.getUniqueId() + " for process instance " + this.processInstance, e);
        }
    }

    public boolean isInversionOfControl() {
        return false;
    }

    @Override
    public void cancel() {
        InternalKnowledgeRuntime kruntime;
        this.aborted = true;
        boolean hidden = false;
        Node node = this.getNode();
        if (node != null && node.getMetaData().get("hidden") != null) {
            hidden = true;
        }
        if (!hidden) {
            kruntime = this.getProcessInstance().getKnowledgeRuntime();
            ((InternalProcessRuntime)kruntime.getProcessRuntime()).getProcessEventSupport().fireBeforeNodeLeft((org.kie.api.runtime.process.NodeInstance)this, (KieRuntime)kruntime);
        }
        this.nodeInstanceContainer.removeNodeInstance(this);
        if (!hidden) {
            kruntime = this.getProcessInstance().getKnowledgeRuntime();
            ((InternalProcessRuntime)kruntime.getProcessRuntime()).getProcessEventSupport().fireAfterNodeLeft((org.kie.api.runtime.process.NodeInstance)this, (KieRuntime)kruntime);
        }
    }

    @Override
    public final void trigger(org.kie.api.runtime.process.NodeInstance from, String type) {
        boolean hidden = false;
        if (this.getNode().getMetaData().get("hidden") != null) {
            hidden = true;
        }
        if (from != null) {
            this.metaData.put("IncomingConnection", from.getNode().getMetaData().get(UNIQUE_ID));
        }
        if (this.dynamicParameters != null) {
            for (Map.Entry<String, Object> entry : this.dynamicParameters.entrySet()) {
                this.setVariable(entry.getKey(), entry.getValue());
            }
        }
        this.configureSla();
        InternalKnowledgeRuntime kruntime = this.getProcessInstance().getKnowledgeRuntime();
        if (!hidden) {
            ((InternalProcessRuntime)kruntime.getProcessRuntime()).getProcessEventSupport().fireBeforeNodeTriggered((org.kie.api.runtime.process.NodeInstance)this, (KieRuntime)kruntime);
        }
        try {
            this.getExecutionErrorHandler().processing((org.kie.api.runtime.process.NodeInstance)this);
            this.internalTrigger(from, type);
        }
        catch (WorkflowRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WorkflowRuntimeException((org.kie.api.runtime.process.NodeInstance)this, (ProcessInstance)this.getProcessInstance(), e);
        }
        if (!hidden) {
            ((InternalProcessRuntime)kruntime.getProcessRuntime()).getProcessEventSupport().fireAfterNodeTriggered((org.kie.api.runtime.process.NodeInstance)this, (KieRuntime)kruntime);
        }
    }

    public abstract void internalTrigger(org.kie.api.runtime.process.NodeInstance var1, String var2);

    protected void executeAction(Action action) {
        org.drools.core.spi.ProcessContext context = new org.drools.core.spi.ProcessContext((KieRuntime)this.getProcessInstance().getKnowledgeRuntime());
        context.setNodeInstance((org.kie.api.runtime.process.NodeInstance)this);
        try {
            action.execute((ProcessContext)context);
        }
        catch (Exception e) {
            String exceptionName = e.getClass().getName();
            ExceptionScopeInstance exceptionScopeInstance = (ExceptionScopeInstance)this.resolveContextInstance("ExceptionScope", exceptionName);
            if (exceptionScopeInstance == null) {
                throw new WorkflowRuntimeException(this, this.getProcessInstance(), "Unable to execute Action: " + e.getMessage(), e);
            }
            exceptionScopeInstance.handleException(exceptionName, e);
            this.cancel();
        }
    }

    protected void triggerCompleted(String type, boolean remove) {
        this.getExecutionErrorHandler().processed((org.kie.api.runtime.process.NodeInstance)this);
        Node node = this.getNode();
        if (node != null) {
            String uniqueId = (String)node.getMetaData().get(UNIQUE_ID);
            if (uniqueId == null) {
                uniqueId = ((NodeImpl)node).getUniqueId();
            }
            ((WorkflowProcessInstanceImpl)this.processInstance).addCompletedNodeId(uniqueId);
            ((WorkflowProcessInstanceImpl)this.processInstance).getIterationLevels().remove(uniqueId);
        }
        if (this.getNodeInstanceContainer().getNodeInstance(this.getId()) == null || ((NodeInstanceContainer)this.getNodeInstanceContainer()).getState() != 1) {
            return;
        }
        if (remove) {
            ((NodeInstanceContainer)this.getNodeInstanceContainer()).removeNodeInstance(this);
        }
        List<Connection> connections = null;
        if (node != null) {
            if ("true".equals(System.getProperty("jbpm.enable.multi.con")) && ((NodeImpl)node).getConstraints().size() > 0) {
                int priority = Integer.MAX_VALUE;
                connections = ((NodeImpl)node).getDefaultOutgoingConnections();
                boolean found = false;
                ArrayList<NodeInstanceTrigger> arrayList = new ArrayList<NodeInstanceTrigger>();
                ArrayList<Connection> outgoingCopy = new ArrayList<Connection>(connections);
                while (!outgoingCopy.isEmpty()) {
                    priority = Integer.MAX_VALUE;
                    Connection selectedConnection = null;
                    ConstraintEvaluator selectedConstraint = null;
                    for (Connection connection : outgoingCopy) {
                        ConstraintEvaluator constraint = (ConstraintEvaluator)((NodeImpl)node).getConstraint(connection);
                        if (constraint == null || constraint.getPriority() >= priority || constraint.isDefault()) continue;
                        priority = constraint.getPriority();
                        selectedConnection = connection;
                        selectedConstraint = constraint;
                    }
                    if (selectedConstraint == null) break;
                    if (selectedConstraint.evaluate(this, selectedConnection, selectedConstraint)) {
                        arrayList.add(new NodeInstanceTrigger(this.followConnection(selectedConnection), selectedConnection.getToType()));
                        found = true;
                    }
                    outgoingCopy.remove(selectedConnection);
                }
                for (NodeInstanceTrigger nodeInstance : arrayList) {
                    if (((NodeInstanceContainer)this.getNodeInstanceContainer()).getState() != 1) {
                        return;
                    }
                    this.triggerNodeInstance(nodeInstance.getNodeInstance(), nodeInstance.getToType());
                }
                if (!found) {
                    for (Connection connection : connections) {
                        ConstraintEvaluator constraint = (ConstraintEvaluator)((NodeImpl)node).getConstraint(connection);
                        if (!constraint.isDefault()) continue;
                        this.triggerConnection(connection);
                        found = true;
                        break;
                    }
                }
                if (!found) {
                    throw new IllegalArgumentException("Uncontrolled flow node could not find at least one valid outgoing connection " + this.getNode().getName());
                }
                return;
            }
            connections = node.getOutgoingConnections(type);
        }
        if (connections == null || connections.isEmpty()) {
            boolean hidden = false;
            Node currentNode = this.getNode();
            if (currentNode != null && currentNode.getMetaData().get("hidden") != null) {
                hidden = true;
            }
            InternalKnowledgeRuntime internalKnowledgeRuntime = this.getProcessInstance().getKnowledgeRuntime();
            if (!hidden) {
                ((InternalProcessRuntime)internalKnowledgeRuntime.getProcessRuntime()).getProcessEventSupport().fireBeforeNodeLeft((org.kie.api.runtime.process.NodeInstance)this, (KieRuntime)internalKnowledgeRuntime);
            }
            ((NodeInstanceContainer)this.getNodeInstanceContainer()).nodeInstanceCompleted(this, type);
            if (!hidden) {
                ((InternalProcessRuntime)internalKnowledgeRuntime.getProcessRuntime()).getProcessEventSupport().fireAfterNodeLeft((org.kie.api.runtime.process.NodeInstance)this, (KieRuntime)internalKnowledgeRuntime);
            }
        } else {
            HashMap<NodeInstance, String> nodeInstances = new HashMap<NodeInstance, String>();
            for (Connection connection : connections) {
                nodeInstances.put(this.followConnection(connection), connection.getToType());
            }
            for (Map.Entry entry : nodeInstances.entrySet()) {
                if (((NodeInstanceContainer)this.getNodeInstanceContainer()).getState() != 1) {
                    return;
                }
                this.triggerNodeInstance((NodeInstance)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    protected NodeInstance followConnection(Connection connection) {
        List<ContextInstance> contextInstances;
        org.kie.api.runtime.process.NodeInstanceContainer parent = this.getNodeInstanceContainer();
        if (parent instanceof ContextInstanceContainer && (contextInstances = ((ContextInstanceContainer)parent).getContextInstances("ExclusiveGroup")) != null) {
            for (ContextInstance contextInstance : new ArrayList<ContextInstance>(contextInstances)) {
                ExclusiveGroupInstance groupInstance = (ExclusiveGroupInstance)contextInstance;
                if (!groupInstance.containsNodeInstance(this)) continue;
                for (org.kie.api.runtime.process.NodeInstance nodeInstance : groupInstance.getNodeInstances()) {
                    if (nodeInstance == this) continue;
                    ((NodeInstance)nodeInstance).cancel();
                }
                ((ContextInstanceContainer)parent).removeContextInstance("ExclusiveGroup", contextInstance);
            }
        }
        return ((NodeInstanceContainer)this.getNodeInstanceContainer()).getNodeInstance(connection.getTo());
    }

    protected void triggerNodeInstance(NodeInstance nodeInstance, String type) {
        this.triggerNodeInstance(nodeInstance, type, true);
    }

    protected org.kie.api.runtime.process.NodeInstance getFrom() {
        return this;
    }

    protected void triggerNodeInstance(NodeInstance nodeInstance, String type, boolean fireEvents) {
        this.triggerTime = new Date();
        boolean hidden = false;
        if (this.getNode().getMetaData().get("hidden") != null) {
            hidden = true;
        }
        InternalKnowledgeRuntime kruntime = this.getProcessInstance().getKnowledgeRuntime();
        this.metaData.put("OutgoingConnection", nodeInstance.getNode().getMetaData().get(UNIQUE_ID));
        if (!hidden && fireEvents) {
            ((InternalProcessRuntime)kruntime.getProcessRuntime()).getProcessEventSupport().fireBeforeNodeLeft((org.kie.api.runtime.process.NodeInstance)this, (KieRuntime)kruntime);
        }
        nodeInstance.trigger(this.getFrom(), type);
        if (!hidden && fireEvents) {
            ((InternalProcessRuntime)kruntime.getProcessRuntime()).getProcessEventSupport().fireAfterNodeLeft((org.kie.api.runtime.process.NodeInstance)this, (KieRuntime)kruntime);
        }
    }

    protected void triggerConnection(Connection connection) {
        this.triggerNodeInstance(this.followConnection(connection), connection.getToType());
    }

    public void retrigger(boolean remove) {
        if (remove) {
            this.cancel();
        }
        this.triggerNode(this.getNodeId(), !remove);
    }

    public void triggerNode(long nodeId) {
        this.triggerNode(nodeId, true);
    }

    public void triggerNode(long nodeId, boolean fireEvents) {
        NodeInstance nodeInstance = ((NodeInstanceContainer)this.getNodeInstanceContainer()).getNodeInstance(this.getNode().getNodeContainer().getNode(nodeId));
        this.triggerNodeInstance(nodeInstance, "DROOLS_DEFAULT", fireEvents);
    }

    public Context resolveContext(String contextId, Object param) {
        if (this.getNode() == null) {
            return null;
        }
        return ((NodeImpl)this.getNode()).resolveContext(contextId, param);
    }

    @Override
    public ContextInstance resolveContextInstance(String contextId, Object param) {
        Context context = this.resolveContext(contextId, param);
        if (context == null) {
            return null;
        }
        ContextInstanceContainer contextInstanceContainer = this.getContextInstanceContainer(context.getContextContainer());
        if (contextInstanceContainer == null) {
            throw new IllegalArgumentException("Could not find context instance container for context");
        }
        return contextInstanceContainer.getContextInstance(context);
    }

    private ContextInstanceContainer getContextInstanceContainer(ContextContainer contextContainer) {
        ContextInstanceContainer contextInstanceContainer = null;
        contextInstanceContainer = this instanceof ContextInstanceContainer ? (ContextInstanceContainer)((Object)this) : this.getEnclosingContextInstanceContainer(this);
        while (contextInstanceContainer != null) {
            if (contextInstanceContainer.getContextContainer() == contextContainer) {
                return contextInstanceContainer;
            }
            contextInstanceContainer = this.getEnclosingContextInstanceContainer((org.kie.api.runtime.process.NodeInstance)contextInstanceContainer);
        }
        return null;
    }

    private ContextInstanceContainer getEnclosingContextInstanceContainer(org.kie.api.runtime.process.NodeInstance nodeInstance) {
        org.kie.api.runtime.process.NodeInstanceContainer nodeInstanceContainer = nodeInstance.getNodeInstanceContainer();
        while (true) {
            if (nodeInstanceContainer instanceof ContextInstanceContainer) {
                return (ContextInstanceContainer)nodeInstanceContainer;
            }
            if (!(nodeInstanceContainer instanceof org.kie.api.runtime.process.NodeInstance)) break;
            nodeInstanceContainer = ((org.kie.api.runtime.process.NodeInstance)nodeInstanceContainer).getNodeInstanceContainer();
        }
        return null;
    }

    public Object getVariable(String variableName) {
        VariableScopeInstance variableScope = (VariableScopeInstance)this.resolveContextInstance("VariableScope", variableName);
        if (variableScope == null) {
            variableScope = (VariableScopeInstance)this.getProcessInstance().getContextInstance("VariableScope");
        }
        return variableScope.getVariable(variableName);
    }

    public void setVariable(String variableName, Object value) {
        VariableScopeInstance variableScope = (VariableScopeInstance)this.resolveContextInstance("VariableScope", variableName);
        if (variableScope == null && (variableScope = (VariableScopeInstance)this.getProcessInstance().getContextInstance("VariableScope")).getVariableScope().findVariable(variableName) == null) {
            variableScope = null;
        }
        if (variableScope == null) {
            logger.error("Could not find variable {}", (Object)variableName);
            logger.error("Using process-level scope");
            variableScope = (VariableScopeInstance)this.getProcessInstance().getContextInstance("VariableScope");
        }
        variableScope.setVariable(variableName, value);
    }

    public String getUniqueId() {
        String result = "" + this.getId();
        org.kie.api.runtime.process.NodeInstanceContainer parent = this.getNodeInstanceContainer();
        while (parent instanceof CompositeNodeInstance) {
            CompositeNodeInstance nodeInstance = (CompositeNodeInstance)parent;
            result = nodeInstance.getId() + ":" + result;
            parent = nodeInstance.getNodeInstanceContainer();
        }
        return result;
    }

    public Map<String, Object> getMetaData() {
        return this.metaData;
    }

    public Object getMetaData(String name) {
        return this.metaData.get(name);
    }

    public void setMetaData(String name, Object data) {
        this.metaData.put(name, data);
    }

    @Override
    public void setDynamicParameters(Map<String, Object> dynamicParameters) {
        this.dynamicParameters = dynamicParameters;
    }

    protected ExecutionErrorHandler getExecutionErrorHandler() {
        ExecutionErrorManager errorManager = (ExecutionErrorManager)this.getProcessInstance().getKnowledgeRuntime().getEnvironment().get("ExecutionErrorManager");
        if (errorManager == null) {
            return new NoOpExecutionErrorHandler();
        }
        return errorManager.getHandler();
    }

    protected void configureSla() {
    }

    @Override
    public int getSlaCompliance() {
        return this.slaCompliance;
    }

    public void internalSetSlaCompliance(int slaCompliance) {
        this.slaCompliance = slaCompliance;
    }

    @Override
    public Date getSlaDueDate() {
        return this.slaDueDate;
    }

    public void internalSetSlaDueDate(Date slaDueDate) {
        this.slaDueDate = slaDueDate;
    }

    @Override
    public Long getSlaTimerId() {
        return this.slaTimerId;
    }

    public void internalSetSlaTimerId(Long slaTimerId) {
        this.slaTimerId = slaTimerId;
    }

    @Override
    public Date getTriggerTime() {
        return this.triggerTime;
    }

    protected class NodeInstanceTrigger {
        private NodeInstance nodeInstance;
        private String toType;

        public NodeInstanceTrigger(NodeInstance nodeInstance, String toType) {
            this.nodeInstance = nodeInstance;
            this.toType = toType;
        }

        public NodeInstance getNodeInstance() {
            return this.nodeInstance;
        }

        public String getToType() {
            return this.toType;
        }
    }
}

