/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.impl;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.scenariosimulation.ScenarioSimulationResult;
import org.kie.server.api.rest.RestURI;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.ScenarioSimulationServicesClient;
import org.kie.server.client.impl.AbstractKieServicesClientImpl;

public class ScenarioSimulationServicesClientImpl
extends AbstractKieServicesClientImpl
implements ScenarioSimulationServicesClient {
    public ScenarioSimulationServicesClientImpl(KieServicesConfiguration config) {
        super(config);
    }

    public ScenarioSimulationServicesClientImpl(KieServicesConfiguration config, ClassLoader classLoader) {
        super(config, classLoader);
    }

    @Override
    public ServiceResponse<ScenarioSimulationResult> executeScenarioByPath(String containerId, String localPath) throws IOException {
        try (Stream<String> contentStream = Files.lines(Paths.get(localPath, new String[0]), StandardCharsets.UTF_8);){
            String fileContent = contentStream.collect(Collectors.joining("\n"));
            ServiceResponse<ScenarioSimulationResult> serviceResponse = this.executeScenario(containerId, fileContent);
            return serviceResponse;
        }
    }

    @Override
    public ServiceResponse<ScenarioSimulationResult> executeScenario(String containerId, String content) {
        if (!this.config.isRest()) {
            throw new IllegalStateException("Only REST is supported");
        }
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        valuesMap.put("containerId", containerId);
        ServiceResponse<ScenarioSimulationResult> response = this.makeHttpPostRequestAndCreateServiceResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/scesim", valuesMap), content, ScenarioSimulationResult.class);
        if (this.shouldReturnWithNullResponse(response)) {
            return null;
        }
        return response;
    }
}

