/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.definition;

import org.optaplanner.core.api.score.FeasibilityScore;
import org.optaplanner.core.impl.score.definition.AbstractScoreDefinition;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;

public abstract class AbstractBendableScoreDefinition<S extends FeasibilityScore<S>>
extends AbstractScoreDefinition<S>
implements ScoreDefinition<S> {
    protected final int hardLevelsSize;
    protected final int softLevelsSize;

    protected static String[] generateLevelLabels(int hardLevelsSize, int softLevelsSize) {
        if (hardLevelsSize < 0 || softLevelsSize < 0) {
            throw new IllegalArgumentException("The hardLevelsSize (" + hardLevelsSize + ") and softLevelsSize (" + softLevelsSize + ") should be positive.");
        }
        String[] levelLabels = new String[hardLevelsSize + softLevelsSize];
        for (int i = 0; i < levelLabels.length; ++i) {
            String labelPrefix = i < hardLevelsSize ? "hard " + i : "soft " + (i - hardLevelsSize);
            levelLabels[i] = labelPrefix + " score";
        }
        return levelLabels;
    }

    public AbstractBendableScoreDefinition(int hardLevelsSize, int softLevelsSize) {
        super(AbstractBendableScoreDefinition.generateLevelLabels(hardLevelsSize, softLevelsSize));
        this.hardLevelsSize = hardLevelsSize;
        this.softLevelsSize = softLevelsSize;
    }

    public int getHardLevelsSize() {
        return this.hardLevelsSize;
    }

    public int getSoftLevelsSize() {
        return this.softLevelsSize;
    }

    @Override
    public int getLevelsSize() {
        return this.hardLevelsSize + this.softLevelsSize;
    }

    @Override
    public int getFeasibleLevelsSize() {
        return this.hardLevelsSize;
    }
}

