/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.prometheus;

import io.prometheus.client.Counter;
import io.prometheus.client.Histogram;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.kie.dmn.api.core.ast.DecisionNode;
import org.kie.dmn.api.core.event.AfterEvaluateBKMEvent;
import org.kie.dmn.api.core.event.AfterEvaluateContextEntryEvent;
import org.kie.dmn.api.core.event.AfterEvaluateDecisionEvent;
import org.kie.dmn.api.core.event.AfterEvaluateDecisionServiceEvent;
import org.kie.dmn.api.core.event.AfterEvaluateDecisionTableEvent;
import org.kie.dmn.api.core.event.BeforeEvaluateBKMEvent;
import org.kie.dmn.api.core.event.BeforeEvaluateContextEntryEvent;
import org.kie.dmn.api.core.event.BeforeEvaluateDecisionEvent;
import org.kie.dmn.api.core.event.BeforeEvaluateDecisionServiceEvent;
import org.kie.dmn.api.core.event.BeforeEvaluateDecisionTableEvent;
import org.kie.dmn.api.core.event.DMNRuntimeEventListener;
import org.kie.dmn.core.impl.AfterEvaluateDecisionEventImpl;
import org.kie.dmn.core.impl.BeforeEvaluateDecisionEventImpl;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.prometheus.PrometheusMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusMetricsDMNListener
implements DMNRuntimeEventListener {
    private static final Logger logger = LoggerFactory.getLogger(PrometheusMetricsDMNListener.class);
    private final PrometheusMetrics metrics;
    private final KieContainerInstance kieContainer;

    public PrometheusMetricsDMNListener(PrometheusMetrics metrics, KieContainerInstance kieContainer) {
        this.metrics = metrics;
        this.kieContainer = kieContainer;
    }

    public void beforeEvaluateDecision(BeforeEvaluateDecisionEvent e) {
        long nanoTime = System.nanoTime();
        BeforeEvaluateDecisionEventImpl event = this.getBeforeImpl(e);
        event.setTimestamp(nanoTime);
    }

    public void afterEvaluateDecision(AfterEvaluateDecisionEvent e) {
        AfterEvaluateDecisionEventImpl afterImpl = this.getAfterImpl(e);
        BeforeEvaluateDecisionEventImpl event = this.getBeforeImpl(afterImpl.getBeforeEvent());
        DecisionNode decisionNode = e.getDecision();
        long startTime = event.getTimestamp();
        long elapsed = System.nanoTime() - startTime;
        ReleaseId releaseId = this.kieContainer.getResource().getReleaseId();
        ((Histogram.Child)this.metrics.getEvaluationTimeHistogram().labels(new String[]{this.kieContainer.getContainerId(), releaseId.getGroupId(), releaseId.getArtifactId(), releaseId.getVersion(), decisionNode.getModelName(), decisionNode.getModelNamespace()})).observe((double)elapsed);
        DMNDecisionResult decisionResultById = e.getResult().getDecisionResultById(decisionNode.getId());
        if (decisionResultById != null && decisionResultById.hasErrors()) {
            ((Counter.Child)this.metrics.getDMNNumberOfEvaluationFailed().labels(new String[]{this.kieContainer.getContainerId(), releaseId.getGroupId(), releaseId.getArtifactId(), releaseId.getVersion(), decisionNode.getModelName(), decisionNode.getModelNamespace()})).inc();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Elapsed time: " + elapsed);
        }
    }

    private AfterEvaluateDecisionEventImpl getAfterImpl(AfterEvaluateDecisionEvent e) {
        return (AfterEvaluateDecisionEventImpl)e;
    }

    public void beforeEvaluateBKM(BeforeEvaluateBKMEvent event) {
    }

    public void afterEvaluateBKM(AfterEvaluateBKMEvent event) {
    }

    public void beforeEvaluateContextEntry(BeforeEvaluateContextEntryEvent event) {
    }

    public void afterEvaluateContextEntry(AfterEvaluateContextEntryEvent event) {
    }

    public void beforeEvaluateDecisionTable(BeforeEvaluateDecisionTableEvent event) {
    }

    public void afterEvaluateDecisionTable(AfterEvaluateDecisionTableEvent event) {
    }

    public void beforeEvaluateDecisionService(BeforeEvaluateDecisionServiceEvent event) {
    }

    public void afterEvaluateDecisionService(AfterEvaluateDecisionServiceEvent event) {
    }

    private BeforeEvaluateDecisionEventImpl getBeforeImpl(BeforeEvaluateDecisionEvent e) {
        return (BeforeEvaluateDecisionEventImpl)e;
    }
}

