/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.prometheus;

import io.prometheus.client.Summary;
import org.kie.server.services.prometheus.PrometheusKieServerExtension;
import org.kie.server.services.prometheus.PrometheusMetrics;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListenerAdapter;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;

public class PrometheusMetricsSolverListener
extends PhaseLifecycleListenerAdapter<Object> {
    private final PrometheusMetrics metrics;
    private final String solverId;
    private Summary.Timer timer;

    public PrometheusMetricsSolverListener(String solverId) {
        this(solverId, PrometheusKieServerExtension.getMetrics());
    }

    public PrometheusMetricsSolverListener(String solverId, PrometheusMetrics metrics) {
        this.solverId = solverId;
        this.metrics = metrics;
    }

    public void solvingStarted(DefaultSolverScope solverScope) {
        this.metrics.getOptaPlannerSolverCount().inc();
        this.timer = ((Summary.Child)this.metrics.getOptaPlannerSolverDuration().labels(new String[]{this.solverId})).startTimer();
    }

    public void solvingEnded(DefaultSolverScope solverScope) {
        this.metrics.getOptaPlannerSolverCount().dec();
        ((Summary.Child)this.metrics.getOptaPlannerSolverScoreCalculationSpeed().labels(new String[]{this.solverId})).observe(this.getScoreCalculationSpeed(solverScope));
        this.timer.observeDuration();
    }

    private double getScoreCalculationSpeed(DefaultSolverScope solverScope) {
        long timeMillisSpent = solverScope.calculateTimeMillisSpentUpToNow();
        return solverScope.getScoreCalculationCount() * 1000L / (timeMillisSpent == 0L ? 1L : timeMillisSpent);
    }
}

