/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.jbpm.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.kie.server.remote.rest.jbpm.ui.FormResource;
import org.kie.server.remote.rest.jbpm.ui.ImageResource;
import org.kie.server.remote.rest.jbpm.ui.StaticFilesResource;
import org.kie.server.services.api.KieServerApplicationComponentsService;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.api.SupportedTransports;
import org.kie.server.services.jbpm.ui.FormRendererBase;
import org.kie.server.services.jbpm.ui.FormServiceBase;
import org.kie.server.services.jbpm.ui.ImageServiceBase;

public class JbpmUIRestApplicationComponentsService
implements KieServerApplicationComponentsService {
    private static final String OWNER_EXTENSION = "jBPM-UI";

    public Collection<Object> getAppComponents(String extension, SupportedTransports type, Object ... services) {
        if (!OWNER_EXTENSION.equals(extension)) {
            return Collections.emptyList();
        }
        FormServiceBase formServiceBase = null;
        ImageServiceBase imageServiceBase = null;
        FormRendererBase formRendererBase = null;
        KieServerRegistry context = null;
        for (Object object : services) {
            if (object == null) continue;
            if (FormServiceBase.class.isAssignableFrom(object.getClass())) {
                formServiceBase = (FormServiceBase)object;
                continue;
            }
            if (ImageServiceBase.class.isAssignableFrom(object.getClass())) {
                imageServiceBase = (ImageServiceBase)object;
                continue;
            }
            if (FormRendererBase.class.isAssignableFrom(object.getClass())) {
                formRendererBase = (FormRendererBase)object;
                continue;
            }
            if (!KieServerRegistry.class.isAssignableFrom(object.getClass())) continue;
            context = (KieServerRegistry)object;
        }
        ArrayList<Object> components = new ArrayList<Object>(2);
        components.add(new FormResource(formServiceBase, formRendererBase, context));
        components.add(new ImageResource(imageServiceBase, context));
        components.add(new StaticFilesResource(formRendererBase));
        return components;
    }
}

