/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.hibernate.util;

import com.thoughtworks.xstream.core.JVM;
import org.hibernate.proxy.HibernateProxy;

public class Hibernate {
    public static final Class PersistentBag = Hibernate.loadHibernateType("org.hibernate.collection.internal.PersistentBag");
    public static final Class PersistentList = Hibernate.loadHibernateType("org.hibernate.collection.internal.PersistentList");
    public static final Class PersistentMap = Hibernate.loadHibernateType("org.hibernate.collection.internal.PersistentMap");
    public static final Class PersistentSet = Hibernate.loadHibernateType("org.hibernate.collection.internal.PersistentSet");
    public static final Class PersistentSortedMap = Hibernate.loadHibernateType("org.hibernate.collection.internal.PersistentSortedMap");
    public static final Class PersistentSortedSet = Hibernate.loadHibernateType("org.hibernate.collection.internal.PersistentSortedSet");
    public static final Class EnversList = Hibernate.loadHibernateEnversType("org.hibernate.envers.entities.mapper.relation.lazy.proxy.ListProxy");
    public static final Class EnversMap = Hibernate.loadHibernateEnversType("org.hibernate.envers.entities.mapper.relation.lazy.proxy.MapProxy");
    public static final Class EnversSet = Hibernate.loadHibernateEnversType("org.hibernate.envers.entities.mapper.relation.lazy.proxy.SetProxy");
    public static final Class EnversSortedMap = Hibernate.loadHibernateEnversType("org.hibernate.envers.entities.mapper.relation.lazy.proxy.SortedMapProxy");
    public static final Class EnversSortedSet = Hibernate.loadHibernateEnversType("org.hibernate.envers.entities.mapper.relation.lazy.proxy.SortedSetProxy");

    private static Class loadHibernateType(String name) {
        Class<?> type = null;
        try {
            try {
                type = HibernateProxy.class.getClassLoader().loadClass(name);
            }
            catch (ClassNotFoundException e) {
                type = HibernateProxy.class.getClassLoader().loadClass(name.replaceFirst("\\.internal\\.", "."));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return type;
    }

    private static Class loadHibernateEnversType(String name) {
        Class<?> type = null;
        if (JVM.isVersion((int)5)) {
            try {
                type = HibernateProxy.class.getClassLoader().loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return type;
    }
}

