/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.svg.model;

import org.jbpm.process.svg.model.NodeSummary;
import org.jbpm.process.svg.model.NodeTransformation;
import org.jbpm.process.svg.model.SVGSummary;
import org.w3c.dom.Element;

public class SetBorderColorTransformation
extends NodeTransformation {
    private String color;

    public SetBorderColorTransformation(String nodeId, String color) {
        super(nodeId);
        this.color = color;
    }

    public String getColor() {
        return this.color;
    }

    @Override
    public void transform(SVGSummary summary) {
        NodeSummary node = summary.getNode(this.getNodeId());
        if (node != null) {
            Element borderSubProcess;
            Element border = node.getBorder();
            if (border != null) {
                border.setAttribute("stroke", this.color);
                border.setAttribute("stroke-width", "2");
            }
            if ((borderSubProcess = node.getBorderSubProcess()) != null) {
                borderSubProcess.setAttribute("stroke", this.color);
                borderSubProcess.setAttribute("stroke-width", "2");
            }
        }
    }
}

