/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.util;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.drools.scenariosimulation.api.utils.ConstantsHolder;
import org.drools.scenariosimulation.backend.interfaces.ThrowingConsumer;
import org.drools.scenariosimulation.backend.util.DOMParserUtil;
import org.drools.scenariosimulation.backend.util.MigrationStrategy;
import org.drools.scenariosimulation.backend.util.ScenarioSimulationXMLPersistence;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class InMemoryMigrationStrategy
implements MigrationStrategy {
    @Override
    public ThrowingConsumer<Document> from1_0to1_1() {
        return document -> {
            DOMParserUtil.replaceNodeText(document, "expressionIdentifier", "type", "EXPECTED", "EXPECT");
            this.updateVersion((Document)document, "1.1");
        };
    }

    @Override
    public ThrowingConsumer<Document> from1_1to1_2() {
        return document -> {
            Map<Node, List<Node>> dmoSessionNodesMap = DOMParserUtil.getNestedChildrenNodesMap(document, "simulation", "simulationDescriptor", "dmoSession");
            Map<Node, List<Node>> dmnFilePathNodesMap = DOMParserUtil.getNestedChildrenNodesMap(document, "simulation", "simulationDescriptor", "dmnFilePath");
            Map<Node, List<Node>> typeNodesMap = DOMParserUtil.getNestedChildrenNodesMap(document, "simulation", "simulationDescriptor", "type");
            List<Node> dmoSessionNodes = dmoSessionNodesMap.values().iterator().next();
            List<Node> dmnFilePathNodes = dmnFilePathNodesMap.values().iterator().next();
            List<Node> typeNodes = typeNodesMap.values().iterator().next();
            if (dmoSessionNodes.isEmpty() && (dmnFilePathNodes.isEmpty() || typeNodes.isEmpty())) {
                DOMParserUtil.createNestedNodes(document, "simulation", "simulationDescriptor", "dmoSession", null);
                DOMParserUtil.createNestedNodes(document, "simulation", "simulationDescriptor", "type", "RULE");
            }
            this.updateVersion((Document)document, "1.2");
        };
    }

    @Override
    public ThrowingConsumer<Document> from1_2to1_3() {
        return document -> {
            List<Node> factMappingsNodes = DOMParserUtil.getNestedChildrenNodesList(document, "simulation", "simulationDescriptor", "factMappings");
            Node factMappingsNode = factMappingsNodes.get(0);
            List<Node> factIdentifierNodeList = DOMParserUtil.getNestedChildrenNodesList(factMappingsNode, "FactMapping", "factIdentifier");
            factIdentifierNodeList.forEach(factIdentifierNode -> {
                List<Node> factIdentifierNameList = DOMParserUtil.getChildrenNodesList(factIdentifierNode, "name");
                if (!factIdentifierNameList.isEmpty()) {
                    String factIdentifierName = factIdentifierNameList.get(0).getTextContent();
                    Node factMappingNode = factIdentifierNode.getParentNode();
                    List<Node> expressionElementsNodeList = DOMParserUtil.getChildrenNodesList(factMappingNode, "expressionElements");
                    Node expressionElementsNode = expressionElementsNodeList.isEmpty() ? DOMParserUtil.createNodeAtPosition(factMappingNode, "expressionElements", null, 0) : expressionElementsNodeList.get(0);
                    Node expressionElementNode = DOMParserUtil.createNodeAtPosition(expressionElementsNode, "ExpressionElement", null, 0);
                    DOMParserUtil.createNodeAtPosition(expressionElementNode, "step", factIdentifierName, 0);
                }
            });
            this.updateVersion((Document)document, "1.3");
        };
    }

    @Override
    public ThrowingConsumer<Document> from1_3to1_4() {
        return document -> {
            List<Node> typeNodes = DOMParserUtil.getNestedChildrenNodesList(document, "simulation", "simulationDescriptor", "type");
            if (!typeNodes.isEmpty()) {
                Node typeNode = typeNodes.get(0);
                Node simulationDescriptorNode = typeNode.getParentNode();
                String defaultContent = "default";
                switch (typeNode.getTextContent()) {
                    case "RULE": {
                        if (DOMParserUtil.getChildrenNodesList(simulationDescriptorNode, "kieSession").isEmpty()) {
                            DOMParserUtil.createNodeAtPosition(simulationDescriptorNode, "kieSession", defaultContent, null);
                        }
                        if (DOMParserUtil.getChildrenNodesList(simulationDescriptorNode, "kieBase").isEmpty()) {
                            DOMParserUtil.createNodeAtPosition(simulationDescriptorNode, "kieBase", defaultContent, null);
                        }
                        if (!DOMParserUtil.getChildrenNodesList(simulationDescriptorNode, "ruleFlowGroup").isEmpty()) break;
                        DOMParserUtil.createNodeAtPosition(simulationDescriptorNode, "ruleFlowGroup", defaultContent, null);
                        break;
                    }
                    case "DMN": {
                        if (DOMParserUtil.getChildrenNodesList(simulationDescriptorNode, "dmnNamespace").isEmpty()) {
                            DOMParserUtil.createNodeAtPosition(simulationDescriptorNode, "dmnNamespace", null, null);
                        }
                        if (!DOMParserUtil.getChildrenNodesList(simulationDescriptorNode, "dmnName").isEmpty()) break;
                        DOMParserUtil.createNodeAtPosition(simulationDescriptorNode, "dmnName", null, null);
                        break;
                    }
                }
                if (DOMParserUtil.getChildrenNodesList(simulationDescriptorNode, "skipFromBuild").isEmpty()) {
                    DOMParserUtil.createNodeAtPosition(simulationDescriptorNode, "skipFromBuild", "false", null);
                }
                if (DOMParserUtil.getChildrenNodesList(simulationDescriptorNode, "fileName").isEmpty()) {
                    DOMParserUtil.createNodeAtPosition(simulationDescriptorNode, "fileName", null, null);
                }
            }
            this.updateVersion((Document)document, "1.4");
        };
    }

    @Override
    public ThrowingConsumer<Document> from1_4to1_5() {
        return document -> {
            Node simulationDescriptorNode = DOMParserUtil.getNestedChildrenNodesList(document, "ScenarioSimulationModel", "simulation", "simulationDescriptor").get(0);
            List<Node> dmoSessionNodesList = DOMParserUtil.getChildrenNodesList(simulationDescriptorNode, "dmoSession");
            if (dmoSessionNodesList.isEmpty()) {
                DOMParserUtil.createNodeAtPosition(simulationDescriptorNode, "dmoSession", null, null);
            } else {
                Node dmoSessionNode = dmoSessionNodesList.get(0);
                if (Objects.equals("default", dmoSessionNode.getTextContent()) || Objects.equals("", dmoSessionNode.getTextContent())) {
                    simulationDescriptorNode.removeChild(dmoSessionNode);
                }
            }
            this.updateVersion((Document)document, "1.5");
        };
    }

    @Override
    public ThrowingConsumer<Document> from1_5to1_6() {
        return document -> {
            DOMParserUtil.cleanupNodes(document, "Scenario", "simulationDescriptor");
            List<Node> simulationFactMappingNodeList = DOMParserUtil.getNestedChildrenNodesList(document, "simulationDescriptor", "factMappings", "FactMapping");
            for (Node simulationFactMapping : simulationFactMappingNodeList) {
                this.replaceReference(simulationFactMappingNodeList, simulationFactMapping, "factIdentifier");
            }
            List<Node> scenarioFactMappingValueNodeList = DOMParserUtil.getNestedChildrenNodesList(document, "Scenario", "factMappingValues", "FactMappingValue");
            scenarioFactMappingValueNodeList.forEach(scenarioFactMappingValue -> {
                this.replaceReference(simulationFactMappingNodeList, (Node)scenarioFactMappingValue, "factIdentifier");
                this.replaceReference(simulationFactMappingNodeList, (Node)scenarioFactMappingValue, "expressionIdentifier");
            });
            this.updateVersion((Document)document, "1.6");
        };
    }

    @Override
    public ThrowingConsumer<Document> from1_6to1_7() {
        return document -> {
            List<Node> factMappingNodeList = DOMParserUtil.getNestedChildrenNodesList(document, "simulationDescriptor", "factMappings", "FactMapping");
            factMappingNodeList.forEach(factMappingNode -> {
                List<Node> expressionIdentifierNamesNodes = DOMParserUtil.getNestedChildrenNodesList(factMappingNode, "expressionIdentifier", "name");
                String expressionIdentifierName = expressionIdentifierNamesNodes.get(0).getTextContent();
                DOMParserUtil.createNodeAtPosition(factMappingNode, "columnWidth", Double.toString(ScenarioSimulationXMLPersistence.getColumnWidth(expressionIdentifierName)), null);
            });
            this.updateVersion((Document)document, "1.7");
        };
    }

    @Override
    public ThrowingConsumer<Document> from1_7to1_8() {
        return document -> {
            Node settingsNode = DOMParserUtil.createNodeAtPosition(document.getElementsByTagName("ScenarioSimulationModel").item(0), "settings", null, null);
            for (String setting : ConstantsHolder.SETTINGS) {
                Map<Node, List<Node>> childrenNodesMap = DOMParserUtil.getChildrenNodesMap(document, "simulationDescriptor", setting);
                childrenNodesMap.values().stream().filter(childNodeList -> !childNodeList.isEmpty()).findFirst().ifPresent(childNodeList -> {
                    Node node = (Node)childNodeList.get(0);
                    DOMParserUtil.createNodeAtPosition(settingsNode, node.getNodeName(), node.getTextContent(), null);
                    node.getParentNode().removeChild(node);
                });
            }
            List<Node> factMappingNodesList = DOMParserUtil.getNestedChildrenNodesList(document, "simulationDescriptor", "factMappings", "FactMapping");
            factMappingNodesList.forEach(factMappingNode -> DOMParserUtil.createNodeAtPosition(factMappingNode, "factMappingValueType", "NOT_EXPRESSION", null));
            Node backgroundNode = DOMParserUtil.createNodeAtPosition(document.getElementsByTagName("ScenarioSimulationModel").item(0), "background", null, null);
            Node simulationDescriptorNode = DOMParserUtil.createNodeAtPosition(backgroundNode, "simulationDescriptor", null, null);
            Node factMappingsNode = DOMParserUtil.createNodeAtPosition(simulationDescriptorNode, "factMappings", null, null);
            Node factMappingNode2 = DOMParserUtil.createNodeAtPosition(factMappingsNode, "FactMapping", null, null);
            DOMParserUtil.createNodeAtPosition(factMappingNode2, "factMappingValueType", "NOT_EXPRESSION", null);
            Node expressionElementsNode = DOMParserUtil.createNodeAtPosition(factMappingNode2, "expressionElements", null, null);
            ((Element)expressionElementsNode).setAttribute("class", "linked-list");
            Node expressionIdentifierNode = DOMParserUtil.createNodeAtPosition(factMappingNode2, "expressionIdentifier", null, null);
            DOMParserUtil.createNodeAtPosition(expressionIdentifierNode, "name", "1|1", null);
            DOMParserUtil.createNodeAtPosition(expressionIdentifierNode, "type", "GIVEN", null);
            Node factIdentifierNode = DOMParserUtil.createNodeAtPosition(factMappingNode2, "factIdentifier", null, null);
            DOMParserUtil.createNodeAtPosition(factIdentifierNode, "name", "Empty", null);
            DOMParserUtil.createNodeAtPosition(factIdentifierNode, "className", Void.class.getCanonicalName(), null);
            DOMParserUtil.createNodeAtPosition(factMappingNode2, "className", Void.class.getCanonicalName(), null);
            DOMParserUtil.createNodeAtPosition(factMappingNode2, "factAlias", "Instance 1", null);
            DOMParserUtil.createNodeAtPosition(factMappingNode2, "expressionAlias", "PROPERTY 1", null);
            Node scesimData = DOMParserUtil.createNodeAtPosition(backgroundNode, "scesimData", null, null);
            ((Element)scesimData).setAttribute("class", "linked-list");
            Node backgroundData = DOMParserUtil.createNodeAtPosition(scesimData, "BackgroundData", null, null);
            Node factMappingValues = DOMParserUtil.createNodeAtPosition(backgroundData, "factMappingValues", null, null);
            Node factMappingValue = DOMParserUtil.createNodeAtPosition(factMappingValues, "FactMappingValue", null, null);
            Node factIdentifier = DOMParserUtil.createNodeAtPosition(factMappingValue, "factIdentifier", null, null);
            DOMParserUtil.createNodeAtPosition(factIdentifier, "name", "Empty", null);
            DOMParserUtil.createNodeAtPosition(factIdentifier, "className", Void.class.getCanonicalName(), null);
            Node expressionIdentifier = DOMParserUtil.createNodeAtPosition(factMappingValue, "expressionIdentifier", null, null);
            DOMParserUtil.createNodeAtPosition(expressionIdentifier, "name", "1|1", null);
            DOMParserUtil.createNodeAtPosition(expressionIdentifier, "type", "GIVEN", null);
            this.updateVersion((Document)document, "1.8");
        };
    }

    private void replaceReference(List<Node> simulationFactMappingNodeList, Node containerNode, String referredNodeName) {
        Node referringNode;
        String referenceAttribute;
        List<Node> referredNodesList = DOMParserUtil.getChildrenNodesList(containerNode, referredNodeName);
        if (!referredNodesList.isEmpty() && (referenceAttribute = DOMParserUtil.getAttributeValue(referringNode = referredNodesList.get(0), "reference")) != null) {
            String referredIndex = "1";
            if (referenceAttribute.contains("[") && referenceAttribute.contains("]")) {
                referredIndex = referenceAttribute.substring(referenceAttribute.indexOf(91) + 1, referenceAttribute.indexOf(93));
            }
            int index = Integer.parseInt(referredIndex) - 1;
            Node referredFactMapping = simulationFactMappingNodeList.get(index);
            Node referredNode = DOMParserUtil.getChildrenNodesList(referredFactMapping, referredNodeName).get(0);
            Node clonedNode = referredNode.cloneNode(true);
            containerNode.replaceChild(clonedNode, referringNode);
        }
    }
}

