/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.runtime.query;

import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dashbuilder.dataset.DataSet;
import org.jbpm.kie.services.impl.query.mapper.AbstractQueryMapper;
import org.jbpm.services.api.query.QueryResultMapper;

public abstract class AbstractTaskAssigningQueryMapper<T>
extends AbstractQueryMapper<T>
implements QueryResultMapper<List<T>> {
    protected abstract T createInstance();

    protected abstract boolean readPotentialOwners();

    protected T buildInstance(DataSet dataSetResult, int index) {
        T row = this.createInstance();
        Long taskId = this.getColumnLongValue(dataSetResult, TASK_QUERY_COLUMN.TASK_ID.columnName(), index);
        Date createdOn = this.getColumnDateValue(dataSetResult, TASK_QUERY_COLUMN.CREATED_ON.columnName(), index);
        Long processInstanceId = this.getColumnLongValue(dataSetResult, TASK_QUERY_COLUMN.PROCESS_INSTANCE_ID.columnName(), index);
        String processId = this.getColumnStringValue(dataSetResult, TASK_QUERY_COLUMN.PROCESS_ID.columnName(), index);
        String deploymentId = this.getColumnStringValue(dataSetResult, TASK_QUERY_COLUMN.DEPLOYMENT_ID.columnName(), index);
        String status = this.getColumnStringValue(dataSetResult, TASK_QUERY_COLUMN.STATUS.columnName(), index);
        Integer priority = this.getColumnIntValue(dataSetResult, TASK_QUERY_COLUMN.PRIORITY.columnName(), index);
        String taskName = this.getColumnStringValue(dataSetResult, TASK_QUERY_COLUMN.TASK_NAME.columnName(), index);
        Date lastModificationDate = this.getColumnDateValue(dataSetResult, TASK_QUERY_COLUMN.LAST_MODIFICATION_DATE.columnName(), index);
        String actualOwner = (String)StringUtils.defaultIfEmpty((CharSequence)this.getColumnStringValue(dataSetResult, TASK_QUERY_COLUMN.ACTUAL_OWNER.columnName(), index), null);
        Long ptTaskId = this.getColumnLongValue(dataSetResult, TASK_QUERY_COLUMN.PLANNING_TASK_TASK_ID.columnName(), index);
        String assignedUser = null;
        Integer taskIndex = null;
        Integer published = null;
        if (ptTaskId != null) {
            assignedUser = (String)StringUtils.defaultIfEmpty((CharSequence)this.getColumnStringValue(dataSetResult, TASK_QUERY_COLUMN.PLANNING_TASK_ASSIGNED_USER.columnName(), index), null);
            taskIndex = this.getColumnIntValue(dataSetResult, TASK_QUERY_COLUMN.PLANNING_TASK_INDEX.columnName(), index);
            published = this.getColumnIntValue(dataSetResult, TASK_QUERY_COLUMN.PLANNING_TASK_PUBLISHED.columnName(), index);
        }
        this.setInstanceValues(row, taskId, createdOn, processInstanceId, processId, deploymentId, status, priority, taskName, lastModificationDate, actualOwner, assignedUser, taskIndex, published);
        return row;
    }

    protected abstract void setInstanceValues(T var1, Long var2, Date var3, Long var4, String var5, String var6, String var7, Integer var8, String var9, Date var10, String var11, String var12, Integer var13, Integer var14);

    public List<T> map(Object result) {
        DataSet dataSetResult = (DataSet)result;
        ArrayList<T> mappedResult = new ArrayList<T>();
        long previousTaskId = -1L;
        T taskRow = null;
        for (int i = 0; i < dataSetResult.getRowCount(); ++i) {
            String potentialOwnerId;
            long taskId = this.getColumnLongValue(dataSetResult, TASK_QUERY_COLUMN.TASK_ID.columnName(), i);
            if (previousTaskId != taskId) {
                previousTaskId = taskId;
                taskRow = this.buildInstance(dataSetResult, i);
                mappedResult.add(taskRow);
            }
            if (!this.readPotentialOwners() || !StringUtils.isNotEmpty((CharSequence)(potentialOwnerId = this.getColumnStringValue(dataSetResult, TASK_QUERY_COLUMN.POTENTIAL_OWNER_ID.columnName(), i)))) continue;
            String potentialOwnerType = this.getColumnStringValue(dataSetResult, TASK_QUERY_COLUMN.POTENTIAL_OWNER_TYPE.columnName(), i);
            this.addPotentialOwner(taskRow, potentialOwnerId, potentialOwnerType);
        }
        return mappedResult;
    }

    protected abstract void addPotentialOwner(T var1, String var2, String var3);

    protected static LocalDateTime toLocalDateTime(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return LocalDateTime.ofInstant(((Date)value).toInstant(), ZoneId.systemDefault());
        }
        if (value instanceof LocalDateTime) {
            return (LocalDateTime)value;
        }
        throw new DateTimeException(String.format("Unexpected type %s for toLocalDateTime conversion.", value.getClass()));
    }

    public static enum TASK_QUERY_COLUMN {
        TASK_ID("TASKID"),
        CREATED_ON("CREATEDON"),
        ACTUAL_OWNER("ACTUALOWNER"),
        DEPLOYMENT_ID("DEPLOYMENTID"),
        TASK_NAME("NAME"),
        PRIORITY("PRIORITY"),
        PROCESS_ID("PROCESSID"),
        PROCESS_INSTANCE_ID("PROCESSINSTANCEID"),
        STATUS("STATUS"),
        LAST_MODIFICATION_DATE("LASTMODIFICATIONDATE"),
        PLANNING_TASK_TASK_ID("PTTASKID"),
        PLANNING_TASK_ASSIGNED_USER("ASSIGNEDUSER"),
        PLANNING_TASK_INDEX("INDEX"),
        PLANNING_TASK_PUBLISHED("PUBLISHED"),
        POTENTIAL_OWNER_ID("POTENTIALOWNER"),
        POTENTIAL_OWNER_TYPE("POTENTIALOWNERTYPE");

        private String columnName;

        private TASK_QUERY_COLUMN(String columnName) {
            this.columnName = columnName;
        }

        public String columnName() {
            return this.columnName;
        }
    }
}

