/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.user.system.simple;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.kie.server.services.taskassigning.user.system.api.Group;
import org.kie.server.services.taskassigning.user.system.api.User;
import org.kie.server.services.taskassigning.user.system.simple.GroupImpl;
import org.kie.server.services.taskassigning.user.system.simple.UserImpl;

public class SimpleUserSystemServiceHelper {
    public static final String SKILLS_ATTRIBUTE_NAME = "skills";
    public static final String AFFINITIES_ATTRIBUTE_NAME = "affinities";

    private SimpleUserSystemServiceHelper() {
    }

    /*
     * Exception decompiling
     */
    public static UserGroupInfo buildInfo(Path users, Path skills, Path affinities) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static UserGroupInfo buildInfo(InputStream usersIn, InputStream skillsIn, InputStream affinitiesIn) throws IOException {
        HashMap<String, User> usersMap = new HashMap<String, User>();
        HashMap groupMap = new HashMap();
        List<ElementLine> lines = SimpleUserSystemServiceHelper.readLines(usersIn);
        List<ElementLine> skillLines = skillsIn != null ? SimpleUserSystemServiceHelper.readLines(skillsIn) : Collections.emptyList();
        List<ElementLine> affinityLines = affinitiesIn != null ? SimpleUserSystemServiceHelper.readLines(affinitiesIn) : Collections.emptyList();
        for (ElementLine line : lines) {
            HashSet<Group> userGroups = new HashSet<Group>();
            UserImpl user = new UserImpl(line.getElementId(), userGroups, new HashMap<String, Object>());
            line.values.forEach(groupName -> {
                Group group = groupMap.computeIfAbsent(groupName, GroupImpl::new);
                userGroups.add(group);
            });
            usersMap.put(user.getId(), user);
        }
        SimpleUserSystemServiceHelper.populateAttribute(usersMap, SKILLS_ATTRIBUTE_NAME, skillLines);
        SimpleUserSystemServiceHelper.populateAttribute(usersMap, AFFINITIES_ATTRIBUTE_NAME, affinityLines);
        return new UserGroupInfo(new ArrayList<User>(usersMap.values()), new ArrayList<Group>(groupMap.values()));
    }

    private static void populateAttribute(Map<String, User> usersMap, String attributeName, List<ElementLine> attributeLines) {
        for (ElementLine attributeLine : attributeLines) {
            String value;
            User user = usersMap.get(attributeLine.getElementId());
            if (user == null || (value = String.join((CharSequence)",", attributeLine.getValues())).length() <= 1) continue;
            user.getAttributes().put(attributeName, value);
        }
    }

    private static List<ElementLine> readLines(InputStream input) throws IOException {
        Properties properties = new Properties();
        properties.load(new InputStreamReader(input, StandardCharsets.UTF_8));
        return properties.entrySet().stream().map(entry -> Pair.of((Object)StringUtils.trim((String)entry.getKey().toString()), (Object)StringUtils.trim((String)entry.getValue().toString()))).filter(pair -> StringUtils.isNotEmpty((CharSequence)((CharSequence)pair.getKey()))).map(pair -> new ElementLine((String)pair.getKey(), SimpleUserSystemServiceHelper.readLine((String)pair.getValue()))).collect(Collectors.toList());
    }

    private static List<String> readLine(String encodedValues) {
        ArrayList<String> values = new ArrayList<String>();
        if (encodedValues != null) {
            String[] valuesSplit;
            for (String rawValue : valuesSplit = encodedValues.split(",")) {
                String value = rawValue.trim();
                if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
                values.add(value);
            }
        }
        return values;
    }

    private static class ElementLine {
        private String elementId;
        private List<String> values;

        public ElementLine(String elementId, List<String> values) {
            this.elementId = elementId;
            this.values = values;
        }

        public String getElementId() {
            return this.elementId;
        }

        public List<String> getValues() {
            return this.values;
        }
    }

    public static class UserGroupInfo {
        private List<User> users;
        private List<Group> groups;

        UserGroupInfo(List<User> users, List<Group> groups) {
            this.users = users;
            this.groups = groups;
        }

        public List<User> getUsers() {
            return this.users;
        }

        public List<Group> getGroups() {
            return this.groups;
        }
    }
}

