/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jbpm.document.Document;
import org.jbpm.document.service.DocumentStorageService;
import org.jbpm.document.service.DocumentStorageServiceProvider;
import org.kie.server.api.model.instance.DocumentInstance;
import org.kie.server.api.model.instance.DocumentInstanceList;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.api.KieServerRuntimeException;
import org.kie.server.services.impl.marshal.MarshallerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentServiceBase {
    private static final Logger logger = LoggerFactory.getLogger(DocumentServiceBase.class);
    private DocumentStorageService documentStorageService = DocumentStorageServiceProvider.get().getStorageService();
    private MarshallerHelper marshallerHelper;

    public DocumentServiceBase(KieServerRegistry context) {
        this.marshallerHelper = new MarshallerHelper(context);
    }

    public DocumentServiceBase(DocumentStorageService documentStorageService, KieServerRegistry context) {
        this.documentStorageService = documentStorageService;
        this.marshallerHelper = new MarshallerHelper(context);
    }

    public DocumentInstance getDocument(String documentId) {
        logger.debug("About to load document with id {}", (Object)documentId);
        Document document = this.documentStorageService.getDocument(documentId);
        logger.debug("Document loaded from repository {}", (Object)document);
        if (document == null) {
            throw new KieServerRuntimeException("No document found with id " + documentId);
        }
        return this.convertDocument(document, true);
    }

    public String storeDocument(String documentPayload, String marshallingType) {
        logger.debug("About to unmarshal document payload '{}' with marshaling type {}", (Object)documentPayload, (Object)marshallingType);
        DocumentInstance documentInstance = (DocumentInstance)this.marshallerHelper.unmarshal(documentPayload, marshallingType, DocumentInstance.class);
        logger.debug("Document created from payload {}", (Object)documentInstance);
        Document document = this.documentStorageService.buildDocument(documentInstance.getName(), documentInstance.getSize(), documentInstance.getLastModified(), new HashMap());
        logger.debug("Document created by the service {}", (Object)document);
        this.documentStorageService.saveDocument(document, documentInstance.getContent());
        logger.debug("Document {} stored successfully", (Object)document);
        return document.getIdentifier();
    }

    public void updateDocument(String documentId, String documentPayload, String marshallingType) {
        logger.debug("About to unmarshal document payload '{}' with marshaling type {}", (Object)documentPayload, (Object)marshallingType);
        DocumentInstance documentInstance = (DocumentInstance)this.marshallerHelper.unmarshal(documentPayload, marshallingType, DocumentInstance.class);
        logger.debug("Document created from payload {}", (Object)documentInstance);
        Document document = this.documentStorageService.getDocument(documentId);
        logger.debug("Document found {}", (Object)(documentInstance != null ? 1 : 0));
        if (document == null) {
            throw new KieServerRuntimeException("No document found with id " + documentId);
        }
        this.documentStorageService.saveDocument(document, documentInstance.getContent());
        logger.debug("Document {} updated successfully", (Object)document);
    }

    public void deleteDocument(String documentId) {
        logger.debug("About to delete document with id {}", (Object)documentId);
        Document document = this.documentStorageService.getDocument(documentId);
        logger.debug("Document found {}", (Object)(document != null ? 1 : 0));
        if (document == null) {
            throw new KieServerRuntimeException("No document found with id " + documentId);
        }
        this.documentStorageService.deleteDocument(document);
        logger.debug("Document {} deleted successfully", (Object)document);
    }

    public DocumentInstanceList listDocuments(Integer page, Integer pageSize) {
        logger.debug("About to list documents with page {} and pageSize {}", (Object)page, (Object)pageSize);
        List documents = this.documentStorageService.listDocuments(page, pageSize);
        logger.debug("Documents loaded from repository {}", (Object)documents);
        DocumentInstanceList result = new DocumentInstanceList(Collections.emptyList());
        if (documents == null) {
            return result;
        }
        List<DocumentInstance> list = this.convertDocumentList(documents);
        result.setDocumentInstances(list.toArray(new DocumentInstance[list.size()]));
        return result;
    }

    protected List<DocumentInstance> convertDocumentList(List<Document> documents) {
        ArrayList<DocumentInstance> list = new ArrayList<DocumentInstance>();
        for (Document doc : documents) {
            list.add(this.convertDocument(doc, false));
        }
        return list;
    }

    protected DocumentInstance convertDocument(Document document, boolean withContent) {
        if (document == null) {
            return null;
        }
        DocumentInstance.Builder documentBuilder = DocumentInstance.builder();
        documentBuilder.id(document.getIdentifier()).name(document.getName()).link(document.getLink()).size(document.getSize()).lastModified(document.getLastModified());
        if (withContent) {
            documentBuilder.content(document.getContent());
        }
        DocumentInstance documentInstance = documentBuilder.build();
        return documentInstance;
    }
}

