/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.locator;

import java.util.List;
import javax.persistence.EntityManager;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.kie.server.services.api.ContainerLocator;
import org.kie.server.services.api.KieContainerInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByProcessInstanceIdContainerLocator
implements ContainerLocator {
    private static final Logger logger = LoggerFactory.getLogger(ByProcessInstanceIdContainerLocator.class);
    private static final String CONTAINER_ID_QUERY = "select log.externalId from ProcessInstanceLog log where log.processInstanceId = :piId";
    private Long processInstanceId;
    private String containerId;

    public ByProcessInstanceIdContainerLocator(Long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String locateContainer(String alias, List<? extends KieContainerInstance> containerInstances) {
        if (this.containerId != null) {
            logger.debug("Container id has already be found for process instance {} and is {}", (Object)this.processInstanceId, (Object)this.containerId);
            return this.containerId;
        }
        logger.debug("Searching for container id for process instance id {} and alias {}", (Object)this.processInstanceId, (Object)alias);
        try (EntityManager em = EntityManagerFactoryManager.get().getOrCreate("org.jbpm.domain").createEntityManager();){
            this.containerId = (String)em.createQuery(CONTAINER_ID_QUERY).setParameter("piId", (Object)this.processInstanceId).getSingleResult();
            logger.debug("Found container id '{}' for process instance id {}", (Object)this.containerId, (Object)this.processInstanceId);
            String string = this.containerId;
            return string;
        }
    }
}

