/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.audit;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.VariableInstanceLog;
import org.jbpm.process.audit.event.AuditEvent;
import org.jbpm.process.audit.event.DefaultAuditEventBuilderImpl;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.internal.identity.IdentityProvider;

public class ServicesAwareAuditEventBuilder
extends DefaultAuditEventBuilderImpl {
    private IdentityProvider identityProvider;
    private String deploymentUnitId;
    private final Boolean allowSetInitiator = Boolean.parseBoolean(System.getProperty("org.kie.server.bypass.auth.user", "false"));

    public IdentityProvider getIdentityProvider() {
        return this.identityProvider;
    }

    public void setIdentityProvider(IdentityProvider identityProvider) {
        this.identityProvider = identityProvider;
    }

    public AuditEvent buildEvent(ProcessStartedEvent pse) {
        ProcessInstanceLog log = (ProcessInstanceLog)super.buildEvent(pse);
        log.setIdentity(this.getIdentity(pse));
        log.setExternalId(this.deploymentUnitId);
        return log;
    }

    public AuditEvent buildEvent(ProcessCompletedEvent pce, Object log) {
        ProcessInstanceLog instanceLog = (ProcessInstanceLog)super.buildEvent(pce, log);
        instanceLog.setExternalId(this.deploymentUnitId);
        return instanceLog;
    }

    public AuditEvent buildEvent(ProcessNodeTriggeredEvent pnte) {
        NodeInstanceLog nodeInstanceLog = (NodeInstanceLog)super.buildEvent(pnte);
        nodeInstanceLog.setExternalId(this.deploymentUnitId);
        return nodeInstanceLog;
    }

    public AuditEvent buildEvent(ProcessNodeLeftEvent pnle, Object log) {
        NodeInstanceLog nodeInstanceLog = (NodeInstanceLog)super.buildEvent(pnle, log);
        nodeInstanceLog.setExternalId(this.deploymentUnitId);
        return nodeInstanceLog;
    }

    public AuditEvent buildEvent(ProcessVariableChangedEvent pvce) {
        VariableInstanceLog variableLog = (VariableInstanceLog)super.buildEvent(pvce);
        variableLog.setExternalId(this.deploymentUnitId);
        return variableLog;
    }

    public String getDeploymentUnitId() {
        return this.deploymentUnitId;
    }

    public void setDeploymentUnitId(String deploymentUnitId) {
        this.deploymentUnitId = deploymentUnitId;
    }

    private String getIdentity(ProcessStartedEvent pse) {
        String identity = this.identityProvider.getName();
        if (this.allowSetInitiator.booleanValue()) {
            ProcessInstance pi = (ProcessInstance)pse.getProcessInstance();
            VariableScopeInstance variableScope = (VariableScopeInstance)pi.getContextInstance("VariableScope");
            Map processVariables = variableScope.getVariables();
            String initiator = (String)processVariables.get("initiator");
            identity = !StringUtils.isEmpty((CharSequence)initiator) ? initiator : identity;
        }
        return identity;
    }
}

