/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.casemgmt.locator;

import java.util.List;
import javax.persistence.EntityManager;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.kie.server.services.api.ContainerLocator;
import org.kie.server.services.api.KieContainerInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByCaseIdContainerLocator
implements ContainerLocator {
    private static final Logger logger = LoggerFactory.getLogger(ByCaseIdContainerLocator.class);
    private static final String CONTAINER_ID_QUERY = "select distinct log.externalId from ProcessInstanceLog log where log.correlationKey = :caseId";
    private String caseId;
    private String containerId;

    public ByCaseIdContainerLocator(String caseId) {
        this.caseId = caseId;
    }

    public String locateContainer(String alias, List<? extends KieContainerInstance> containerInstances) {
        if (this.containerId != null) {
            logger.debug("Container id has already been found for case {} and is {}", (Object)this.caseId, (Object)this.containerId);
            return this.containerId;
        }
        logger.debug("Searching for container id for case id {} and alias {}", (Object)this.caseId, (Object)alias);
        try (EntityManager em = EntityManagerFactoryManager.get().getOrCreate("org.jbpm.domain").createEntityManager();){
            this.containerId = (String)em.createQuery(CONTAINER_ID_QUERY).setParameter("caseId", (Object)this.caseId).getSingleResult();
            logger.debug("Found container id '{}' for case id {}", (Object)this.containerId, (Object)this.caseId);
            String string = this.containerId;
            return string;
        }
    }
}

