/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.dmn;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.kie.server.api.model.Message;
import org.kie.server.api.model.Severity;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieServerApplicationComponentsService;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.api.SupportedTransports;
import org.kie.server.services.dmn.DMNKieContainerCommandServiceImpl;
import org.kie.server.services.dmn.ModelEvaluatorServiceBase;
import org.kie.server.services.impl.KieServerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNKieServerExtension
implements KieServerExtension {
    private static final Logger LOG = LoggerFactory.getLogger(DMNKieServerExtension.class);
    public static final String EXTENSION_NAME = "DMN";
    private static final Boolean droolsDisabled = Boolean.parseBoolean(System.getProperty("org.drools.server.ext.disabled", "false"));
    private static final Boolean disabled = Boolean.parseBoolean(System.getProperty("org.kie.dmn.server.ext.disabled", "false"));
    private KieServerRegistry registry;
    private List<Object> services = new ArrayList<Object>();
    private boolean initialized = false;
    private ModelEvaluatorServiceBase modelEvaluatorServiceBase;
    private DMNKieContainerCommandServiceImpl commandService;

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isActive() {
        return disabled == false && droolsDisabled == false;
    }

    public void init(KieServerImpl kieServer, KieServerRegistry registry) {
        this.registry = registry;
        this.modelEvaluatorServiceBase = new ModelEvaluatorServiceBase(registry);
        this.commandService = new DMNKieContainerCommandServiceImpl(registry, this.modelEvaluatorServiceBase);
        this.initialized = true;
    }

    public void destroy(KieServerImpl kieServer, KieServerRegistry registry) {
        if (!this.initialized) {
            return;
        }
    }

    public void createContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        if (!this.initialized) {
            return;
        }
    }

    public void updateContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        if (!this.initialized) {
            return;
        }
    }

    public boolean isUpdateContainerAllowed(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        return true;
    }

    public void disposeContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        if (!this.initialized) {
            return;
        }
    }

    public List<Object> getAppComponents(SupportedTransports type) {
        ServiceLoader<KieServerApplicationComponentsService> appComponentsServices = ServiceLoader.load(KieServerApplicationComponentsService.class);
        ArrayList<Object> appComponentsList = new ArrayList<Object>();
        Object[] services = new Object[]{this.modelEvaluatorServiceBase, this.registry};
        for (KieServerApplicationComponentsService appComponentsService : appComponentsServices) {
            appComponentsList.addAll(appComponentsService.getAppComponents(EXTENSION_NAME, type, services));
        }
        return appComponentsList;
    }

    public <T> T getAppComponents(Class<T> serviceType) {
        if (serviceType.isAssignableFrom(this.modelEvaluatorServiceBase.getClass())) {
            return (T)this.modelEvaluatorServiceBase;
        }
        if (serviceType.isAssignableFrom(this.commandService.getClass())) {
            return (T)this.commandService;
        }
        return null;
    }

    public String getImplementedCapability() {
        return EXTENSION_NAME;
    }

    public List<Object> getServices() {
        return this.services;
    }

    public String getExtensionName() {
        return EXTENSION_NAME;
    }

    public Integer getStartOrder() {
        return 47;
    }

    public String toString() {
        return "DMN KIE Server extension";
    }

    public List<Message> healthCheck(boolean report) {
        List messages = super.healthCheck(report);
        if (report) {
            messages.add(new Message(Severity.INFO, this.getExtensionName() + " is alive"));
        }
        return messages;
    }
}

