/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.wih;

import java.util.Collection;
import java.util.stream.Collectors;
import org.drools.core.ClassObjectFilter;
import org.jbpm.casemgmt.api.CaseService;
import org.jbpm.casemgmt.api.dynamic.TaskSpecification;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.services.api.service.ServiceRegistry;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.SLAViolatedEvent;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.process.CaseAssignment;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.User;
import org.kie.internal.runtime.Cacheable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EscalateToAdminSLAViolationListener
extends DefaultProcessEventListener
implements Cacheable {
    private static final Logger logger = LoggerFactory.getLogger(EscalateToAdminSLAViolationListener.class);

    public void afterSLAViolated(SLAViolatedEvent event) {
        CaseFileInstance caseFile = this.getCaseFile((KieSession)event.getKieRuntime());
        if (caseFile != null) {
            String caseId = ((WorkflowProcessInstanceImpl)event.getProcessInstance()).getCorrelationKey();
            if (caseFile.getCaseId().equals(caseId)) {
                try {
                    Collection adminAssignments = ((CaseAssignment)caseFile).getAssignments("admin");
                    String users = adminAssignments.stream().filter(oe -> oe instanceof User).map(oe -> oe.getId()).collect(Collectors.joining(","));
                    String groups = adminAssignments.stream().filter(oe -> oe instanceof Group).map(oe -> oe.getId()).collect(Collectors.joining(","));
                    String taskName = "SLA violation for case " + caseId;
                    String taskDescription = "Service Level Agreement has been violated for case " + caseId;
                    if (event.getNodeInstance() != null) {
                        taskName = taskName + "Task (" + event.getNodeInstance().getNodeName() + ") SLA violation for case " + caseId;
                        taskDescription = taskDescription + " on task " + event.getNodeInstance().getNodeName();
                    }
                    logger.debug("Case instance {} has SLA violation, escalating to administrator", (Object)caseId);
                    CaseService caseService = (CaseService)ServiceRegistry.get().service("CaseService");
                    TaskSpecification taskSpec = caseService.newHumanTaskSpec(taskName, taskDescription, users, groups, null);
                    caseService.addDynamicTask(caseId, taskSpec);
                }
                catch (IllegalArgumentException e) {
                    logger.debug("There is no admin role defined in case instance {}, unable to escalate SLA violation", (Object)caseId);
                }
            }
        }
    }

    protected CaseFileInstance getCaseFile(KieSession ksession) {
        Collection caseFiles = ksession.getObjects((ObjectFilter)new ClassObjectFilter(CaseFileInstance.class));
        if (caseFiles.size() == 0) {
            return null;
        }
        CaseFileInstance caseFile = (CaseFileInstance)caseFiles.iterator().next();
        return caseFile;
    }

    public void close() {
    }
}

