/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.core.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.kie.server.services.taskassigning.core.model.OrganizationalEntity;
import org.kie.server.services.taskassigning.core.model.TaskOrUser;
import org.kie.server.services.taskassigning.core.model.User;
import org.kie.server.services.taskassigning.core.model.solver.StartAndEndTimeUpdatingVariableListener;
import org.kie.server.services.taskassigning.core.model.solver.TaskDifficultyComparator;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.entity.PlanningPin;
import org.optaplanner.core.api.domain.variable.AnchorShadowVariable;
import org.optaplanner.core.api.domain.variable.CustomShadowVariable;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.core.api.domain.variable.PlanningVariableGraphType;
import org.optaplanner.core.api.domain.variable.PlanningVariableReference;

@PlanningEntity(difficultyComparatorClass=TaskDifficultyComparator.class)
@XStreamAlias(value="TaTask")
public class Task
extends TaskOrUser {
    public static final String PREVIOUS_TASK_OR_USER = "previousTaskOrUser";
    public static final String USER_RANGE = "userRange";
    public static final String TASK_RANGE = "taskRange";
    public static final String START_TIME_IN_MINUTES = "startTimeInMinutes";
    public static final String END_TIME_IN_MINUTES = "endTimeInMinutes";
    private long processInstanceId;
    private String processId;
    private String containerId;
    private String name;
    private int priority;
    private String status;
    private Map<String, Object> inputData;
    @PlanningPin
    private boolean pinned;
    private Set<OrganizationalEntity> potentialOwners = new HashSet<OrganizationalEntity>();
    private Map<String, Set<Object>> labelValues = new HashMap<String, Set<Object>>();
    @PlanningVariable(valueRangeProviderRefs={"userRange", "taskRange"}, graphType=PlanningVariableGraphType.CHAINED)
    private TaskOrUser previousTaskOrUser;
    @AnchorShadowVariable(sourceVariableName="previousTaskOrUser")
    private User user;
    @CustomShadowVariable(variableListenerClass=StartAndEndTimeUpdatingVariableListener.class, sources={@PlanningVariableReference(variableName="previousTaskOrUser")})
    private Integer startTimeInMinutes;
    private int durationInMinutes = 1;
    @CustomShadowVariable(variableListenerRef=@PlanningVariableReference(variableName="startTimeInMinutes"))
    private Integer endTimeInMinutes;

    public Task() {
    }

    public Task(long id, String name, int priority) {
        super(id);
        this.name = name;
        this.priority = priority;
        this.pinned = false;
    }

    public Task(long id, long processInstanceId, String processId, String containerId, String name, int priority, String status, Map<String, Object> inputData) {
        super(id);
        this.processInstanceId = processInstanceId;
        this.processId = processId;
        this.containerId = containerId;
        this.name = name;
        this.priority = priority;
        this.status = status;
        this.inputData = inputData;
    }

    protected Task(long id, long processInstanceId, String processId, String containerId, String name, int priority, Map<String, Object> inputData, boolean pinned, Set<OrganizationalEntity> potentialOwners, Map<String, Set<Object>> labelValues) {
        super(id);
        this.processInstanceId = processInstanceId;
        this.processId = processId;
        this.containerId = containerId;
        this.name = name;
        this.priority = priority;
        this.inputData = inputData;
        this.pinned = pinned;
        this.potentialOwners = potentialOwners;
        this.labelValues = labelValues;
    }

    public long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Map<String, Object> getInputData() {
        return this.inputData;
    }

    public void setInputData(Map<String, Object> inputData) {
        this.inputData = inputData;
    }

    public boolean isPinned() {
        return this.pinned;
    }

    public void setPinned(boolean pinned) {
        this.pinned = pinned;
    }

    public Set<OrganizationalEntity> getPotentialOwners() {
        return this.potentialOwners;
    }

    public void setPotentialOwners(Set<OrganizationalEntity> potentialOwners) {
        this.potentialOwners = potentialOwners;
    }

    public Map<String, Set<Object>> getLabelValues() {
        return this.labelValues;
    }

    public Set<Object> getLabelValues(String labelName) {
        return this.labelValues.get(labelName);
    }

    public void setLabelValues(String labelName, Set<Object> values) {
        this.labelValues.put(labelName, values);
    }

    public TaskOrUser getPreviousTaskOrUser() {
        return this.previousTaskOrUser;
    }

    public void setPreviousTaskOrUser(TaskOrUser previousTaskOrUser) {
        this.previousTaskOrUser = previousTaskOrUser;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Integer getStartTimeInMinutes() {
        return this.startTimeInMinutes;
    }

    public void setStartTimeInMinutes(Integer startTimeInMinutes) {
        this.startTimeInMinutes = startTimeInMinutes;
    }

    @Override
    public Integer getEndTimeInMinutes() {
        return this.endTimeInMinutes;
    }

    public void setEndTime(Integer endTimeInMinutes) {
        this.endTimeInMinutes = endTimeInMinutes;
    }

    public int getDurationInMinutes() {
        return this.durationInMinutes;
    }

    public void setDurationInMinutes(int durationInMinutes) {
        this.durationInMinutes = durationInMinutes;
    }

    @Override
    public String toString() {
        return "Task{id=" + this.id + ", name='" + this.name + '\'' + ", priority=" + this.priority + ", status ='" + this.status + '\'' + ", pinned=" + this.pinned + ", potentialOwners=" + this.potentialOwners + ", labelValues=" + this.labelValues + ", previousTaskOrUser=" + this.previousTaskOrUser + ", user=" + this.user + ", startTimeInMinutes=" + this.startTimeInMinutes + ", durationInMinutes=" + this.durationInMinutes + ", endTimeInMinutes=" + this.endTimeInMinutes + '}';
    }
}

