/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.core.model.solver;

public class PriorityHelper {
    private PriorityHelper() {
    }

    public static boolean isHighLevel(int priority) {
        return priority == 0 || priority == 1 || priority == 2;
    }

    public static boolean isMediumLevel(int priority) {
        return priority == 3 || priority == 4 || priority == 5 || priority == 6;
    }

    public static boolean isLowLevel(int priority) {
        return priority == 7 || priority == 8 || priority == 9 || priority == 10;
    }

    public static int calculateWeightedPenalty(int priority, int endTime) {
        PriorityHelper.assertValue(priority);
        return -(11 - priority) * endTime;
    }

    private static void assertValue(int priority) {
        if (priority < 0 || priority > 10) {
            throw new IllegalArgumentException(String.format("Task priority %s is out of range. A valid priority value must be between 0 (inclusive)  and 10 (inclusive)", priority));
        }
    }
}

