/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.core.model.solver.realtime;

import org.kie.server.services.taskassigning.core.model.Task;
import org.kie.server.services.taskassigning.core.model.TaskAssigningSolution;
import org.kie.server.services.taskassigning.core.model.TaskOrUser;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.solver.ProblemFactChange;

public class ReleaseTaskProblemFactChange
implements ProblemFactChange<TaskAssigningSolution> {
    private Task task;

    public ReleaseTaskProblemFactChange(Task task) {
        this.task = task;
    }

    public Task getTask() {
        return this.task;
    }

    public void doChange(ScoreDirector<TaskAssigningSolution> scoreDirector) {
        Task workingTask = (Task)scoreDirector.lookUpWorkingObjectOrReturnNull((Object)this.task);
        if (workingTask == null || workingTask.getPreviousTaskOrUser() == null) {
            return;
        }
        TaskOrUser previousTaskOrUser = workingTask.getPreviousTaskOrUser();
        Task nextTask = workingTask.getNextTask();
        if (nextTask != null) {
            scoreDirector.beforeVariableChanged((Object)nextTask, "previousTaskOrUser");
            nextTask.setPreviousTaskOrUser(previousTaskOrUser);
            scoreDirector.afterVariableChanged((Object)nextTask, "previousTaskOrUser");
        }
        scoreDirector.beforeVariableChanged((Object)workingTask, "previousTaskOrUser");
        workingTask.setPreviousTaskOrUser(null);
        scoreDirector.afterVariableChanged((Object)workingTask, "previousTaskOrUser");
        if (workingTask.isPinned()) {
            scoreDirector.beforeProblemPropertyChanged((Object)workingTask);
            workingTask.setPinned(false);
            scoreDirector.afterProblemPropertyChanged((Object)workingTask);
        }
        scoreDirector.triggerVariableListeners();
    }
}

