/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;

abstract class CollapsingDocValuesSource<T> {
    protected final String field;

    CollapsingDocValuesSource(String field) throws IOException {
        this.field = field;
    }

    abstract T get(int var1);

    abstract T copy(T var1, T var2);

    abstract void setNextReader(LeafReader var1) throws IOException;

    private static DocValuesType getDocValuesType(LeafReader in, String field) {
        FieldInfo fi = in.getFieldInfos().fieldInfo(field);
        if (fi != null) {
            return fi.getDocValuesType();
        }
        return null;
    }

    static class Keyword
    extends CollapsingDocValuesSource<BytesRef> {
        private Bits docsWithField;
        private SortedDocValues values;

        Keyword(String field) throws IOException {
            super(field);
        }

        @Override
        public BytesRef get(int doc) {
            if (this.docsWithField.get(doc)) {
                return this.values.get(doc);
            }
            return null;
        }

        @Override
        public BytesRef copy(BytesRef value, BytesRef reuse) {
            if (value == null) {
                return null;
            }
            if (reuse != null) {
                reuse.bytes = ArrayUtil.grow((byte[])reuse.bytes, (int)value.length);
                reuse.offset = 0;
                reuse.length = value.length;
                System.arraycopy(value.bytes, value.offset, reuse.bytes, 0, value.length);
                return reuse;
            }
            return BytesRef.deepCopyOf((BytesRef)value);
        }

        @Override
        public void setNextReader(LeafReader reader) throws IOException {
            DocValuesType type = CollapsingDocValuesSource.getDocValuesType(reader, this.field);
            if (type == null || type == DocValuesType.NONE) {
                this.values = DocValues.emptySorted();
                this.docsWithField = new Bits.MatchNoBits(reader.maxDoc());
                return;
            }
            this.docsWithField = DocValues.getDocsWithField((LeafReader)reader, (String)this.field);
            switch (type) {
                case SORTED: {
                    this.values = DocValues.getSorted((LeafReader)reader, (String)this.field);
                    break;
                }
                case SORTED_SET: {
                    final SortedSetDocValues sorted = DocValues.getSortedSet((LeafReader)reader, (String)this.field);
                    this.values = DocValues.unwrapSingleton((SortedSetDocValues)sorted);
                    if (this.values != null) break;
                    this.values = new SortedDocValues(){

                        public int getOrd(int docID) {
                            sorted.setDocument(docID);
                            int ord = (int)sorted.nextOrd();
                            if (sorted.nextOrd() != -1L) {
                                throw new IllegalStateException("failed to collapse " + docID + ", the collapse field must be single valued");
                            }
                            return ord;
                        }

                        public BytesRef lookupOrd(int ord) {
                            return sorted.lookupOrd((long)ord);
                        }

                        public int getValueCount() {
                            return (int)sorted.getValueCount();
                        }
                    };
                    break;
                }
                default: {
                    throw new IllegalStateException("unexpected doc values type " + type + "` for field `" + this.field + "`");
                }
            }
        }
    }

    static class Numeric
    extends CollapsingDocValuesSource<Long> {
        private NumericDocValues values;
        private Bits docsWithField;

        Numeric(String field) throws IOException {
            super(field);
        }

        @Override
        public Long get(int doc) {
            if (this.docsWithField.get(doc)) {
                return this.values.get(doc);
            }
            return null;
        }

        @Override
        public Long copy(Long value, Long reuse) {
            return value;
        }

        @Override
        public void setNextReader(LeafReader reader) throws IOException {
            DocValuesType type = CollapsingDocValuesSource.getDocValuesType(reader, this.field);
            if (type == null || type == DocValuesType.NONE) {
                this.values = DocValues.emptyNumeric();
                this.docsWithField = new Bits.MatchNoBits(reader.maxDoc());
                return;
            }
            this.docsWithField = DocValues.getDocsWithField((LeafReader)reader, (String)this.field);
            switch (type) {
                case NUMERIC: {
                    this.values = DocValues.getNumeric((LeafReader)reader, (String)this.field);
                    break;
                }
                case SORTED_NUMERIC: {
                    final SortedNumericDocValues sorted = DocValues.getSortedNumeric((LeafReader)reader, (String)this.field);
                    this.values = DocValues.unwrapSingleton((SortedNumericDocValues)sorted);
                    if (this.values != null) break;
                    this.values = new NumericDocValues(){

                        public long get(int docID) {
                            sorted.setDocument(docID);
                            assert (sorted.count() > 0);
                            if (sorted.count() > 1) {
                                throw new IllegalStateException("failed to collapse " + docID + ", the collapse field must be single valued");
                            }
                            return sorted.valueAt(0);
                        }
                    };
                    break;
                }
                default: {
                    throw new IllegalStateException("unexpected doc values type " + type + "` for field `" + this.field + "`");
                }
            }
        }
    }
}

