/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.index;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.CompositeIndicesRequest;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.RoutingMissingException;
import org.elasticsearch.action.TimestampParsingException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.replication.ReplicatedWriteRequest;
import org.elasticsearch.client.Requests;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.mapper.TimestampFieldMapper;

public class IndexRequest
extends ReplicatedWriteRequest<IndexRequest>
implements DocWriteRequest<IndexRequest>,
CompositeIndicesRequest {
    static final int MAX_SOURCE_LENGTH_IN_TOSTRING = 2048;
    private String type;
    private String id;
    @Nullable
    private String routing;
    @Nullable
    private String parent;
    @Nullable
    private String timestamp;
    @Nullable
    private TimeValue ttl;
    private BytesReference source;
    private DocWriteRequest.OpType opType = DocWriteRequest.OpType.INDEX;
    private long version = -3L;
    private VersionType versionType = VersionType.INTERNAL;
    private XContentType contentType;
    private String pipeline;
    public static final int UNSET_AUTO_GENERATED_TIMESTAMP = -1;
    private long autoGeneratedTimestamp = -1L;
    private boolean isRetry = false;
    private static DeprecationLogger deprecationLogger = new DeprecationLogger(Loggers.getLogger(IndexRequest.class));

    public IndexRequest() {
    }

    public IndexRequest(String index) {
        this.index = index;
    }

    public IndexRequest(String index, String type) {
        this.index = index;
        this.type = type;
    }

    public IndexRequest(String index, String type, String id) {
        this.index = index;
        this.type = type;
        this.id = id;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.type == null) {
            validationException = ValidateActions.addValidationError("type is missing", validationException);
        }
        if (this.source == null) {
            validationException = ValidateActions.addValidationError("source is missing", validationException);
        }
        if (this.contentType == null) {
            validationException = ValidateActions.addValidationError("content type is missing", validationException);
        }
        long resolvedVersion = this.resolveVersionDefaults();
        if (this.opType() == DocWriteRequest.OpType.CREATE) {
            if (this.versionType != VersionType.INTERNAL) {
                validationException = ValidateActions.addValidationError("create operations only support internal versioning. use index instead", validationException);
                return validationException;
            }
            if (resolvedVersion != -4L) {
                validationException = ValidateActions.addValidationError("create operations do not support explicit versions. use index instead", validationException);
                return validationException;
            }
        }
        if (this.opType() != DocWriteRequest.OpType.INDEX && this.id == null) {
            ValidateActions.addValidationError("an id is required for a " + (Object)((Object)this.opType()) + " operation", validationException);
        }
        if (!this.versionType.validateVersionForWrites(resolvedVersion)) {
            validationException = ValidateActions.addValidationError("illegal version value [" + resolvedVersion + "] for version type [" + this.versionType.name() + "]", validationException);
        }
        if (this.ttl != null && this.ttl.millis() < 0L) {
            validationException = ValidateActions.addValidationError("ttl must not be negative", validationException);
        }
        if (this.id != null && this.id.getBytes(StandardCharsets.UTF_8).length > 512) {
            validationException = ValidateActions.addValidationError("id is too long, must be no longer than 512 bytes but was: " + this.id.getBytes(StandardCharsets.UTF_8).length, validationException);
        }
        if (this.id == null && !(this.versionType == VersionType.INTERNAL && resolvedVersion == -3L)) {
            validationException = ValidateActions.addValidationError("an id must be provided if version type or value are set", validationException);
        }
        if (this.versionType == VersionType.FORCE) {
            deprecationLogger.deprecated("version type FORCE is deprecated and will be removed in the next major version", new Object[0]);
        }
        return validationException;
    }

    public XContentType getContentType() {
        return this.contentType;
    }

    @Override
    public String type() {
        return this.type;
    }

    public IndexRequest type(String type) {
        this.type = type;
        return this;
    }

    @Override
    public String id() {
        return this.id;
    }

    public IndexRequest id(String id) {
        this.id = id;
        return this;
    }

    @Override
    public IndexRequest routing(String routing) {
        this.routing = routing != null && routing.length() == 0 ? null : routing;
        return this;
    }

    @Override
    public String routing() {
        return this.routing;
    }

    public IndexRequest parent(String parent) {
        this.parent = parent;
        return this;
    }

    @Override
    public String parent() {
        return this.parent;
    }

    @Deprecated
    public IndexRequest timestamp(String timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Deprecated
    public String timestamp() {
        return this.timestamp;
    }

    @Deprecated
    public IndexRequest ttl(String ttl) {
        this.ttl = TimeValue.parseTimeValue(ttl, null, "ttl");
        return this;
    }

    @Deprecated
    public IndexRequest ttl(TimeValue ttl) {
        this.ttl = ttl;
        return this;
    }

    @Deprecated
    public IndexRequest ttl(long ttl) {
        this.ttl = new TimeValue(ttl);
        return this;
    }

    @Deprecated
    public TimeValue ttl() {
        return this.ttl;
    }

    public IndexRequest setPipeline(String pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public String getPipeline() {
        return this.pipeline;
    }

    public BytesReference source() {
        return this.source;
    }

    public Map<String, Object> sourceAsMap() {
        return XContentHelper.convertToMap(this.source, false, this.contentType).v2();
    }

    public IndexRequest source(Map source) throws ElasticsearchGenerationException {
        return this.source(source, Requests.INDEX_CONTENT_TYPE);
    }

    public IndexRequest source(Map source, XContentType contentType) throws ElasticsearchGenerationException {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(contentType);
            builder.map(source);
            return this.source(builder);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + source + "]", e);
        }
    }

    @Deprecated
    public IndexRequest source(String source) {
        return this.source(new BytesArray(source), XContentFactory.xContentType(source));
    }

    public IndexRequest source(String source, XContentType xContentType) {
        return this.source(new BytesArray(source), xContentType);
    }

    public IndexRequest source(XContentBuilder sourceBuilder) {
        return this.source(sourceBuilder.bytes(), sourceBuilder.contentType());
    }

    public IndexRequest source(Object ... source) {
        return this.source(Requests.INDEX_CONTENT_TYPE, source);
    }

    public IndexRequest source(XContentType xContentType, Object ... source) {
        if (source.length % 2 != 0) {
            throw new IllegalArgumentException("The number of object passed must be even but was [" + source.length + "]");
        }
        if (source.length == 2 && source[0] instanceof BytesReference && source[1] instanceof Boolean) {
            throw new IllegalArgumentException("you are using the removed method for source with bytes and unsafe flag, the unsafe flag was removed, please just use source(BytesReference)");
        }
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(xContentType);
            builder.startObject();
            for (int i = 0; i < source.length; ++i) {
                builder.field(source[i++].toString(), source[i]);
            }
            builder.endObject();
            return this.source(builder);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate", e);
        }
    }

    @Deprecated
    public IndexRequest source(BytesReference source) {
        return this.source(source, XContentFactory.xContentType(source));
    }

    public IndexRequest source(BytesReference source, XContentType xContentType) {
        this.source = Objects.requireNonNull(source);
        this.contentType = Objects.requireNonNull(xContentType);
        return this;
    }

    @Deprecated
    public IndexRequest source(byte[] source) {
        return this.source(source, 0, source.length);
    }

    public IndexRequest source(byte[] source, XContentType xContentType) {
        return this.source(source, 0, source.length, xContentType);
    }

    @Deprecated
    public IndexRequest source(byte[] source, int offset, int length) {
        return this.source(new BytesArray(source, offset, length), XContentFactory.xContentType(source));
    }

    public IndexRequest source(byte[] source, int offset, int length, XContentType xContentType) {
        return this.source(new BytesArray(source, offset, length), xContentType);
    }

    public IndexRequest opType(DocWriteRequest.OpType opType) {
        if (opType != DocWriteRequest.OpType.CREATE && opType != DocWriteRequest.OpType.INDEX) {
            throw new IllegalArgumentException("opType must be 'create' or 'index', found: [" + (Object)((Object)opType) + "]");
        }
        this.opType = opType;
        return this;
    }

    public IndexRequest opType(String opType) {
        String op = opType.toLowerCase(Locale.ROOT);
        if (op.equals("create")) {
            this.opType(DocWriteRequest.OpType.CREATE);
        } else if (op.equals("index")) {
            this.opType(DocWriteRequest.OpType.INDEX);
        } else {
            throw new IllegalArgumentException("opType must be 'create' or 'index', found: [" + opType + "]");
        }
        return this;
    }

    public IndexRequest create(boolean create) {
        if (create) {
            return this.opType(DocWriteRequest.OpType.CREATE);
        }
        return this.opType(DocWriteRequest.OpType.INDEX);
    }

    @Override
    public DocWriteRequest.OpType opType() {
        return this.opType;
    }

    @Override
    public IndexRequest version(long version) {
        this.version = version;
        return this;
    }

    @Override
    public long version() {
        return this.resolveVersionDefaults();
    }

    private long resolveVersionDefaults() {
        if (this.opType == DocWriteRequest.OpType.CREATE && this.version == -3L) {
            return -4L;
        }
        return this.version;
    }

    @Override
    public IndexRequest versionType(VersionType versionType) {
        this.versionType = versionType;
        return this;
    }

    @Override
    public VersionType versionType() {
        return this.versionType;
    }

    public void process(@Nullable MappingMetaData mappingMd, boolean allowIdGeneration, String concreteIndex) {
        if (this.timestamp != null) {
            this.timestamp = MappingMetaData.Timestamp.parseStringTimestamp(this.timestamp, mappingMd != null ? mappingMd.timestamp().dateTimeFormatter() : TimestampFieldMapper.Defaults.DATE_TIME_FORMATTER);
        }
        if (mappingMd != null) {
            if (mappingMd.routing().required() && this.routing == null) {
                throw new RoutingMissingException(concreteIndex, this.type, this.id);
            }
            if (this.parent != null && !mappingMd.hasParentField()) {
                throw new IllegalArgumentException("can't specify parent if no parent field has been configured");
            }
        } else if (this.parent != null) {
            throw new IllegalArgumentException("can't specify parent if no parent field has been configured");
        }
        if ("".equals(this.id)) {
            throw new IllegalArgumentException("if _id is specified it must not be empty");
        }
        if (allowIdGeneration && this.id == null) {
            assert (this.autoGeneratedTimestamp == -1L);
            this.autoGeneratedTimestamp = Math.max(0L, System.currentTimeMillis());
            this.id(UUIDs.base64UUID());
        }
        if (this.timestamp == null) {
            String defaultTimestamp = "now";
            if (mappingMd != null && mappingMd.timestamp() != null) {
                if (mappingMd.timestamp().ignoreMissing() != null && !mappingMd.timestamp().ignoreMissing().booleanValue()) {
                    throw new TimestampParsingException("timestamp is required by mapping");
                }
                defaultTimestamp = mappingMd.timestamp().defaultTimestamp();
            }
            if (defaultTimestamp.equals("now")) {
                this.timestamp = Long.toString(System.currentTimeMillis());
            } else {
                assert (mappingMd != null);
                this.timestamp = MappingMetaData.Timestamp.parseStringTimestamp(defaultTimestamp, mappingMd.timestamp().dateTimeFormatter());
            }
        }
    }

    public void resolveRouting(MetaData metaData) {
        this.routing(metaData.resolveIndexRouting(this.parent, this.routing, this.index));
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.type = in.readOptionalString();
        this.id = in.readOptionalString();
        this.routing = in.readOptionalString();
        this.parent = in.readOptionalString();
        this.timestamp = in.readOptionalString();
        this.ttl = in.readOptionalWriteable(TimeValue::new);
        this.source = in.readBytesReference();
        this.opType = DocWriteRequest.OpType.fromId(in.readByte());
        this.version = in.readLong();
        this.versionType = VersionType.fromValue(in.readByte());
        this.pipeline = in.readOptionalString();
        this.isRetry = in.readBoolean();
        this.autoGeneratedTimestamp = in.readLong();
        this.contentType = in.getVersion().onOrAfter(Version.V_5_3_0) ? in.readOptionalWriteable(XContentType::readFrom) : XContentFactory.xContentType(this.source);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.type);
        out.writeOptionalString(this.id);
        out.writeOptionalString(this.routing);
        out.writeOptionalString(this.parent);
        out.writeOptionalString(this.timestamp);
        out.writeOptionalWriteable(this.ttl);
        out.writeBytesReference(this.source);
        out.writeByte(this.opType.getId());
        if (out.getVersion().before(Version.V_5_1_2)) {
            out.writeLong(this.resolveVersionDefaults());
        } else {
            out.writeLong(this.version);
        }
        out.writeByte(this.versionType.getValue());
        out.writeOptionalString(this.pipeline);
        out.writeBoolean(this.isRetry);
        out.writeLong(this.autoGeneratedTimestamp);
        if (out.getVersion().onOrAfter(Version.V_5_3_0)) {
            out.writeOptionalWriteable(this.contentType);
        }
    }

    @Override
    public String toString() {
        String sSource = "_na_";
        try {
            sSource = this.source.length() > 2048 ? "n/a, actual length: [" + new ByteSizeValue(this.source.length()).toString() + "], max length: " + new ByteSizeValue(2048L).toString() : XContentHelper.convertToJson(this.source, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "index {[" + this.index + "][" + this.type + "][" + this.id + "], source[" + sSource + "]}";
    }

    public boolean isRetry() {
        return this.isRetry;
    }

    @Override
    public void onRetry() {
        this.isRetry = true;
    }

    public long getAutoGeneratedTimestamp() {
        return this.autoGeneratedTimestamp;
    }
}

