/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.function.Supplier;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchActionListener;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.QueryFetchSearchResult;
import org.elasticsearch.search.fetch.ScrollQueryFetchSearchResult;
import org.elasticsearch.search.fetch.ShardFetchRequest;
import org.elasticsearch.search.fetch.ShardFetchSearchRequest;
import org.elasticsearch.search.internal.InternalScrollSearchRequest;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.internal.ShardSearchTransportRequest;
import org.elasticsearch.search.query.QuerySearchRequest;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.query.ScrollQuerySearchResult;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.TaskAwareTransportRequestHandler;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportActionProxy;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class SearchTransportService
extends AbstractComponent {
    public static final String FREE_CONTEXT_SCROLL_ACTION_NAME = "indices:data/read/search[free_context/scroll]";
    public static final String FREE_CONTEXT_ACTION_NAME = "indices:data/read/search[free_context]";
    public static final String CLEAR_SCROLL_CONTEXTS_ACTION_NAME = "indices:data/read/search[clear_scroll_contexts]";
    public static final String DFS_ACTION_NAME = "indices:data/read/search[phase/dfs]";
    public static final String QUERY_ACTION_NAME = "indices:data/read/search[phase/query]";
    public static final String QUERY_ID_ACTION_NAME = "indices:data/read/search[phase/query/id]";
    public static final String QUERY_SCROLL_ACTION_NAME = "indices:data/read/search[phase/query/scroll]";
    @Deprecated
    public static final String QUERY_FETCH_ACTION_NAME = "indices:data/read/search[phase/query+fetch]";
    public static final String QUERY_FETCH_SCROLL_ACTION_NAME = "indices:data/read/search[phase/query+fetch/scroll]";
    public static final String FETCH_ID_SCROLL_ACTION_NAME = "indices:data/read/search[phase/fetch/id/scroll]";
    public static final String FETCH_ID_ACTION_NAME = "indices:data/read/search[phase/fetch/id]";
    public static final String QUERY_CAN_MATCH_NAME = "indices:data/read/search[can_match]";
    private final TransportService transportService;

    public SearchTransportService(Settings settings, TransportService transportService) {
        super(settings);
        this.transportService = transportService;
    }

    public void sendFreeContext(Transport.Connection connection, long contextId, OriginalIndices originalIndices) {
        this.transportService.sendRequest(connection, FREE_CONTEXT_ACTION_NAME, (TransportRequest)new SearchFreeContextRequest(originalIndices, contextId), TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<SearchFreeContextResponse>(new ActionListener<SearchFreeContextResponse>(){

            @Override
            public void onResponse(SearchFreeContextResponse response) {
            }

            @Override
            public void onFailure(Exception e) {
            }
        }, SearchFreeContextResponse::new));
    }

    public void sendFreeContext(Transport.Connection connection, long contextId, ActionListener<SearchFreeContextResponse> listener) {
        this.transportService.sendRequest(connection, FREE_CONTEXT_SCROLL_ACTION_NAME, (TransportRequest)new ScrollFreeContextRequest(contextId), TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<SearchFreeContextResponse>(listener, SearchFreeContextResponse::new));
    }

    public void sendCanMatch(Transport.Connection connection, ShardSearchTransportRequest request, SearchTask task, ActionListener<CanMatchResponse> listener) {
        if (!connection.getNode().getVersion().onOrAfter(Version.V_5_6_0)) {
            throw new IllegalArgumentException("can_match is not supported on pre 5.6.0 nodes");
        }
        this.transportService.sendChildRequest(connection, QUERY_CAN_MATCH_NAME, request, task, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<CanMatchResponse>(listener, CanMatchResponse::new));
    }

    public void sendClearAllScrollContexts(Transport.Connection connection, ActionListener<TransportResponse> listener) {
        this.transportService.sendRequest(connection, CLEAR_SCROLL_CONTEXTS_ACTION_NAME, (TransportRequest)TransportRequest.Empty.INSTANCE, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<TransportResponse>(listener, () -> TransportResponse.Empty.INSTANCE));
    }

    public void sendExecuteDfs(Transport.Connection connection, ShardSearchTransportRequest request, SearchTask task, SearchActionListener<DfsSearchResult> listener) {
        this.transportService.sendChildRequest(connection, DFS_ACTION_NAME, request, task, new ActionListenerResponseHandler<DfsSearchResult>(listener, DfsSearchResult::new));
    }

    public void sendExecuteQuery(Transport.Connection connection, ShardSearchTransportRequest request, SearchTask task, SearchActionListener<SearchPhaseResult> listener) {
        Supplier<SearchPhaseResult> supplier;
        boolean fetchDocuments = request.numberOfShards() == 1;
        Supplier<SearchPhaseResult> supplier2 = supplier = fetchDocuments ? QueryFetchSearchResult::new : QuerySearchResult::new;
        if (connection.getVersion().before(Version.V_5_3_0) && fetchDocuments) {
            if (request.scroll() != null) {
                request.searchType(SearchType.QUERY_AND_FETCH);
            }
            this.transportService.sendChildRequest(connection, QUERY_FETCH_ACTION_NAME, request, task, new ActionListenerResponseHandler<SearchPhaseResult>(listener, supplier));
        } else {
            this.transportService.sendChildRequest(connection, QUERY_ACTION_NAME, request, task, new ActionListenerResponseHandler<SearchPhaseResult>(listener, supplier));
        }
    }

    public void sendExecuteQuery(Transport.Connection connection, QuerySearchRequest request, SearchTask task, SearchActionListener<QuerySearchResult> listener) {
        this.transportService.sendChildRequest(connection, QUERY_ID_ACTION_NAME, request, task, new ActionListenerResponseHandler<QuerySearchResult>(listener, QuerySearchResult::new));
    }

    public void sendExecuteScrollQuery(Transport.Connection connection, InternalScrollSearchRequest request, SearchTask task, SearchActionListener<ScrollQuerySearchResult> listener) {
        this.transportService.sendChildRequest(connection, QUERY_SCROLL_ACTION_NAME, request, task, new ActionListenerResponseHandler<ScrollQuerySearchResult>(listener, ScrollQuerySearchResult::new));
    }

    public void sendExecuteScrollFetch(Transport.Connection connection, InternalScrollSearchRequest request, SearchTask task, SearchActionListener<ScrollQueryFetchSearchResult> listener) {
        this.transportService.sendChildRequest(connection, QUERY_FETCH_SCROLL_ACTION_NAME, request, task, new ActionListenerResponseHandler<ScrollQueryFetchSearchResult>(listener, ScrollQueryFetchSearchResult::new));
    }

    public void sendExecuteFetch(Transport.Connection connection, ShardFetchSearchRequest request, SearchTask task, SearchActionListener<FetchSearchResult> listener) {
        this.sendExecuteFetch(connection, FETCH_ID_ACTION_NAME, request, task, listener);
    }

    public void sendExecuteFetchScroll(Transport.Connection connection, ShardFetchRequest request, SearchTask task, SearchActionListener<FetchSearchResult> listener) {
        this.sendExecuteFetch(connection, FETCH_ID_SCROLL_ACTION_NAME, request, task, listener);
    }

    private void sendExecuteFetch(Transport.Connection connection, String action, ShardFetchRequest request, SearchTask task, SearchActionListener<FetchSearchResult> listener) {
        this.transportService.sendChildRequest(connection, action, request, task, new ActionListenerResponseHandler<FetchSearchResult>(listener, FetchSearchResult::new));
    }

    void sendExecuteMultiSearch(MultiSearchRequest request, SearchTask task, ActionListener<MultiSearchResponse> listener) {
        this.transportService.sendChildRequest(this.transportService.getConnection(this.transportService.getLocalNode()), "indices:data/read/msearch", request, task, new ActionListenerResponseHandler<MultiSearchResponse>(listener, MultiSearchResponse::new));
    }

    public RemoteClusterService getRemoteClusterService() {
        return this.transportService.getRemoteClusterService();
    }

    public static void registerRequestHandler(TransportService transportService, final SearchService searchService) {
        transportService.registerRequestHandler(FREE_CONTEXT_SCROLL_ACTION_NAME, ScrollFreeContextRequest::new, "same", new TaskAwareTransportRequestHandler<ScrollFreeContextRequest>(){

            @Override
            public void messageReceived(ScrollFreeContextRequest request, TransportChannel channel, Task task) throws Exception {
                boolean freed = searchService.freeContext(request.id());
                channel.sendResponse(new SearchFreeContextResponse(freed));
            }
        });
        TransportActionProxy.registerProxyAction(transportService, FREE_CONTEXT_SCROLL_ACTION_NAME, SearchFreeContextResponse::new);
        transportService.registerRequestHandler(FREE_CONTEXT_ACTION_NAME, SearchFreeContextRequest::new, "same", new TaskAwareTransportRequestHandler<SearchFreeContextRequest>(){

            @Override
            public void messageReceived(SearchFreeContextRequest request, TransportChannel channel, Task task) throws Exception {
                boolean freed = searchService.freeContext(request.id());
                channel.sendResponse(new SearchFreeContextResponse(freed));
            }
        });
        TransportActionProxy.registerProxyAction(transportService, FREE_CONTEXT_ACTION_NAME, SearchFreeContextResponse::new);
        transportService.registerRequestHandler(CLEAR_SCROLL_CONTEXTS_ACTION_NAME, () -> TransportRequest.Empty.INSTANCE, "same", new TaskAwareTransportRequestHandler<TransportRequest.Empty>(){

            @Override
            public void messageReceived(TransportRequest.Empty request, TransportChannel channel, Task task) throws Exception {
                searchService.freeAllScrollContexts();
                channel.sendResponse(TransportResponse.Empty.INSTANCE);
            }
        });
        TransportActionProxy.registerProxyAction(transportService, CLEAR_SCROLL_CONTEXTS_ACTION_NAME, () -> TransportResponse.Empty.INSTANCE);
        transportService.registerRequestHandler(DFS_ACTION_NAME, ShardSearchTransportRequest::new, "search", new TaskAwareTransportRequestHandler<ShardSearchTransportRequest>(){

            @Override
            public void messageReceived(ShardSearchTransportRequest request, TransportChannel channel, Task task) throws Exception {
                DfsSearchResult result = searchService.executeDfsPhase(request, (SearchTask)task);
                channel.sendResponse(result);
            }
        });
        TransportActionProxy.registerProxyAction(transportService, DFS_ACTION_NAME, DfsSearchResult::new);
        transportService.registerRequestHandler(QUERY_ACTION_NAME, ShardSearchTransportRequest::new, "search", new TaskAwareTransportRequestHandler<ShardSearchTransportRequest>(){

            @Override
            public void messageReceived(ShardSearchTransportRequest request, TransportChannel channel, Task task) throws Exception {
                SearchPhaseResult result = searchService.executeQueryPhase(request, (SearchTask)task);
                channel.sendResponse(result);
            }
        });
        TransportActionProxy.registerProxyAction(transportService, QUERY_ACTION_NAME, request -> ((ShardSearchRequest)((Object)request)).numberOfShards() == 1 ? QueryFetchSearchResult::new : QuerySearchResult::new);
        transportService.registerRequestHandler(QUERY_ID_ACTION_NAME, QuerySearchRequest::new, "search", new TaskAwareTransportRequestHandler<QuerySearchRequest>(){

            @Override
            public void messageReceived(QuerySearchRequest request, TransportChannel channel, Task task) throws Exception {
                QuerySearchResult result = searchService.executeQueryPhase(request, (SearchTask)task);
                channel.sendResponse(result);
            }
        });
        TransportActionProxy.registerProxyAction(transportService, QUERY_ID_ACTION_NAME, QuerySearchResult::new);
        transportService.registerRequestHandler(QUERY_SCROLL_ACTION_NAME, InternalScrollSearchRequest::new, "search", new TaskAwareTransportRequestHandler<InternalScrollSearchRequest>(){

            @Override
            public void messageReceived(InternalScrollSearchRequest request, TransportChannel channel, Task task) throws Exception {
                ScrollQuerySearchResult result = searchService.executeQueryPhase(request, (SearchTask)task);
                channel.sendResponse(result);
            }
        });
        TransportActionProxy.registerProxyAction(transportService, QUERY_SCROLL_ACTION_NAME, ScrollQuerySearchResult::new);
        transportService.registerRequestHandler(QUERY_FETCH_ACTION_NAME, ShardSearchTransportRequest::new, "search", new TaskAwareTransportRequestHandler<ShardSearchTransportRequest>(){

            @Override
            public void messageReceived(ShardSearchTransportRequest request, TransportChannel channel, Task task) throws Exception {
                assert (request.numberOfShards() == 1) : "expected single shard request but got: " + request.numberOfShards();
                SearchPhaseResult result = searchService.executeQueryPhase(request, (SearchTask)task);
                channel.sendResponse(result);
            }
        });
        TransportActionProxy.registerProxyAction(transportService, QUERY_FETCH_ACTION_NAME, QueryFetchSearchResult::new);
        transportService.registerRequestHandler(QUERY_FETCH_SCROLL_ACTION_NAME, InternalScrollSearchRequest::new, "search", new TaskAwareTransportRequestHandler<InternalScrollSearchRequest>(){

            @Override
            public void messageReceived(InternalScrollSearchRequest request, TransportChannel channel, Task task) throws Exception {
                ScrollQueryFetchSearchResult result = searchService.executeFetchPhase(request, (SearchTask)task);
                channel.sendResponse(result);
            }
        });
        TransportActionProxy.registerProxyAction(transportService, QUERY_FETCH_SCROLL_ACTION_NAME, ScrollQueryFetchSearchResult::new);
        transportService.registerRequestHandler(FETCH_ID_SCROLL_ACTION_NAME, ShardFetchRequest::new, "search", new TaskAwareTransportRequestHandler<ShardFetchRequest>(){

            @Override
            public void messageReceived(ShardFetchRequest request, TransportChannel channel, Task task) throws Exception {
                FetchSearchResult result = searchService.executeFetchPhase(request, (SearchTask)task);
                channel.sendResponse(result);
            }
        });
        TransportActionProxy.registerProxyAction(transportService, FETCH_ID_SCROLL_ACTION_NAME, FetchSearchResult::new);
        transportService.registerRequestHandler(FETCH_ID_ACTION_NAME, ShardFetchSearchRequest::new, "search", new TaskAwareTransportRequestHandler<ShardFetchSearchRequest>(){

            @Override
            public void messageReceived(ShardFetchSearchRequest request, TransportChannel channel, Task task) throws Exception {
                FetchSearchResult result = searchService.executeFetchPhase(request, (SearchTask)task);
                channel.sendResponse(result);
            }
        });
        TransportActionProxy.registerProxyAction(transportService, FETCH_ID_ACTION_NAME, FetchSearchResult::new);
        transportService.registerRequestHandler(QUERY_CAN_MATCH_NAME, ShardSearchTransportRequest::new, "search", false, true, new TaskAwareTransportRequestHandler<ShardSearchTransportRequest>(){

            @Override
            public void messageReceived(ShardSearchTransportRequest request, TransportChannel channel, Task task) throws Exception {
                boolean canMatch = searchService.canMatch(request);
                channel.sendResponse(new CanMatchResponse(canMatch));
            }
        });
        TransportActionProxy.registerProxyAction(transportService, QUERY_CAN_MATCH_NAME, CanMatchResponse::new);
    }

    Transport.Connection getConnection(String clusterAlias, DiscoveryNode node) {
        if (clusterAlias == null) {
            return this.transportService.getConnection(node);
        }
        return this.transportService.getRemoteClusterService().getConnection(node, clusterAlias);
    }

    public static final class CanMatchResponse
    extends SearchPhaseResult {
        private boolean canMatch;

        public CanMatchResponse() {
        }

        public CanMatchResponse(boolean canMatch) {
            this.canMatch = canMatch;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.canMatch = in.readBoolean();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.canMatch);
        }

        public boolean canMatch() {
            return this.canMatch;
        }
    }

    public static class SearchFreeContextResponse
    extends TransportResponse {
        private boolean freed;

        SearchFreeContextResponse() {
        }

        SearchFreeContextResponse(boolean freed) {
            this.freed = freed;
        }

        public boolean isFreed() {
            return this.freed;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.freed = in.readBoolean();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.freed);
        }
    }

    static class SearchFreeContextRequest
    extends ScrollFreeContextRequest
    implements IndicesRequest {
        private OriginalIndices originalIndices;

        SearchFreeContextRequest() {
        }

        SearchFreeContextRequest(OriginalIndices originalIndices, long id) {
            super(id);
            this.originalIndices = originalIndices;
        }

        @Override
        public String[] indices() {
            if (this.originalIndices == null) {
                return null;
            }
            return this.originalIndices.indices();
        }

        @Override
        public IndicesOptions indicesOptions() {
            if (this.originalIndices == null) {
                return null;
            }
            return this.originalIndices.indicesOptions();
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.originalIndices = OriginalIndices.readOriginalIndices(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            OriginalIndices.writeOriginalIndices(this.originalIndices, out);
        }
    }

    static class ScrollFreeContextRequest
    extends TransportRequest {
        private long id;

        ScrollFreeContextRequest() {
        }

        ScrollFreeContextRequest(long id) {
            this.id = id;
        }

        public long id() {
            return this.id;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.id = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeLong(this.id);
        }
    }
}

