/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.util.Supplier;
import org.elasticsearch.Assertions;
import org.elasticsearch.cluster.AckedClusterStateTaskListener;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateApplier;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.LocalNodeMasterListener;
import org.elasticsearch.cluster.NodeConnectionsService;
import org.elasticsearch.cluster.TimeoutClusterStateListener;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.ProcessClusterEventTimeoutException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.OperationRouting;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.service.PendingClusterTask;
import org.elasticsearch.cluster.service.SourcePrioritizedRunnable;
import org.elasticsearch.cluster.service.TaskBatcher;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.common.util.concurrent.PrioritizedEsThreadPoolExecutor;
import org.elasticsearch.common.util.iterable.Iterables;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.DiscoverySettings;
import org.elasticsearch.threadpool.ThreadPool;

public class ClusterService
extends AbstractLifecycleComponent {
    public static final Setting<TimeValue> CLUSTER_SERVICE_SLOW_TASK_LOGGING_THRESHOLD_SETTING = Setting.positiveTimeSetting("cluster.service.slow_task_logging_threshold", TimeValue.timeValueSeconds(30L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final String UPDATE_THREAD_NAME = "clusterService#updateTask";
    private final ThreadPool threadPool;
    private final ClusterName clusterName;
    private final Supplier<DiscoveryNode> localNodeSupplier;
    private BiConsumer<ClusterChangedEvent, Discovery.AckListener> clusterStatePublisher;
    private final OperationRouting operationRouting;
    private final ClusterSettings clusterSettings;
    private TimeValue slowTaskLoggingThreshold;
    private volatile PrioritizedEsThreadPoolExecutor threadPoolExecutor;
    private volatile ClusterServiceTaskBatcher taskBatcher;
    private final Collection<ClusterStateApplier> highPriorityStateAppliers = new CopyOnWriteArrayList<ClusterStateApplier>();
    private final Collection<ClusterStateApplier> normalPriorityStateAppliers = new CopyOnWriteArrayList<ClusterStateApplier>();
    private final Collection<ClusterStateApplier> lowPriorityStateAppliers = new CopyOnWriteArrayList<ClusterStateApplier>();
    private final Iterable<ClusterStateApplier> clusterStateAppliers = Iterables.concat(this.highPriorityStateAppliers, this.normalPriorityStateAppliers, this.lowPriorityStateAppliers);
    private final Collection<ClusterStateListener> clusterStateListeners = new CopyOnWriteArrayList<ClusterStateListener>();
    private final Collection<TimeoutClusterStateListener> timeoutClusterStateListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private final LocalNodeMasterListeners localNodeMasterListeners;
    private final Queue<NotifyTimeout> onGoingTimeouts = ConcurrentCollections.newQueue();
    private final AtomicReference<ClusterState> state;
    private final ClusterBlocks.Builder initialBlocks;
    private NodeConnectionsService nodeConnectionsService;
    private DiscoverySettings discoverySettings;

    public ClusterService(Settings settings, ClusterSettings clusterSettings, ThreadPool threadPool, Supplier<DiscoveryNode> localNodeSupplier) {
        super(settings);
        this.localNodeSupplier = localNodeSupplier;
        this.operationRouting = new OperationRouting(settings, clusterSettings);
        this.threadPool = threadPool;
        this.clusterSettings = clusterSettings;
        this.clusterName = ClusterName.CLUSTER_NAME_SETTING.get(settings);
        this.state = new AtomicReference<ClusterState>(ClusterState.builder(this.clusterName).build());
        this.clusterSettings.addSettingsUpdateConsumer(CLUSTER_SERVICE_SLOW_TASK_LOGGING_THRESHOLD_SETTING, this::setSlowTaskLoggingThreshold);
        this.slowTaskLoggingThreshold = CLUSTER_SERVICE_SLOW_TASK_LOGGING_THRESHOLD_SETTING.get(settings);
        this.localNodeMasterListeners = new LocalNodeMasterListeners(threadPool);
        this.initialBlocks = ClusterBlocks.builder();
    }

    private void setSlowTaskLoggingThreshold(TimeValue slowTaskLoggingThreshold) {
        this.slowTaskLoggingThreshold = slowTaskLoggingThreshold;
    }

    public synchronized void setClusterStatePublisher(BiConsumer<ClusterChangedEvent, Discovery.AckListener> publisher) {
        this.clusterStatePublisher = publisher;
    }

    private void updateState(UnaryOperator<ClusterState> updateFunction) {
        this.state.getAndUpdate(updateFunction);
    }

    public synchronized void setNodeConnectionsService(NodeConnectionsService nodeConnectionsService) {
        assert (this.nodeConnectionsService == null) : "nodeConnectionsService is already set";
        this.nodeConnectionsService = nodeConnectionsService;
    }

    public synchronized void addInitialStateBlock(ClusterBlock block) throws IllegalStateException {
        if (this.lifecycle.started()) {
            throw new IllegalStateException("can't set initial block when started");
        }
        this.initialBlocks.addGlobalBlock(block);
    }

    public synchronized void removeInitialStateBlock(ClusterBlock block) throws IllegalStateException {
        this.removeInitialStateBlock(block.id());
    }

    public synchronized void removeInitialStateBlock(int blockId) throws IllegalStateException {
        if (this.lifecycle.started()) {
            throw new IllegalStateException("can't set initial block when started");
        }
        this.initialBlocks.removeGlobalBlock(blockId);
    }

    @Override
    protected synchronized void doStart() {
        Objects.requireNonNull(this.clusterStatePublisher, "please set a cluster state publisher before starting");
        Objects.requireNonNull(this.nodeConnectionsService, "please set the node connection service before starting");
        Objects.requireNonNull(this.discoverySettings, "please set discovery settings before starting");
        this.addListener(this.localNodeMasterListeners);
        DiscoveryNode localNode = (DiscoveryNode)this.localNodeSupplier.get();
        assert (localNode != null);
        this.updateState(state -> {
            assert (state.nodes().getLocalNodeId() == null) : "local node is already set";
            DiscoveryNodes nodes = DiscoveryNodes.builder(state.nodes()).add(localNode).localNodeId(localNode.getId()).build();
            return ClusterState.builder(state).nodes(nodes).blocks(this.initialBlocks).build();
        });
        this.threadPoolExecutor = EsExecutors.newSinglePrioritizing(UPDATE_THREAD_NAME, EsExecutors.daemonThreadFactory(this.settings, UPDATE_THREAD_NAME), this.threadPool.getThreadContext(), this.threadPool.scheduler());
        this.taskBatcher = new ClusterServiceTaskBatcher(this.logger, this.threadPoolExecutor);
    }

    @Override
    protected synchronized void doStop() {
        for (NotifyTimeout onGoingTimeout : this.onGoingTimeouts) {
            onGoingTimeout.cancel();
            try {
                onGoingTimeout.cancel();
                onGoingTimeout.listener.onClose();
            }
            catch (Exception ex) {
                this.logger.debug("failed to notify listeners on shutdown", (Throwable)ex);
            }
        }
        ThreadPool.terminate(this.threadPoolExecutor, 10L, TimeUnit.SECONDS);
        this.timeoutClusterStateListeners.forEach(TimeoutClusterStateListener::onClose);
        this.removeListener(this.localNodeMasterListeners);
    }

    @Override
    protected synchronized void doClose() {
    }

    public DiscoveryNode localNode() {
        DiscoveryNode localNode = this.state().getNodes().getLocalNode();
        if (localNode == null) {
            throw new IllegalStateException("No local node found. Is the node started?");
        }
        return localNode;
    }

    public OperationRouting operationRouting() {
        return this.operationRouting;
    }

    public ClusterState state() {
        assert (ClusterService.assertNotCalledFromClusterStateApplier("the applied cluster state is not yet available"));
        return this.state.get();
    }

    public void addHighPriorityApplier(ClusterStateApplier applier) {
        this.highPriorityStateAppliers.add(applier);
    }

    public void addLowPriorityApplier(ClusterStateApplier applier) {
        this.lowPriorityStateAppliers.add(applier);
    }

    public void addStateApplier(ClusterStateApplier applier) {
        this.normalPriorityStateAppliers.add(applier);
    }

    public void removeApplier(ClusterStateApplier applier) {
        this.normalPriorityStateAppliers.remove(applier);
        this.highPriorityStateAppliers.remove(applier);
        this.lowPriorityStateAppliers.remove(applier);
    }

    public void addListener(ClusterStateListener listener) {
        this.clusterStateListeners.add(listener);
    }

    public void removeListener(ClusterStateListener listener) {
        this.clusterStateListeners.remove(listener);
    }

    public void removeTimeoutListener(TimeoutClusterStateListener listener) {
        this.timeoutClusterStateListeners.remove(listener);
        Iterator it = this.onGoingTimeouts.iterator();
        while (it.hasNext()) {
            NotifyTimeout timeout = (NotifyTimeout)it.next();
            if (!timeout.listener.equals(listener)) continue;
            timeout.cancel();
            it.remove();
        }
    }

    public void addLocalNodeMasterListener(LocalNodeMasterListener listener) {
        this.localNodeMasterListeners.add(listener);
    }

    public void removeLocalNodeMasterListener(LocalNodeMasterListener listener) {
        this.localNodeMasterListeners.remove(listener);
    }

    public void addTimeoutListener(final @Nullable TimeValue timeout, final TimeoutClusterStateListener listener) {
        if (this.lifecycle.stoppedOrClosed()) {
            listener.onClose();
            return;
        }
        try {
            this.threadPoolExecutor.execute(new SourcePrioritizedRunnable(Priority.HIGH, "_add_listener_"){

                @Override
                public void run() {
                    if (timeout != null) {
                        NotifyTimeout notifyTimeout = new NotifyTimeout(listener, timeout);
                        notifyTimeout.future = ClusterService.this.threadPool.schedule(timeout, "generic", notifyTimeout);
                        ClusterService.this.onGoingTimeouts.add(notifyTimeout);
                    }
                    ClusterService.this.timeoutClusterStateListeners.add(listener);
                    listener.postAdded();
                }
            });
        }
        catch (EsRejectedExecutionException e) {
            if (this.lifecycle.stoppedOrClosed()) {
                listener.onClose();
            }
            throw e;
        }
    }

    public <T extends ClusterStateTaskConfig & ClusterStateTaskExecutor<T>> void submitStateUpdateTask(String source, T updateTask) {
        this.submitStateUpdateTask(source, updateTask, updateTask, updateTask, (ClusterStateTaskListener)updateTask);
    }

    public <T> void submitStateUpdateTask(String source, T task, ClusterStateTaskConfig config, ClusterStateTaskExecutor<T> executor, ClusterStateTaskListener listener) {
        this.submitStateUpdateTasks(source, Collections.singletonMap(task, listener), config, executor);
    }

    public <T> void submitStateUpdateTasks(String source, Map<T, ClusterStateTaskListener> tasks, ClusterStateTaskConfig config, ClusterStateTaskExecutor<T> executor) {
        block3: {
            if (!this.lifecycle.started()) {
                return;
            }
            try {
                List safeTasks = tasks.entrySet().stream().map(e -> {
                    ClusterServiceTaskBatcher clusterServiceTaskBatcher = this.taskBatcher;
                    clusterServiceTaskBatcher.getClass();
                    return clusterServiceTaskBatcher.new ClusterServiceTaskBatcher.UpdateTask(config.priority(), source, e.getKey(), ClusterService.safe((ClusterStateTaskListener)e.getValue(), this.logger), executor);
                }).collect(Collectors.toList());
                this.taskBatcher.submitTasks(safeTasks, config.timeout());
            }
            catch (EsRejectedExecutionException e2) {
                if (this.lifecycle.stoppedOrClosed()) break block3;
                throw e2;
            }
        }
    }

    public List<PendingClusterTask> pendingTasks() {
        return Arrays.stream(this.threadPoolExecutor.getPending()).map(pending -> {
            assert (pending.task instanceof SourcePrioritizedRunnable) : "thread pool executor should only use SourcePrioritizedRunnable instances but found: " + pending.task.getClass().getName();
            SourcePrioritizedRunnable task = (SourcePrioritizedRunnable)pending.task;
            return new PendingClusterTask(pending.insertionOrder, pending.priority, new Text(task.source()), task.getAgeInMillis(), pending.executing);
        }).collect(Collectors.toList());
    }

    public int numberOfPendingTasks() {
        return this.threadPoolExecutor.getNumberOfPendingTasks();
    }

    public TimeValue getMaxTaskWaitTime() {
        return this.threadPoolExecutor.getMaxTaskWaitTime();
    }

    public static boolean assertClusterStateThread() {
        assert (Thread.currentThread().getName().contains(UPDATE_THREAD_NAME)) : "not called from the cluster state update thread";
        return true;
    }

    public static boolean assertNotClusterStateUpdateThread(String reason) {
        assert (!Thread.currentThread().getName().contains(UPDATE_THREAD_NAME)) : "Expected current thread [" + Thread.currentThread() + "] to not be the cluster state update thread. Reason: [" + reason + "]";
        return true;
    }

    private static boolean assertNotCalledFromClusterStateApplier(String reason) {
        if (Thread.currentThread().getName().contains(UPDATE_THREAD_NAME)) {
            for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
                String className = element.getClassName();
                String methodName = element.getMethodName();
                if (className.equals(ClusterStateObserver.class.getName())) {
                    return true;
                }
                if (className.equals(ClusterService.class.getName()) && methodName.equals("callClusterStateAppliers")) {
                    throw new AssertionError((Object)("should not be called by a cluster state applier. reason [" + reason + "]"));
                }
            }
        }
        return true;
    }

    public ClusterName getClusterName() {
        return this.clusterName;
    }

    public void setDiscoverySettings(DiscoverySettings discoverySettings) {
        this.discoverySettings = discoverySettings;
    }

    void runTasks(TaskInputs taskInputs) {
        if (!this.lifecycle.started()) {
            this.logger.debug("processing [{}]: ignoring, cluster service not started", (Object)taskInputs.summary);
            return;
        }
        this.logger.debug("processing [{}]: execute", (Object)taskInputs.summary);
        ClusterState previousClusterState = this.state();
        if (!previousClusterState.nodes().isLocalNodeElectedMaster() && taskInputs.runOnlyOnMaster()) {
            this.logger.debug("failing [{}]: local node is no longer master", (Object)taskInputs.summary);
            taskInputs.onNoLongerMaster();
            return;
        }
        long startTimeNS = this.currentTimeInNanos();
        TaskOutputs taskOutputs = this.calculateTaskOutputs(taskInputs, previousClusterState, startTimeNS);
        taskOutputs.notifyFailedTasks();
        if (taskOutputs.clusterStateUnchanged()) {
            taskOutputs.notifySuccessfulTasksOnUnchangedClusterState();
            TimeValue executionTime = TimeValue.timeValueMillis(Math.max(0L, TimeValue.nsecToMSec(this.currentTimeInNanos() - startTimeNS)));
            this.logger.debug("processing [{}]: took [{}] no change in cluster_state", (Object)taskInputs.summary, (Object)executionTime);
            this.warnAboutSlowTaskIfNeeded(executionTime, taskInputs.summary);
        } else {
            ClusterState newClusterState = taskOutputs.newClusterState;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("cluster state updated, source [{}]\n{}", (Object)taskInputs.summary, (Object)newClusterState);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("cluster state updated, version [{}], source [{}]", (Object)newClusterState.version(), (Object)taskInputs.summary);
            }
            try {
                this.publishAndApplyChanges(taskInputs, taskOutputs);
                TimeValue executionTime = TimeValue.timeValueMillis(Math.max(0L, TimeValue.nsecToMSec(this.currentTimeInNanos() - startTimeNS)));
                this.logger.debug("processing [{}]: took [{}] done applying updated cluster_state (version: {}, uuid: {})", (Object)taskInputs.summary, (Object)executionTime, (Object)newClusterState.version(), (Object)newClusterState.stateUUID());
                this.warnAboutSlowTaskIfNeeded(executionTime, taskInputs.summary);
            }
            catch (Exception e) {
                TimeValue executionTime = TimeValue.timeValueMillis(Math.max(0L, TimeValue.nsecToMSec(this.currentTimeInNanos() - startTimeNS)));
                long version = newClusterState.version();
                String stateUUID = newClusterState.stateUUID();
                String fullState = newClusterState.toString();
                this.logger.warn(() -> new ParameterizedMessage("failed to apply updated cluster state in [{}]:\nversion [{}], uuid [{}], source [{}]\n{}", new Object[]{executionTime, version, stateUUID, taskInputs.summary, fullState}), (Throwable)e);
            }
        }
    }

    public TaskOutputs calculateTaskOutputs(TaskInputs taskInputs, ClusterState previousClusterState, long startTimeNS) {
        ClusterStateTaskExecutor.ClusterTasksResult<Object> clusterTasksResult = this.executeTasks(taskInputs, startTimeNS, previousClusterState);
        ArrayList<ClusterServiceTaskBatcher.UpdateTask> nonFailedTasks = new ArrayList<ClusterServiceTaskBatcher.UpdateTask>();
        for (ClusterServiceTaskBatcher.UpdateTask updateTask : taskInputs.updateTasks) {
            assert (clusterTasksResult.executionResults.containsKey(updateTask.task)) : "missing " + updateTask;
            ClusterStateTaskExecutor.TaskResult taskResult = clusterTasksResult.executionResults.get(updateTask.task);
            if (!taskResult.isSuccess()) continue;
            nonFailedTasks.add(updateTask);
        }
        ClusterState newClusterState = this.patchVersionsAndNoMasterBlocks(previousClusterState, clusterTasksResult);
        return new TaskOutputs(taskInputs, previousClusterState, newClusterState, nonFailedTasks, clusterTasksResult.executionResults);
    }

    private ClusterStateTaskExecutor.ClusterTasksResult<Object> executeTasks(TaskInputs taskInputs, long startTimeNS, ClusterState previousClusterState) {
        ClusterStateTaskExecutor.ClusterTasksResult<Object> clusterTasksResult;
        try {
            List inputs = taskInputs.updateTasks.stream().map(TaskBatcher.BatchedTask::getTask).collect(Collectors.toList());
            clusterTasksResult = taskInputs.executor.execute(previousClusterState, inputs);
        }
        catch (Exception e) {
            TimeValue executionTime = TimeValue.timeValueMillis(Math.max(0L, TimeValue.nsecToMSec(this.currentTimeInNanos() - startTimeNS)));
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(() -> new ParameterizedMessage("failed to execute cluster state update in [{}], state:\nversion [{}], source [{}]\n{}{}{}", new Object[]{executionTime, previousClusterState.version(), taskInputs.summary, previousClusterState.nodes(), previousClusterState.routingTable(), previousClusterState.getRoutingNodes()}), (Throwable)e);
            }
            this.warnAboutSlowTaskIfNeeded(executionTime, taskInputs.summary);
            clusterTasksResult = ClusterStateTaskExecutor.ClusterTasksResult.builder().failures(taskInputs.updateTasks.stream().map(TaskBatcher.BatchedTask::getTask)::iterator, e).build(previousClusterState);
        }
        assert (clusterTasksResult.executionResults != null);
        assert (clusterTasksResult.executionResults.size() == taskInputs.updateTasks.size()) : String.format(Locale.ROOT, "expected [%d] task result%s but was [%d]", taskInputs.updateTasks.size(), taskInputs.updateTasks.size() == 1 ? "" : "s", clusterTasksResult.executionResults.size());
        if (Assertions.ENABLED) {
            for (ClusterServiceTaskBatcher.UpdateTask updateTask : taskInputs.updateTasks) {
                assert (clusterTasksResult.executionResults.containsKey(updateTask.task)) : "missing task result for " + updateTask;
            }
        }
        return clusterTasksResult;
    }

    private ClusterState patchVersionsAndNoMasterBlocks(ClusterState previousClusterState, ClusterStateTaskExecutor.ClusterTasksResult<Object> executionResult) {
        ClusterState newClusterState = executionResult.resultingState;
        if (executionResult.noMaster) {
            assert (newClusterState == previousClusterState) : "state can only be changed by ClusterService when noMaster = true";
            if (previousClusterState.nodes().getMasterNodeId() != null) {
                assert (!previousClusterState.blocks().hasGlobalBlock(this.discoverySettings.getNoMasterBlock().id())) : "NO_MASTER_BLOCK should only be added by ClusterService";
                ClusterBlocks clusterBlocks = ClusterBlocks.builder().blocks(previousClusterState.blocks()).addGlobalBlock(this.discoverySettings.getNoMasterBlock()).build();
                DiscoveryNodes discoveryNodes = new DiscoveryNodes.Builder(previousClusterState.nodes()).masterNodeId(null).build();
                newClusterState = ClusterState.builder(previousClusterState).blocks(clusterBlocks).nodes(discoveryNodes).build();
            }
        } else if (newClusterState.nodes().isLocalNodeElectedMaster() && previousClusterState != newClusterState) {
            ClusterState.Builder builder = ClusterState.builder(newClusterState).incrementVersion();
            if (previousClusterState.routingTable() != newClusterState.routingTable()) {
                builder.routingTable(RoutingTable.builder(newClusterState.routingTable()).version(newClusterState.routingTable().version() + 1L).build());
            }
            if (previousClusterState.metaData() != newClusterState.metaData()) {
                builder.metaData(MetaData.builder(newClusterState.metaData()).version(newClusterState.metaData().version() + 1L));
            }
            if (newClusterState.blocks().hasGlobalBlock(this.discoverySettings.getNoMasterBlock().id())) {
                builder.blocks(ClusterBlocks.builder().blocks(newClusterState.blocks()).removeGlobalBlock(this.discoverySettings.getNoMasterBlock().id()));
            }
            newClusterState = builder.build();
        }
        assert (newClusterState.nodes().getMasterNodeId() == null || !newClusterState.blocks().hasGlobalBlock(this.discoverySettings.getNoMasterBlock().id())) : "cluster state with master node must not have NO_MASTER_BLOCK";
        return newClusterState;
    }

    private void publishAndApplyChanges(TaskInputs taskInputs, TaskOutputs taskOutputs) {
        String summary;
        ClusterState newClusterState = taskOutputs.newClusterState;
        ClusterState previousClusterState = taskOutputs.previousClusterState;
        ClusterChangedEvent clusterChangedEvent = new ClusterChangedEvent(taskInputs.summary, newClusterState, previousClusterState);
        DiscoveryNodes.Delta nodesDelta = clusterChangedEvent.nodesDelta();
        if (nodesDelta.hasChanges() && this.logger.isInfoEnabled() && (summary = nodesDelta.shortSummary()).length() > 0) {
            this.logger.info("{}, reason: {}", (Object)summary, (Object)taskInputs.summary);
        }
        Discovery.AckListener ackListener = newClusterState.nodes().isLocalNodeElectedMaster() ? taskOutputs.createAckListener(this.threadPool, newClusterState) : null;
        this.nodeConnectionsService.connectToNodes(newClusterState.nodes());
        if (newClusterState.nodes().isLocalNodeElectedMaster()) {
            this.logger.debug("publishing cluster state version [{}]", (Object)newClusterState.version());
            try {
                this.clusterStatePublisher.accept(clusterChangedEvent, ackListener);
            }
            catch (Discovery.FailedToCommitClusterStateException t) {
                long version = newClusterState.version();
                this.logger.warn(() -> new ParameterizedMessage("failing [{}]: failed to commit cluster state version [{}]", (Object)taskInputs.summary, (Object)version), (Throwable)t);
                this.nodeConnectionsService.connectToNodes(previousClusterState.nodes());
                this.nodeConnectionsService.disconnectFromNodesExcept(previousClusterState.nodes());
                taskOutputs.publishingFailed(t);
                return;
            }
        }
        this.logger.debug("applying cluster state version {}", (Object)newClusterState.version());
        try {
            if (!clusterChangedEvent.state().blocks().disableStatePersistence() && clusterChangedEvent.metaDataChanged()) {
                Settings incomingSettings = clusterChangedEvent.state().metaData().settings();
                this.clusterSettings.applySettings(incomingSettings);
            }
        }
        catch (Exception ex) {
            this.logger.warn("failed to apply cluster settings", (Throwable)ex);
        }
        this.logger.debug("set local cluster state to version {}", (Object)newClusterState.version());
        this.callClusterStateAppliers(newClusterState, clusterChangedEvent);
        this.nodeConnectionsService.disconnectFromNodesExcept(newClusterState.nodes());
        this.updateState(css -> newClusterState);
        Stream.concat(this.clusterStateListeners.stream(), this.timeoutClusterStateListeners.stream()).forEach(listener -> {
            try {
                this.logger.trace("calling [{}] with change to version [{}]", listener, (Object)newClusterState.version());
                listener.clusterChanged(clusterChangedEvent);
            }
            catch (Exception ex) {
                this.logger.warn("failed to notify ClusterStateListener", (Throwable)ex);
            }
        });
        if (newClusterState.nodes().isLocalNodeElectedMaster()) {
            try {
                ackListener.onNodeAck(newClusterState.nodes().getLocalNode(), null);
            }
            catch (Exception e) {
                DiscoveryNode localNode = newClusterState.nodes().getLocalNode();
                this.logger.debug(() -> new ParameterizedMessage("error while processing ack for master node [{}]", (Object)localNode), (Throwable)e);
            }
        }
        taskOutputs.processedDifferentClusterState(previousClusterState, newClusterState);
        if (newClusterState.nodes().isLocalNodeElectedMaster()) {
            try {
                taskOutputs.clusterStatePublished(clusterChangedEvent);
            }
            catch (Exception e) {
                this.logger.error(() -> new ParameterizedMessage("exception thrown while notifying executor of new cluster state publication [{}]", (Object)taskInputs.summary), (Throwable)e);
            }
        }
    }

    private void callClusterStateAppliers(ClusterState newClusterState, ClusterChangedEvent clusterChangedEvent) {
        for (ClusterStateApplier applier : this.clusterStateAppliers) {
            try {
                this.logger.trace("calling [{}] with change to version [{}]", (Object)applier, (Object)newClusterState.version());
                applier.applyClusterState(clusterChangedEvent);
            }
            catch (Exception ex) {
                this.logger.warn("failed to notify ClusterStateApplier", (Throwable)ex);
            }
        }
    }

    protected long currentTimeInNanos() {
        return System.nanoTime();
    }

    private static SafeClusterStateTaskListener safe(ClusterStateTaskListener listener, Logger logger) {
        if (listener instanceof AckedClusterStateTaskListener) {
            return new SafeAckedClusterStateTaskListener((AckedClusterStateTaskListener)listener, logger);
        }
        return new SafeClusterStateTaskListener(listener, logger);
    }

    private void warnAboutSlowTaskIfNeeded(TimeValue executionTime, String source) {
        if (executionTime.getMillis() > this.slowTaskLoggingThreshold.getMillis()) {
            this.logger.warn("cluster state update task [{}] took [{}] above the warn threshold of {}", (Object)source, (Object)executionTime, (Object)this.slowTaskLoggingThreshold);
        }
    }

    public ClusterSettings getClusterSettings() {
        return this.clusterSettings;
    }

    public Settings getSettings() {
        return this.settings;
    }

    private static class AckCountDownListener
    implements Discovery.AckListener {
        private static final Logger logger = Loggers.getLogger(AckCountDownListener.class);
        private final AckedClusterStateTaskListener ackedTaskListener;
        private final CountDown countDown;
        private final DiscoveryNodes nodes;
        private final long clusterStateVersion;
        private final Future<?> ackTimeoutCallback;
        private Exception lastFailure;

        AckCountDownListener(AckedClusterStateTaskListener ackedTaskListener, long clusterStateVersion, DiscoveryNodes nodes, ThreadPool threadPool) {
            this.ackedTaskListener = ackedTaskListener;
            this.clusterStateVersion = clusterStateVersion;
            this.nodes = nodes;
            int countDown = 0;
            for (DiscoveryNode node : nodes) {
                if (!ackedTaskListener.mustAck(node)) continue;
                ++countDown;
            }
            countDown = Math.max(1, countDown);
            logger.trace("expecting {} acknowledgements for cluster_state update (version: {})", (Object)countDown, (Object)clusterStateVersion);
            this.countDown = new CountDown(countDown);
            this.ackTimeoutCallback = threadPool.schedule(ackedTaskListener.ackTimeout(), "generic", () -> this.onTimeout());
        }

        @Override
        public void onNodeAck(DiscoveryNode node, @Nullable Exception e) {
            if (!this.ackedTaskListener.mustAck(node) && !node.equals(this.nodes.getMasterNode())) {
                return;
            }
            if (e == null) {
                logger.trace("ack received from node [{}], cluster_state update (version: {})", (Object)node, (Object)this.clusterStateVersion);
            } else {
                this.lastFailure = e;
                logger.debug(() -> new ParameterizedMessage("ack received from node [{}], cluster_state update (version: {})", (Object)node, (Object)this.clusterStateVersion), (Throwable)e);
            }
            if (this.countDown.countDown()) {
                logger.trace("all expected nodes acknowledged cluster_state update (version: {})", (Object)this.clusterStateVersion);
                FutureUtils.cancel(this.ackTimeoutCallback);
                this.ackedTaskListener.onAllNodesAcked(this.lastFailure);
            }
        }

        @Override
        public void onTimeout() {
            if (this.countDown.fastForward()) {
                logger.trace("timeout waiting for acknowledgement for cluster_state update (version: {})", (Object)this.clusterStateVersion);
                this.ackedTaskListener.onAckTimeout();
            }
        }
    }

    private static class DelegetingAckListener
    implements Discovery.AckListener {
        private final List<Discovery.AckListener> listeners;

        private DelegetingAckListener(List<Discovery.AckListener> listeners) {
            this.listeners = listeners;
        }

        @Override
        public void onNodeAck(DiscoveryNode node, @Nullable Exception e) {
            for (Discovery.AckListener listener : this.listeners) {
                listener.onNodeAck(node, e);
            }
        }

        @Override
        public void onTimeout() {
            throw new UnsupportedOperationException("no timeout delegation");
        }
    }

    private static class OffMasterRunnable
    implements Runnable {
        private final LocalNodeMasterListener listener;

        private OffMasterRunnable(LocalNodeMasterListener listener) {
            this.listener = listener;
        }

        @Override
        public void run() {
            this.listener.offMaster();
        }
    }

    private static class OnMasterRunnable
    implements Runnable {
        private final LocalNodeMasterListener listener;

        private OnMasterRunnable(LocalNodeMasterListener listener) {
            this.listener = listener;
        }

        @Override
        public void run() {
            this.listener.onMaster();
        }
    }

    private static class LocalNodeMasterListeners
    implements ClusterStateListener {
        private final List<LocalNodeMasterListener> listeners = new CopyOnWriteArrayList<LocalNodeMasterListener>();
        private final ThreadPool threadPool;
        private volatile boolean master = false;

        private LocalNodeMasterListeners(ThreadPool threadPool) {
            this.threadPool = threadPool;
        }

        @Override
        public void clusterChanged(ClusterChangedEvent event) {
            if (!this.master && event.localNodeMaster()) {
                this.master = true;
                for (LocalNodeMasterListener listener : this.listeners) {
                    ExecutorService executor = this.threadPool.executor(listener.executorName());
                    executor.execute(new OnMasterRunnable(listener));
                }
                return;
            }
            if (this.master && !event.localNodeMaster()) {
                this.master = false;
                for (LocalNodeMasterListener listener : this.listeners) {
                    ExecutorService executor = this.threadPool.executor(listener.executorName());
                    executor.execute(new OffMasterRunnable(listener));
                }
            }
        }

        private void add(LocalNodeMasterListener listener) {
            this.listeners.add(listener);
        }

        private void remove(LocalNodeMasterListener listener) {
            this.listeners.remove(listener);
        }

        private void clear() {
            this.listeners.clear();
        }
    }

    class NotifyTimeout
    implements Runnable {
        final TimeoutClusterStateListener listener;
        final TimeValue timeout;
        volatile ScheduledFuture future;

        NotifyTimeout(TimeoutClusterStateListener listener, TimeValue timeout) {
            this.listener = listener;
            this.timeout = timeout;
        }

        public void cancel() {
            FutureUtils.cancel(this.future);
        }

        @Override
        public void run() {
            if (this.future != null && this.future.isCancelled()) {
                return;
            }
            if (ClusterService.this.lifecycle.stoppedOrClosed()) {
                this.listener.onClose();
            } else {
                this.listener.onTimeout(this.timeout);
            }
        }
    }

    private static class SafeAckedClusterStateTaskListener
    extends SafeClusterStateTaskListener
    implements AckedClusterStateTaskListener {
        private final AckedClusterStateTaskListener listener;
        private final Logger logger;

        SafeAckedClusterStateTaskListener(AckedClusterStateTaskListener listener, Logger logger) {
            super(listener, logger);
            this.listener = listener;
            this.logger = logger;
        }

        @Override
        public boolean mustAck(DiscoveryNode discoveryNode) {
            return this.listener.mustAck(discoveryNode);
        }

        @Override
        public void onAllNodesAcked(@Nullable Exception e) {
            try {
                this.listener.onAllNodesAcked(e);
            }
            catch (Exception inner) {
                inner.addSuppressed(e);
                this.logger.error("exception thrown by listener while notifying on all nodes acked", (Throwable)inner);
            }
        }

        @Override
        public void onAckTimeout() {
            try {
                this.listener.onAckTimeout();
            }
            catch (Exception e) {
                this.logger.error("exception thrown by listener while notifying on ack timeout", (Throwable)e);
            }
        }

        @Override
        public TimeValue ackTimeout() {
            return this.listener.ackTimeout();
        }
    }

    private static class SafeClusterStateTaskListener
    implements ClusterStateTaskListener {
        private final ClusterStateTaskListener listener;
        private final Logger logger;

        SafeClusterStateTaskListener(ClusterStateTaskListener listener, Logger logger) {
            this.listener = listener;
            this.logger = logger;
        }

        @Override
        public void onFailure(String source, Exception e) {
            try {
                this.listener.onFailure(source, e);
            }
            catch (Exception inner) {
                inner.addSuppressed(e);
                this.logger.error(() -> new ParameterizedMessage("exception thrown by listener notifying of failure from [{}]", (Object)source), (Throwable)inner);
            }
        }

        @Override
        public void onNoLongerMaster(String source) {
            try {
                this.listener.onNoLongerMaster(source);
            }
            catch (Exception e) {
                this.logger.error(() -> new ParameterizedMessage("exception thrown by listener while notifying no longer master from [{}]", (Object)source), (Throwable)e);
            }
        }

        @Override
        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            try {
                this.listener.clusterStateProcessed(source, oldState, newState);
            }
            catch (Exception e) {
                this.logger.error(() -> new ParameterizedMessage("exception thrown by listener while notifying of cluster state processed from [{}], old cluster state:\n{}\nnew cluster state:\n{}", new Object[]{source, oldState, newState}), (Throwable)e);
            }
        }
    }

    class TaskOutputs {
        public final TaskInputs taskInputs;
        public final ClusterState previousClusterState;
        public final ClusterState newClusterState;
        public final List<ClusterServiceTaskBatcher.UpdateTask> nonFailedTasks;
        public final Map<Object, ClusterStateTaskExecutor.TaskResult> executionResults;

        TaskOutputs(TaskInputs taskInputs, ClusterState previousClusterState, ClusterState newClusterState, List<ClusterServiceTaskBatcher.UpdateTask> nonFailedTasks, Map<Object, ClusterStateTaskExecutor.TaskResult> executionResults) {
            this.taskInputs = taskInputs;
            this.previousClusterState = previousClusterState;
            this.newClusterState = newClusterState;
            this.nonFailedTasks = nonFailedTasks;
            this.executionResults = executionResults;
        }

        public void publishingFailed(Discovery.FailedToCommitClusterStateException t) {
            this.nonFailedTasks.forEach(task -> task.listener.onFailure(task.source, t));
        }

        public void processedDifferentClusterState(ClusterState previousClusterState, ClusterState newClusterState) {
            this.nonFailedTasks.forEach(task -> task.listener.clusterStateProcessed(task.source, previousClusterState, newClusterState));
        }

        public void clusterStatePublished(ClusterChangedEvent clusterChangedEvent) {
            this.taskInputs.executor.clusterStatePublished(clusterChangedEvent);
        }

        public Discovery.AckListener createAckListener(ThreadPool threadPool, ClusterState newClusterState) {
            ArrayList ackListeners = new ArrayList();
            this.nonFailedTasks.stream().filter(task -> task.listener instanceof AckedClusterStateTaskListener).forEach(task -> {
                AckedClusterStateTaskListener ackedListener = (AckedClusterStateTaskListener)task.listener;
                if (ackedListener.ackTimeout() == null || ackedListener.ackTimeout().millis() == 0L) {
                    ackedListener.onAckTimeout();
                } else {
                    try {
                        ackListeners.add(new AckCountDownListener(ackedListener, newClusterState.version(), newClusterState.nodes(), threadPool));
                    }
                    catch (EsRejectedExecutionException ex) {
                        if (ClusterService.this.logger.isDebugEnabled()) {
                            ClusterService.this.logger.debug("Couldn't schedule timeout thread - node might be shutting down", (Throwable)ex);
                        }
                        ackedListener.onAckTimeout();
                    }
                }
            });
            return new DelegetingAckListener(ackListeners);
        }

        public boolean clusterStateUnchanged() {
            return this.previousClusterState == this.newClusterState;
        }

        public void notifyFailedTasks() {
            for (ClusterServiceTaskBatcher.UpdateTask updateTask : this.taskInputs.updateTasks) {
                assert (this.executionResults.containsKey(updateTask.task)) : "missing " + updateTask;
                ClusterStateTaskExecutor.TaskResult taskResult = this.executionResults.get(updateTask.task);
                if (taskResult.isSuccess()) continue;
                updateTask.listener.onFailure(updateTask.source, taskResult.getFailure());
            }
        }

        public void notifySuccessfulTasksOnUnchangedClusterState() {
            this.nonFailedTasks.forEach(task -> {
                if (task.listener instanceof AckedClusterStateTaskListener) {
                    ((AckedClusterStateTaskListener)task.listener).onAllNodesAcked(null);
                }
                task.listener.clusterStateProcessed(task.source, this.newClusterState, this.newClusterState);
            });
        }
    }

    class TaskInputs {
        public final String summary;
        public final List<ClusterServiceTaskBatcher.UpdateTask> updateTasks;
        public final ClusterStateTaskExecutor<Object> executor;

        TaskInputs(ClusterStateTaskExecutor<Object> executor, List<ClusterServiceTaskBatcher.UpdateTask> updateTasks, String summary) {
            this.summary = summary;
            this.executor = executor;
            this.updateTasks = updateTasks;
        }

        public boolean runOnlyOnMaster() {
            return this.executor.runOnlyOnMaster();
        }

        public void onNoLongerMaster() {
            this.updateTasks.stream().forEach(task -> task.listener.onNoLongerMaster(task.source));
        }
    }

    class ClusterServiceTaskBatcher
    extends TaskBatcher {
        ClusterServiceTaskBatcher(Logger logger, PrioritizedEsThreadPoolExecutor threadExecutor) {
            super(logger, threadExecutor);
        }

        @Override
        protected void onTimeout(List<? extends TaskBatcher.BatchedTask> tasks, TimeValue timeout) {
            ClusterService.this.threadPool.generic().execute(() -> tasks.forEach(task -> ((UpdateTask)task).listener.onFailure(task.source, new ProcessClusterEventTimeoutException(timeout, task.source))));
        }

        @Override
        protected void run(Object batchingKey, List<? extends TaskBatcher.BatchedTask> tasks, String tasksSummary) {
            ClusterStateTaskExecutor taskExecutor = (ClusterStateTaskExecutor)batchingKey;
            List<? extends TaskBatcher.BatchedTask> updateTasks = tasks;
            ClusterService.this.runTasks(new TaskInputs(taskExecutor, updateTasks, tasksSummary));
        }

        class UpdateTask
        extends TaskBatcher.BatchedTask {
            final ClusterStateTaskListener listener;

            UpdateTask(Priority priority, String source, Object task, ClusterStateTaskListener listener, ClusterStateTaskExecutor<?> executor) {
                super(priority, source, executor, task);
                this.listener = listener;
            }

            @Override
            public String describeTasks(List<? extends TaskBatcher.BatchedTask> tasks) {
                return ((ClusterStateTaskExecutor)this.batchingKey).describeTasks(tasks.stream().map(TaskBatcher.BatchedTask::getTask).collect(Collectors.toList()));
            }
        }
    }
}

