/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog;

import java.io.IOException;
import org.elasticsearch.action.support.ToXContentToBytes;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class TranslogStats
extends ToXContentToBytes
implements Streamable {
    private long translogSizeInBytes;
    private int numberOfOperations;

    public TranslogStats() {
    }

    public TranslogStats(int numberOfOperations, long translogSizeInBytes) {
        if (numberOfOperations < 0) {
            throw new IllegalArgumentException("numberOfOperations must be >= 0");
        }
        if (translogSizeInBytes < 0L) {
            throw new IllegalArgumentException("translogSizeInBytes must be >= 0");
        }
        assert (translogSizeInBytes >= 0L) : "translogSizeInBytes must be >= 0, got [" + translogSizeInBytes + "]";
        this.numberOfOperations = numberOfOperations;
        this.translogSizeInBytes = translogSizeInBytes;
    }

    public void add(TranslogStats translogStats) {
        if (translogStats == null) {
            return;
        }
        this.numberOfOperations += translogStats.numberOfOperations;
        this.translogSizeInBytes += translogStats.translogSizeInBytes;
    }

    public long getTranslogSizeInBytes() {
        return this.translogSizeInBytes;
    }

    public long estimatedNumberOfOperations() {
        return this.numberOfOperations;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("translog");
        builder.field("operations", this.numberOfOperations);
        builder.byteSizeField("size_in_bytes", "size", this.translogSizeInBytes);
        builder.endObject();
        return builder;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.numberOfOperations = in.readVInt();
        this.translogSizeInBytes = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.numberOfOperations);
        out.writeVLong(this.translogSizeInBytes);
    }

    static final class Fields {
        static final String TRANSLOG = "translog";
        static final String OPERATIONS = "operations";
        static final String SIZE = "size";
        static final String SIZE_IN_BYTES = "size_in_bytes";

        Fields() {
        }
    }
}

