/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;

public class StoredScriptSource
extends AbstractDiffable<StoredScriptSource>
implements Writeable,
ToXContentObject {
    public static final ParseField SCRIPT_PARSE_FIELD = new ParseField("script", new String[0]);
    public static final ParseField TEMPLATE_PARSE_FIELD = new ParseField("template", new String[0]);
    public static final ParseField LANG_PARSE_FIELD = new ParseField("lang", new String[0]);
    public static final ParseField SOURCE_PARSE_FIELD = new ParseField("source", "code");
    public static final ParseField OPTIONS_PARSE_FIELD = new ParseField("options", new String[0]);
    private static final ObjectParser<Builder, Void> PARSER = new ObjectParser("stored script source", () -> new Builder());
    private final String lang;
    private final String source;
    private final Map<String, String> options;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static StoredScriptSource parse(String lang, BytesReference content, XContentType xContentType) {
        try {
            parser = xContentType.xContent().createParser(NamedXContentRegistry.EMPTY, content);
            var4_5 = null;
            try {
                token = parser.nextToken();
                if (token != XContentParser.Token.START_OBJECT) {
                    throw new ParsingException(parser.getTokenLocation(), "unexpected token [" + (Object)token + "], expected [{]", new Object[0]);
                }
                token = parser.nextToken();
                if (token != XContentParser.Token.FIELD_NAME) {
                    throw new ParsingException(parser.getTokenLocation(), "unexpected token [" + (Object)token + ", expected [" + StoredScriptSource.SCRIPT_PARSE_FIELD.getPreferredName() + ", " + StoredScriptSource.TEMPLATE_PARSE_FIELD.getPreferredName(), new Object[0]);
                }
                name = parser.currentName();
                if (StoredScriptSource.SCRIPT_PARSE_FIELD.getPreferredName().equals(name)) {
                    token = parser.nextToken();
                    if (token == XContentParser.Token.VALUE_STRING) {
                        if (lang == null) {
                            throw new IllegalArgumentException("must specify lang as a url parameter when using the deprecated stored script namespace");
                        }
                        var7_9 = new StoredScriptSource(lang, parser.text(), Collections.emptyMap());
                        return var7_9;
                    }
                    if (token != XContentParser.Token.START_OBJECT) throw new ParsingException(parser.getTokenLocation(), "unexpected token [" + (Object)token + "], expected [{, <source>]", new Object[0]);
                    if (lang == null) {
                        var7_10 = Builder.access$000(StoredScriptSource.PARSER.apply(parser, null));
                        return var7_10;
                    }
                    builder = XContentFactory.jsonBuilder();
                    var8_16 = null;
                    try {
                        builder.copyCurrentStructure(parser);
                        var9_19 = new StoredScriptSource(lang, builder.string(), Collections.emptyMap());
                        return var9_19;
                    }
                    catch (Throwable var9_20) {
                        var8_16 = var9_20;
                        throw var9_20;
                    }
                    finally {
                        if (builder != null) {
                            if (var8_16 != null) {
                                try {
                                    builder.close();
                                }
                                catch (Throwable var10_23) {
                                    var8_16.addSuppressed(var10_23);
                                }
                            } else {
                                builder.close();
                            }
                        }
                    }
                }
                if (lang == null) {
                    throw new IllegalArgumentException("unexpected stored script format");
                }
                ** GOTO lbl50
                {
                    catch (Throwable var5_7) {
                        var4_5 = var5_7;
                        throw var5_7;
                    }
lbl50:
                    // 1 sources

                    if (StoredScriptSource.TEMPLATE_PARSE_FIELD.getPreferredName().equals(name) && (token = parser.nextToken()) == XContentParser.Token.VALUE_STRING) {
                        builder = new StoredScriptSource(lang, parser.text(), Collections.emptyMap());
                        return builder;
                    }
                    builder = XContentFactory.jsonBuilder();
                    var8_18 = null;
                    try {
                        if (token != XContentParser.Token.START_OBJECT) {
                            builder.startObject();
                            builder.copyCurrentStructure(parser);
                            builder.endObject();
                        } else {
                            builder.copyCurrentStructure(parser);
                        }
                        var9_21 = new StoredScriptSource(lang, builder.string(), Collections.emptyMap());
                        return var9_21;
                    }
                    catch (Throwable var9_22) {}
                    {
                        var8_18 = var9_22;
                        throw var9_22;
                    }
                }
            }
            finally {
                if (parser != null) {
                    if (var4_5 != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable var8_14) {
                            var4_5.addSuppressed(var8_14);
                        }
                    } else {
                        parser.close();
                    }
                }
            }
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    public static StoredScriptSource fromXContent(XContentParser parser) throws IOException {
        return StoredScriptSource.PARSER.apply(parser, null).build();
    }

    public static Diff<StoredScriptSource> readDiffFrom(StreamInput in) throws IOException {
        return StoredScriptSource.readDiffFrom(StoredScriptSource::new, in);
    }

    public StoredScriptSource(String source) {
        this.lang = null;
        this.source = Objects.requireNonNull(source);
        this.options = null;
    }

    public StoredScriptSource(String lang, String source, Map<String, String> options) {
        this.lang = Objects.requireNonNull(lang);
        this.source = Objects.requireNonNull(source);
        this.options = Collections.unmodifiableMap(Objects.requireNonNull(options));
    }

    public StoredScriptSource(StreamInput in) throws IOException {
        if (in.getVersion().onOrAfter(Version.V_5_3_0)) {
            this.lang = in.readString();
            this.source = in.readString();
            Map<String, Object> options = in.readMap();
            this.options = options;
        } else {
            this.lang = null;
            this.source = in.readBytesReference().utf8ToString();
            this.options = null;
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_5_3_0)) {
            out.writeString(this.lang);
            out.writeString(this.source);
            Map<String, Object> options = this.options;
            out.writeMap(options);
        } else {
            out.writeBytesReference(new BytesArray(this.source));
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(LANG_PARSE_FIELD.getPreferredName(), this.lang);
        builder.field(SOURCE_PARSE_FIELD.getPreferredName(), this.source);
        builder.field(OPTIONS_PARSE_FIELD.getPreferredName(), this.options);
        builder.endObject();
        return builder;
    }

    public String getLang() {
        return this.lang;
    }

    public String getSource() {
        return this.source;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoredScriptSource that = (StoredScriptSource)o;
        if (this.lang != null ? !this.lang.equals(that.lang) : that.lang != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(that.source) : that.source != null) {
            return false;
        }
        return this.options != null ? this.options.equals(that.options) : that.options == null;
    }

    public int hashCode() {
        int result = this.lang != null ? this.lang.hashCode() : 0;
        result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
        result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "StoredScriptSource{lang='" + this.lang + '\'' + ", source='" + this.source + '\'' + ", options=" + this.options + '}';
    }

    static {
        PARSER.declareString((rec$, x$0) -> ((Builder)rec$).setLang(x$0), LANG_PARSE_FIELD);
        PARSER.declareField((rec$, x$0) -> ((Builder)rec$).setSource(x$0), parser -> parser, SOURCE_PARSE_FIELD, ObjectParser.ValueType.OBJECT_OR_STRING);
        PARSER.declareField((rec$, x$0) -> ((Builder)rec$).setOptions(x$0), XContentParser::mapStrings, OPTIONS_PARSE_FIELD, ObjectParser.ValueType.OBJECT);
    }

    private static final class Builder {
        private String lang;
        private String source;
        private Map<String, String> options = new HashMap<String, String>();

        private Builder() {
        }

        private void setLang(String lang) {
            this.lang = lang;
        }

        private void setSource(XContentParser parser) {
            try {
                if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                    XContentBuilder builder = XContentFactory.jsonBuilder();
                    this.source = builder.copyCurrentStructure(parser).string();
                    this.options.put("content_type", XContentType.JSON.mediaType());
                } else {
                    this.source = parser.text();
                }
            }
            catch (IOException exception) {
                throw new UncheckedIOException(exception);
            }
        }

        private void setOptions(Map<String, String> options) {
            this.options.putAll(options);
        }

        private StoredScriptSource build() {
            if (this.lang == null) {
                throw new IllegalArgumentException("must specify lang for stored script");
            }
            if (this.lang.isEmpty()) {
                throw new IllegalArgumentException("lang cannot be empty");
            }
            if (this.source == null) {
                throw new IllegalArgumentException("must specify source for stored script");
            }
            if (this.source.isEmpty()) {
                throw new IllegalArgumentException("source cannot be empty");
            }
            if (this.options.size() > 1 || this.options.size() == 1 && this.options.get("content_type") == null) {
                throw new IllegalArgumentException("illegal compiler options [" + this.options + "] specified");
            }
            return new StoredScriptSource(this.lang, this.source, this.options);
        }
    }
}

