/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.range;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.range.AbstractRangeBuilder;
import org.elasticsearch.search.aggregations.bucket.range.InternalRange;
import org.elasticsearch.search.aggregations.bucket.range.RangeAggregator;
import org.elasticsearch.search.aggregations.bucket.range.RangeAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceParserHelper;
import org.elasticsearch.search.internal.SearchContext;

public class RangeAggregationBuilder
extends AbstractRangeBuilder<RangeAggregationBuilder, RangeAggregator.Range> {
    public static final String NAME = "range";
    private static final ObjectParser<RangeAggregationBuilder, QueryParseContext> PARSER = new ObjectParser("range");

    public static AggregationBuilder parse(String aggregationName, QueryParseContext context) throws IOException {
        return PARSER.parse(context.parser(), new RangeAggregationBuilder(aggregationName), context);
    }

    private static RangeAggregator.Range parseRange(XContentParser parser, QueryParseContext context) throws IOException {
        return RangeAggregator.Range.fromXContent(parser);
    }

    public RangeAggregationBuilder(String name) {
        super(name, InternalRange.FACTORY);
    }

    public RangeAggregationBuilder(StreamInput in) throws IOException {
        super(in, InternalRange.FACTORY, RangeAggregator.Range::new);
    }

    public RangeAggregationBuilder addRange(String key, double from, double to) {
        this.addRange(new RangeAggregator.Range(key, from, to));
        return this;
    }

    public RangeAggregationBuilder addRange(double from, double to) {
        return this.addRange(null, from, to);
    }

    public RangeAggregationBuilder addUnboundedTo(String key, double to) {
        this.addRange(new RangeAggregator.Range(key, null, to));
        return this;
    }

    public RangeAggregationBuilder addUnboundedTo(double to) {
        return this.addUnboundedTo(null, to);
    }

    public RangeAggregationBuilder addUnboundedFrom(String key, double from) {
        this.addRange(new RangeAggregator.Range(key, from, null));
        return this;
    }

    public RangeAggregationBuilder addUnboundedFrom(double from) {
        return this.addUnboundedFrom(null, from);
    }

    protected RangeAggregatorFactory innerBuild(SearchContext context, ValuesSourceConfig<ValuesSource.Numeric> config, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        RangeAggregator.Range[] ranges = this.processRanges(context, config);
        if (ranges.length == 0) {
            throw new IllegalArgumentException("No [ranges] specified for the [" + this.getName() + "] aggregation");
        }
        return new RangeAggregatorFactory(this.name, config, ranges, this.keyed, this.rangeFactory, context, parent, subFactoriesBuilder, (Map<String, Object>)this.metaData);
    }

    @Override
    public String getType() {
        return NAME;
    }

    static {
        ValuesSourceParserHelper.declareNumericFields(PARSER, true, true, false);
        PARSER.declareBoolean(AbstractRangeBuilder::keyed, RangeAggregator.KEYED_FIELD);
        PARSER.declareObjectArray((agg, ranges) -> {
            for (RangeAggregator.Range range : ranges) {
                agg.addRange(range);
            }
        }, RangeAggregationBuilder::parseRange, RangeAggregator.RANGES_FIELD);
    }
}

