/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.phrase;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Terms;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.search.suggest.phrase.DirectCandidateGenerator;
import org.elasticsearch.search.suggest.phrase.WordScorer;

class StupidBackoffScorer
extends WordScorer {
    private final double discount;

    StupidBackoffScorer(IndexReader reader, Terms terms, String field, double realWordLikelyhood, BytesRef separator, double discount) throws IOException {
        super(reader, terms, field, realWordLikelyhood, separator);
        this.discount = discount;
    }

    double discount() {
        return this.discount;
    }

    @Override
    protected double scoreBigram(DirectCandidateGenerator.Candidate word, DirectCandidateGenerator.Candidate w_1) throws IOException {
        StupidBackoffScorer.join(this.separator, this.spare, w_1.term, word.term);
        long count = this.frequency(this.spare.get());
        if (count < 1L) {
            return this.discount * this.scoreUnigram(word);
        }
        return (double)count / ((double)w_1.frequency + 1.0E-11);
    }

    @Override
    protected double scoreTrigram(DirectCandidateGenerator.Candidate w, DirectCandidateGenerator.Candidate w_1, DirectCandidateGenerator.Candidate w_2) throws IOException {
        StupidBackoffScorer.join(this.separator, this.spare, w_1.term, w.term);
        long bigramCount = this.frequency(this.spare.get());
        if (bigramCount < 1L) {
            return this.discount * this.scoreUnigram(w);
        }
        StupidBackoffScorer.join(this.separator, this.spare, w_2.term, w_1.term, w.term);
        long trigramCount = this.frequency(this.spare.get());
        if (trigramCount < 1L) {
            return this.discount * ((double)bigramCount / ((double)w_1.frequency + 1.0E-11));
        }
        return (double)trigramCount / ((double)bigramCount + 1.0E-11);
    }
}

