/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.transport.TransportAddressSerializers;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public final class RemoteConnectionInfo
implements ToXContent,
Writeable {
    final List<TransportAddress> seedNodes;
    final List<TransportAddress> httpAddresses;
    final int connectionsPerCluster;
    final TimeValue initialConnectionTimeout;
    final int numNodesConnected;
    final String clusterAlias;

    RemoteConnectionInfo(String clusterAlias, List<TransportAddress> seedNodes, List<TransportAddress> httpAddresses, int connectionsPerCluster, int numNodesConnected, TimeValue initialConnectionTimeout) {
        this.clusterAlias = clusterAlias;
        this.seedNodes = seedNodes;
        this.httpAddresses = httpAddresses;
        this.connectionsPerCluster = connectionsPerCluster;
        this.numNodesConnected = numNodesConnected;
        this.initialConnectionTimeout = initialConnectionTimeout;
    }

    public RemoteConnectionInfo(StreamInput input) throws IOException {
        this.seedNodes = input.readList(in -> TransportAddressSerializers.addressFromStream(in));
        this.httpAddresses = input.readList(in -> TransportAddressSerializers.addressFromStream(in));
        this.connectionsPerCluster = input.readVInt();
        this.initialConnectionTimeout = new TimeValue(input);
        this.numNodesConnected = input.readVInt();
        this.clusterAlias = input.readString();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.clusterAlias);
        builder.startArray("seeds");
        for (TransportAddress addr : this.seedNodes) {
            builder.value(addr.toString());
        }
        builder.endArray();
        builder.startArray("http_addresses");
        for (TransportAddress addr : this.httpAddresses) {
            builder.value(addr.toString());
        }
        builder.endArray();
        builder.field("connected", this.numNodesConnected > 0);
        builder.field("num_nodes_connected", this.numNodesConnected);
        builder.field("max_connections_per_cluster", this.connectionsPerCluster);
        builder.field("initial_connect_timeout", this.initialConnectionTimeout);
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.seedNodes.stream().map(a -> RemoteConnectionInfo.getWriteable(a)).collect(Collectors.toList()));
        out.writeList(this.httpAddresses.stream().map(a -> RemoteConnectionInfo.getWriteable(a)).collect(Collectors.toList()));
        out.writeVInt(this.connectionsPerCluster);
        this.initialConnectionTimeout.writeTo(out);
        out.writeVInt(this.numNodesConnected);
        out.writeString(this.clusterAlias);
    }

    private static Writeable getWriteable(TransportAddress address) {
        return out -> TransportAddressSerializers.addressToStream(out, address);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteConnectionInfo that = (RemoteConnectionInfo)o;
        return this.connectionsPerCluster == that.connectionsPerCluster && this.numNodesConnected == that.numNodesConnected && Objects.equals(this.seedNodes, that.seedNodes) && Objects.equals(this.httpAddresses, that.httpAddresses) && Objects.equals(this.initialConnectionTimeout, that.initialConnectionTimeout) && Objects.equals(this.clusterAlias, that.clusterAlias);
    }

    public int hashCode() {
        return Objects.hash(this.seedNodes, this.httpAddresses, this.connectionsPerCluster, this.initialConnectionTimeout, this.numNodesConnected, this.clusterAlias);
    }
}

