/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.io.jts;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.io.Writer;
import java.text.NumberFormat;
import org.locationtech.spatial4j.context.SpatialContextFactory;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import org.locationtech.spatial4j.io.GeoJSONWriter;
import org.locationtech.spatial4j.io.LegacyShapeWriter;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;

public class JtsGeoJSONWriter
extends GeoJSONWriter {
    protected final JtsSpatialContext ctx;

    public JtsGeoJSONWriter(JtsSpatialContext ctx, SpatialContextFactory factory) {
        super(ctx, factory);
        this.ctx = ctx;
    }

    protected void write(Writer output, NumberFormat nf, Coordinate coord) throws IOException {
        output.write(91);
        output.write(nf.format(coord.x));
        output.write(44);
        output.write(nf.format(coord.y));
        output.write(93);
    }

    protected void write(Writer output, NumberFormat nf, CoordinateSequence coordseq) throws IOException {
        output.write(91);
        int dim = coordseq.getDimension();
        for (int i = 0; i < coordseq.size(); ++i) {
            double v;
            if (i > 0) {
                output.write(44);
            }
            output.write(91);
            output.write(nf.format(coordseq.getOrdinate(i, 0)));
            output.write(44);
            output.write(nf.format(coordseq.getOrdinate(i, 1)));
            if (dim > 2 && !Double.isNaN(v = coordseq.getOrdinate(i, 2))) {
                output.write(44);
                output.write(nf.format(v));
            }
            output.write(93);
        }
        output.write(93);
    }

    protected void write(Writer output, NumberFormat nf, Coordinate[] coord) throws IOException {
        output.write(91);
        for (int i = 0; i < coord.length; ++i) {
            if (i > 0) {
                output.append(',');
            }
            this.write(output, nf, coord[i]);
        }
        output.write(93);
    }

    protected void write(Writer output, NumberFormat nf, Polygon p) throws IOException {
        output.write(91);
        this.write(output, nf, p.getExteriorRing().getCoordinateSequence());
        for (int i = 0; i < p.getNumInteriorRing(); ++i) {
            output.append(',');
            this.write(output, nf, p.getInteriorRingN(i).getCoordinateSequence());
        }
        output.write(93);
    }

    public void write(Writer output, Geometry geom) throws IOException {
        NumberFormat nf = LegacyShapeWriter.makeNumberFormat(6);
        if (geom instanceof Point) {
            Point v = (Point)geom;
            output.append("{\"type\":\"Point\",\"coordinates\":");
            this.write(output, nf, v.getCoordinate());
            output.append("}");
            return;
        }
        if (geom instanceof Polygon) {
            output.append("{\"type\":\"Polygon\",\"coordinates\":");
            this.write(output, nf, (Polygon)geom);
            output.append("}");
            return;
        }
        if (geom instanceof LineString) {
            LineString v = (LineString)geom;
            output.append("{\"type\":\"LineString\",\"coordinates\":");
            this.write(output, nf, v.getCoordinateSequence());
            output.append("}");
            return;
        }
        if (geom instanceof MultiPoint) {
            MultiPoint v = (MultiPoint)geom;
            output.append("{\"type\":\"MultiPoint\",\"coordinates\":");
            this.write(output, nf, v.getCoordinates());
            output.append("}");
            return;
        }
        if (geom instanceof MultiLineString) {
            MultiLineString v = (MultiLineString)geom;
            output.append("{\"type\":\"MultiLineString\",\"coordinates\":[");
            for (int i = 0; i < v.getNumGeometries(); ++i) {
                if (i > 0) {
                    output.append(',');
                }
                this.write(output, nf, v.getGeometryN(i).getCoordinates());
            }
            output.append("]}");
        } else if (geom instanceof MultiPolygon) {
            MultiPolygon v = (MultiPolygon)geom;
            output.append("{\"type\":\"MultiPolygon\",\"coordinates\":[");
            for (int i = 0; i < v.getNumGeometries(); ++i) {
                if (i > 0) {
                    output.append(',');
                }
                this.write(output, nf, (Polygon)v.getGeometryN(i));
            }
            output.append("]}");
        } else if (geom instanceof GeometryCollection) {
            GeometryCollection v = (GeometryCollection)geom;
            output.append("{\"type\":\"GeometryCollection\",\"geometries\":[");
            for (int i = 0; i < v.getNumGeometries(); ++i) {
                if (i > 0) {
                    output.append(',');
                }
                this.write(output, v.getGeometryN(i));
            }
            output.append("]}");
        } else {
            throw new UnsupportedOperationException("unknown: " + geom);
        }
    }

    @Override
    public void write(Writer output, Shape shape) throws IOException {
        if (shape == null) {
            throw new NullPointerException("Shape can not be null");
        }
        if (shape instanceof JtsGeometry) {
            this.write(output, ((JtsGeometry)shape).getGeom());
            return;
        }
        super.write(output, shape);
    }
}

