/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.rule.ContextEntry;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Pattern;
import org.drools.core.spi.BetaNodeFieldConstraint;
import org.drools.core.spi.Constraint;
import org.drools.core.spi.Tuple;

public class InstanceEqualsConstraint
implements BetaNodeFieldConstraint {
    private static final long serialVersionUID = 510L;
    private Declaration[] declarations = new Declaration[0];
    private Pattern otherPattern;

    public InstanceEqualsConstraint() {
    }

    public InstanceEqualsConstraint(Pattern otherPattern) {
        this.otherPattern = otherPattern;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.declarations = (Declaration[])in.readObject();
        this.otherPattern = (Pattern)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.declarations);
        out.writeObject(this.otherPattern);
    }

    @Override
    public Declaration[] getRequiredDeclarations() {
        return this.declarations;
    }

    @Override
    public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
    }

    public Pattern getOtherPattern() {
        return this.otherPattern;
    }

    @Override
    public boolean isTemporal() {
        return false;
    }

    @Override
    public ContextEntry createContextEntry() {
        return new InstanceEqualsConstraintContextEntry(this.otherPattern);
    }

    @Override
    public boolean isAllowedCachedLeft(ContextEntry context, InternalFactHandle handle) {
        return ((InstanceEqualsConstraintContextEntry)context).left == handle.getObject();
    }

    @Override
    public boolean isAllowedCachedRight(Tuple tuple, ContextEntry context) {
        return tuple.getObject(this.otherPattern.getOffset()) == ((InstanceEqualsConstraintContextEntry)context).right;
    }

    public String toString() {
        return "[InstanceEqualsConstraint otherPattern=" + this.otherPattern + " ]";
    }

    public int hashCode() {
        return this.otherPattern.hashCode();
    }

    @Override
    public InstanceEqualsConstraint clone() {
        return new InstanceEqualsConstraint(this.otherPattern);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof InstanceEqualsConstraint)) {
            return false;
        }
        InstanceEqualsConstraint other = (InstanceEqualsConstraint)object;
        return this.otherPattern.equals(other.otherPattern);
    }

    @Override
    public Constraint.ConstraintType getType() {
        return Constraint.ConstraintType.BETA;
    }

    @Override
    public BetaNodeFieldConstraint cloneIfInUse() {
        return this;
    }

    public static class InstanceEqualsConstraintContextEntry
    implements ContextEntry {
        private static final long serialVersionUID = 510L;
        public Object left;
        public Object right;
        private Pattern pattern;
        private ContextEntry entry;

        public InstanceEqualsConstraintContextEntry() {
        }

        public InstanceEqualsConstraintContextEntry(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.left = in.readObject();
            this.right = in.readObject();
            this.pattern = (Pattern)in.readObject();
            this.entry = (ContextEntry)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.left);
            out.writeObject(this.right);
            out.writeObject(this.pattern);
            out.writeObject(this.entry);
        }

        @Override
        public ContextEntry getNext() {
            return this.entry;
        }

        @Override
        public void setNext(ContextEntry entry) {
            this.entry = entry;
        }

        @Override
        public void updateFromTuple(InternalWorkingMemory workingMemory, Tuple tuple) {
            this.left = tuple.getObject(this.pattern.getOffset());
        }

        @Override
        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.right = handle.getObject();
        }

        @Override
        public void resetTuple() {
            this.left = null;
        }

        @Override
        public void resetFactHandle() {
            this.right = null;
        }
    }
}

