/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.examples.validation;

import java.util.Optional;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.kie.workbench.common.screens.examples.model.ExampleProjectError;
import org.kie.workbench.common.screens.examples.model.ImportProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;

public abstract class ImportProjectValidator {
    public static final String POM_XML = "pom.xml";
    private Logger logger = LoggerFactory.getLogger(ImportProjectValidator.class);

    public Optional<ExampleProjectError> validate(OrganizationalUnit organizationalUnit, ImportProject importProject) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Validation project [{}]", (Object)importProject.getName());
        }
        Optional<ExampleProjectError> error = this.getError(organizationalUnit, importProject);
        if (this.logger.isDebugEnabled() && error.isPresent()) {
            this.logger.debug("Error found [{} - {} - {}]", new Object[]{importProject.getName(), error.get().getId(), error.get().getDescription()});
        }
        return error;
    }

    protected abstract Optional<ExampleProjectError> getError(OrganizationalUnit var1, ImportProject var2);

    protected POM getPom(POMService pomService, Path rootPath) {
        String rootPathUri = rootPath.toURI();
        String pomUri = POM_XML;
        if (!rootPathUri.endsWith("/")) {
            pomUri = "/" + pomUri;
        }
        Path pomPath = PathFactory.newPath((String)POM_XML, (String)(rootPathUri + pomUri));
        return (POM)pomService.load(pomPath);
    }
}

