/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.impl.authz;

import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.mvp.Command;
import org.uberfire.security.authz.AuthorizationCheck;
import org.uberfire.security.authz.AuthorizationResult;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionCheck;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.security.authz.VotingStrategy;

public class PermissionCheckImpl
implements PermissionCheck {
    protected PermissionManager permissionManager;
    protected String permission;
    protected User user;
    protected VotingStrategy votingStrategy;
    protected Boolean result = null;

    public PermissionCheckImpl(PermissionManager permissionManager, String permission, User user, VotingStrategy votingStrategy) {
        this.permissionManager = permissionManager;
        this.permission = permission;
        this.user = user;
        this.votingStrategy = votingStrategy;
    }

    protected void check() {
        Permission p = this.permissionManager.createPermission(this.permission, true);
        AuthorizationResult authz = this.permissionManager.checkPermission(p, this.user, this.votingStrategy);
        this.result = !AuthorizationResult.ACCESS_DENIED.equals((Object)authz);
    }

    public AuthorizationCheck granted(Command onGranted) {
        if (this.result()) {
            onGranted.execute();
        }
        return this;
    }

    public AuthorizationCheck denied(Command onDenied) {
        if (!this.result()) {
            onDenied.execute();
        }
        return this;
    }

    @Override
    public boolean result() {
        if (this.result == null) {
            this.check();
        }
        return this.result;
    }
}

