/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.backend.version;

import java.net.URI;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.editor.commons.backend.version.PathResolver;
import org.uberfire.ext.editor.commons.backend.version.VersionRecordService;
import org.uberfire.ext.editor.commons.backend.version.VersionUtil;
import org.uberfire.ext.editor.commons.version.VersionService;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.StandardCopyOption;
import org.uberfire.rpc.SessionInfo;

@Service
@ApplicationScoped
public class VersionServiceImpl
implements VersionService {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private SessionInfo sessionInfo;
    @Inject
    private VersionRecordService versionRecordService;
    @Inject
    private PathResolver pathResolver;
    @Inject
    private VersionUtil versionUtil;

    public List<VersionRecord> getVersions(org.uberfire.backend.vfs.Path path) {
        try {
            return this.versionRecordService.load(Paths.convert((org.uberfire.backend.vfs.Path)path));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public org.uberfire.backend.vfs.Path getPathToPreviousVersion(String uri) {
        return Paths.convert((Path)this.ioService.get(URI.create(uri)));
    }

    public org.uberfire.backend.vfs.Path restore(org.uberfire.backend.vfs.Path _path, String comment, String branchName) {
        try {
            this.ioService.startBatch(Paths.convert((org.uberfire.backend.vfs.Path)_path).getFileSystem());
            Path path = this.pathResolver.resolveMainFilePath(Paths.convert((org.uberfire.backend.vfs.Path)_path));
            Path target = this.versionUtil.getPath(path, branchName);
            org.uberfire.backend.vfs.Path path2 = Paths.convert((Path)this.ioService.copy(path, target, new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, new CommentedOption(this.sessionInfo != null ? this.sessionInfo.getId() : "--", this.sessionInfo != null ? this.sessionInfo.getIdentity().getIdentifier() : "system", null, comment)}));
            return path2;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.ioService.endBatch();
        }
    }
}

