/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.api.projectstage;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.enterprise.inject.Typed;
import org.apache.deltaspike.core.api.projectstage.ProjectStageHolder;
import org.apache.deltaspike.core.api.projectstage.TestStage;
import org.apache.deltaspike.core.util.ServiceUtils;

@Typed
public abstract class ProjectStage
implements Serializable {
    private static final long serialVersionUID = -1210639662598734888L;
    private static Map<String, ProjectStage> projectStages = new HashMap<String, ProjectStage>();
    private static ProjectStage[] values = null;
    private static final Logger LOG = Logger.getLogger(ProjectStage.class.getName());
    private String psName;
    public static final UnitTest UnitTest;
    public static final Development Development;
    public static final SystemTest SystemTest;
    public static final IntegrationTest IntegrationTest;
    public static final Staging Staging;
    public static final Production Production;

    protected ProjectStage() {
        String projectStageClassName;
        this.psName = projectStageClassName = this.getClass().getSimpleName();
        ProjectStage.init(projectStageClassName, this);
    }

    private static void init(String projectStageClassName, ProjectStage projectStage) {
        if (projectStages.containsKey(projectStageClassName)) {
            throw new IllegalArgumentException("ProjectStage with name " + projectStageClassName + " already exists!");
        }
        projectStages.put(projectStageClassName, projectStage);
        values = projectStages.values().toArray(new ProjectStage[projectStages.size()]);
    }

    public static ProjectStage valueOf(String projectStageClassName) {
        return projectStages.get(projectStageClassName);
    }

    public static ProjectStage[] values() {
        ProjectStage[] result = new ProjectStage[values.length];
        System.arraycopy(values, 0, result, 0, values.length);
        return result;
    }

    public String toString() {
        return this.psName;
    }

    static {
        List<ProjectStageHolder> projectStageHolders = ServiceUtils.loadServiceImplementations(ProjectStageHolder.class);
        for (ProjectStageHolder projectStageHolder : projectStageHolders) {
            LOG.fine("registering ProjectStages from ProjectStageHolder " + projectStageHolder.getClass().getName());
        }
        UnitTest = new UnitTest();
        Development = new Development();
        SystemTest = new SystemTest();
        IntegrationTest = new IntegrationTest();
        Staging = new Staging();
        Production = new Production();
    }

    @Typed
    public static final class Production
    extends ProjectStage {
        private static final long serialVersionUID = -4030601958667812084L;
    }

    @Typed
    public static final class Staging
    extends ProjectStage {
        private static final long serialVersionUID = -8426149532860809553L;
    }

    @Typed
    public static final class IntegrationTest
    extends ProjectStage
    implements TestStage {
        private static final long serialVersionUID = 2034474361615347127L;
    }

    @Typed
    public static final class SystemTest
    extends ProjectStage
    implements TestStage {
        private static final long serialVersionUID = -7444003351466372539L;
    }

    @Typed
    public static final class Development
    extends ProjectStage {
        private static final long serialVersionUID = 1977308277341527250L;
    }

    @Typed
    public static final class UnitTest
    extends ProjectStage
    implements TestStage {
        private static final long serialVersionUID = -7910349894182034559L;
    }
}

