/*
 * Decompiled with CFR 0.152.
 */
package org.lesscss;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.lesscss.LessException;
import org.lesscss.LessSource;
import org.lesscss.deps.org.apache.commons.io.FileUtils;
import org.lesscss.logging.LessLogger;
import org.lesscss.logging.LessLoggerFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.tools.shell.Global;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LessCompiler {
    private static final LessLogger logger = LessLoggerFactory.getLogger(LessCompiler.class);
    private URL lessJs = LessCompiler.class.getClassLoader().getResource("META-INF/less-rhino-1.7.0.js");
    private URL lesscJs = LessCompiler.class.getClassLoader().getResource("META-INF/lessc-rhino-1.7.0.js");
    private List<URL> customJs = Collections.emptyList();
    private List<String> options = Collections.emptyList();
    private Boolean compress = null;
    private String encoding = null;
    private Scriptable scope;
    private ByteArrayOutputStream out;
    private Function compiler;

    public LessCompiler() {
    }

    public LessCompiler(List<String> options) {
        this.options = new ArrayList<String>(options);
    }

    public List<String> getOptions() {
        return Collections.unmodifiableList(this.options);
    }

    public void setOptions(List<String> options) {
        if (this.scope != null) {
            throw new IllegalStateException("This method can only be called before init()");
        }
        this.options = new ArrayList<String>(options);
    }

    public URL getEnvJs() {
        throw new IllegalArgumentException("EnvJs is no longer supported.  You don't need this if you use a less-rhino-<version>.js build like the default.");
    }

    public synchronized void setEnvJs(URL envJs) {
        throw new IllegalArgumentException("EnvJs is no longer supported.  You don't need this if you use a less-rhino-<version>.js build like the default.");
    }

    public URL getLessJs() {
        return this.lessJs;
    }

    public synchronized void setLessJs(URL lessJs) {
        if (this.scope != null) {
            throw new IllegalStateException("This method can only be called before init()");
        }
        this.lessJs = lessJs;
    }

    public URL getLesscJs() {
        return this.lesscJs;
    }

    public synchronized void setLesscJs(URL lesscJs) {
        if (this.scope != null) {
            throw new IllegalStateException("This method can only be called before init()");
        }
        this.lesscJs = lesscJs;
    }

    public List<URL> getCustomJs() {
        return Collections.unmodifiableList(this.customJs);
    }

    public synchronized void setCustomJs(URL customJs) {
        if (this.scope != null) {
            throw new IllegalStateException("This method can only be called before init()");
        }
        this.customJs = Collections.singletonList(customJs);
    }

    public synchronized void setCustomJs(List<URL> customJs) {
        if (this.scope != null) {
            throw new IllegalStateException("This method can only be called before init()");
        }
        this.customJs = new ArrayList<URL>(customJs);
    }

    public boolean isCompress() {
        return this.compress != null && this.compress != false || this.options.contains("compress") || this.options.contains("x");
    }

    public synchronized void setCompress(boolean compress) {
        if (this.scope != null) {
            throw new IllegalStateException("This method can only be called before init()");
        }
        this.compress = compress;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public synchronized void setEncoding(String encoding) {
        if (this.scope != null) {
            throw new IllegalStateException("This method can only be called before init()");
        }
        this.encoding = encoding;
    }

    public synchronized void init() {
        long start = System.currentTimeMillis();
        try {
            Context cx = Context.enter();
            cx.setLanguageVersion(170);
            Global global = new Global();
            global.init(cx);
            this.scope = cx.initStandardObjects((ScriptableObject)global);
            this.scope.put("logger", this.scope, (Object)Context.toObject((Object)logger, (Scriptable)this.scope));
            this.out = new ByteArrayOutputStream();
            global.setOut(new PrintStream(this.out));
            ArrayList<InputStream> streams = new ArrayList<InputStream>();
            streams.add(this.lessJs.openConnection().getInputStream());
            for (URL url : this.customJs) {
                streams.add(url.openConnection().getInputStream());
            }
            streams.add(this.lesscJs.openConnection().getInputStream());
            InputStreamReader reader = new InputStreamReader(new SequenceInputStream(Collections.enumeration(streams)));
            this.compiler = (Function)cx.compileReader((Reader)reader, this.lessJs.toString(), 1, null);
        }
        catch (Exception e) {
            String message = "Failed to initialize LESS compiler.";
            logger.error(message, e);
            throw new IllegalStateException(message, e);
        }
        finally {
            Context.exit();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Finished initialization of LESS compiler in %,d ms.%n", System.currentTimeMillis() - start);
        }
    }

    public String compile(String input) throws LessException {
        return this.compile(input, "<inline>");
    }

    public String compile(String input, String name) throws LessException {
        File tempFile = null;
        try {
            tempFile = File.createTempFile("tmp", "less.tmp");
            FileUtils.writeStringToFile(tempFile, input, this.encoding);
            String string = this.compile(tempFile, name);
            return string;
        }
        catch (IOException e) {
            throw new LessException(e);
        }
        finally {
            tempFile.delete();
        }
    }

    public synchronized String compile(File input, String name) throws LessException {
        if (this.scope == null) {
            this.init();
        }
        long start = System.currentTimeMillis();
        try {
            Context cx = Context.enter();
            ScriptableObject compileScope = (ScriptableObject)cx.newObject(this.scope);
            compileScope.setPrototype(this.scope);
            compileScope.setParentScope(null);
            ArrayList<String> options = new ArrayList<String>(this.options);
            options.add(input.getAbsolutePath());
            if (this.compress != null && this.compress.booleanValue()) {
                options.add("-x");
            }
            Scriptable argsObj = cx.newArray((Scriptable)compileScope, options.toArray(new Object[options.size()]));
            compileScope.defineProperty("arguments", (Object)argsObj, 2);
            this.compiler.call(cx, (Scriptable)compileScope, null, new Object[0]);
            if (logger.isDebugEnabled()) {
                logger.debug("Finished compilation of LESS source in %,d ms.", System.currentTimeMillis() - start);
            }
            String string = this.encoding != null && !this.encoding.equals("") ? this.out.toString(this.encoding) : this.out.toString();
            return string;
        }
        catch (Exception e) {
            Scriptable value;
            if (e instanceof JavaScriptException && (value = (Scriptable)((JavaScriptException)e).getValue()) != null) {
                StringBuilder message = new StringBuilder();
                if (ScriptableObject.hasProperty((Scriptable)value, (String)"filename")) {
                    message.append(ScriptableObject.getProperty((Scriptable)value, (String)"filename").toString());
                }
                if (ScriptableObject.hasProperty((Scriptable)value, (String)"line")) {
                    message.append("@(");
                    message.append(ScriptableObject.getProperty((Scriptable)value, (String)"line").toString());
                    message.append(",");
                    message.append(ScriptableObject.getProperty((Scriptable)value, (String)"column").toString());
                    message.append(")");
                }
                if (ScriptableObject.hasProperty((Scriptable)value, (String)"message")) {
                    if (message.length() > 0) {
                        message.append(": ");
                    }
                    message.append(ScriptableObject.getProperty((Scriptable)value, (String)"message").toString());
                }
                if (ScriptableObject.hasProperty((Scriptable)value, (String)"extract")) {
                    List lines = (List)ScriptableObject.getProperty((Scriptable)value, (String)"extract");
                    for (String line : lines) {
                        if (line == null) continue;
                        message.append("\n");
                        message.append(line);
                    }
                }
                throw new LessException(message.toString(), e);
            }
            throw new LessException(e);
        }
        finally {
            this.out.reset();
            Context.exit();
        }
    }

    public String compile(File input) throws IOException, LessException {
        return this.compile(input, input.getName());
    }

    public void compile(File input, File output) throws IOException, LessException {
        this.compile(input, output, true);
    }

    public void compile(File input, File output, boolean force) throws IOException, LessException {
        if (force || !output.exists() || output.lastModified() < input.lastModified()) {
            String data = this.compile(input);
            FileUtils.writeStringToFile(output, data, this.encoding);
        }
    }

    public String compile(LessSource input) throws LessException {
        return this.compile(input.getNormalizedContent(), input.getName());
    }

    public void compile(LessSource input, File output) throws IOException, LessException {
        this.compile(input, output, true);
    }

    public void compile(LessSource input, File output, boolean force) throws IOException, LessException {
        if (force || !output.exists() || output.lastModified() < input.getLastModifiedIncludingImports()) {
            String data = this.compile(input);
            FileUtils.writeStringToFile(output, data, this.encoding);
        }
    }
}

