/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.migration.legacy.services.impl.util;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.xerces.impl.dv.util.Base64;
import org.apache.xerces.util.XMLChar;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLNode
implements Serializable {
    private String objectName;
    private Properties attributes = new Properties();
    private List<XMLNode> children = new ArrayList<XMLNode>();
    private byte[] content;
    private List warnings = new ArrayList();
    private List warningArguments = new ArrayList();
    private XMLNode parent;
    private static final String INDENT_STR = "    ";

    public XMLNode(String objectName, XMLNode parent) {
        this.parent = parent;
        this.objectName = objectName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public Properties getAttributes() {
        return this.attributes;
    }

    public List<XMLNode> getChildren() {
        return this.children;
    }

    public List getWarnings() {
        return this.warnings;
    }

    public List getWarningArguments() {
        return this.warningArguments;
    }

    public XMLNode getParent() {
        return this.parent;
    }

    public Object addAttribute(String name, String value) {
        if (name != null) {
            if (value == null) {
                return this.attributes.remove(name);
            }
            return this.attributes.setProperty(name, value);
        }
        return null;
    }

    public void addChild(XMLNode node) {
        this.children.add(node);
    }

    public void addWarning(String warning, Object[] arguments) {
        this.warnings.add(warning);
        this.warningArguments.add(arguments);
    }

    public void addWarning(String warning, Object arguments) {
        this.warnings.add(warning);
        this.warningArguments.add(new Object[]{arguments});
    }

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public void writeXML(Writer writer, boolean blanks) throws IOException {
        this.writeXML(writer, blanks, false);
    }

    public void writeXML(Writer writer, boolean blanks, boolean indent) throws IOException {
        String indentStr = null;
        if (blanks) {
            writer.write("\n");
            if (indent) {
                indentStr = this.indentStr(this.indent());
                writer.write(indentStr);
            }
        }
        writer.write("<");
        writer.write(this.objectName);
        for (String string : this.attributes.keySet()) {
            String attributeValue = this.attributes.getProperty(string, "");
            writer.write(" " + string + "=\"" + XMLNode.escapeXml(attributeValue) + "\"");
        }
        if (this.children.isEmpty() && this.content == null) {
            writer.write("/>");
        } else {
            writer.write(">");
            for (int i = 0; i < this.children.size(); ++i) {
                XMLNode xMLNode = this.children.get(i);
                xMLNode.writeXML(writer, blanks, indent);
            }
            if (this.content != null) {
                writer.write(Base64.encode((byte[])this.content));
            } else if (blanks) {
                writer.write("\n");
                if (indent) {
                    writer.write(indentStr);
                }
            }
            writer.write("</");
            writer.write(this.objectName);
            writer.write(">");
        }
        writer.flush();
    }

    public void loadFromXMLNode(Node node) {
        this.objectName = node.getNodeName();
        NamedNodeMap attributesMap = node.getAttributes();
        if (attributesMap != null) {
            for (int i = 0; i < attributesMap.getLength(); ++i) {
                Node attribute = attributesMap.item(i);
                this.addAttribute(attribute.getNodeName(), StringEscapeUtils.unescapeXml((String)attribute.getNodeValue()));
            }
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeName().equals("#text")) {
                String content = child.getNodeValue();
                if (content == null || content.trim().length() <= 0) continue;
                this.setContent(Base64.decode((String)child.getNodeValue().trim()));
                continue;
            }
            XMLNode childNode = new XMLNode("?", this);
            childNode.loadFromXMLNode(child);
            this.addChild(childNode);
        }
    }

    public int indent() {
        if (this.getParent() != null) {
            return 1 + this.getParent().indent();
        }
        return 0;
    }

    public static String escapeXml(String s) {
        s = StringEscapeUtils.escapeXml((String)s);
        StringBuffer dest = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!XMLChar.isValid((int)c)) continue;
            dest.append(c);
        }
        return dest.toString();
    }

    public String indentStr(int indent) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("");
        for (int i = 0; i < indent; ++i) {
            stringBuffer.append(INDENT_STR);
        }
        return stringBuffer.toString();
    }
}

